// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

public class Properties
{
    //
    // The Properties singleton
    //
    protected static Properties instance_ = null;

    //
    // Properties data
    //
    protected java.util.Properties props_ = new java.util.Properties();

    //
    // Load the properties from a file
    //
    protected void
    load(String name)
    {
	MessageViewer viewer = MessageViewer.instance();

	java.io.InputStream in = null;

	//
	// Try to open URL connection first
	//
	try
	{
	    java.net.URL url = new java.net.URL(name);
	    in = url.openStream();
	}
	catch(java.net.MalformedURLException e)
	{
	    //
	    // Try to open plain file, if `name' is not a URL specification
	    //
	    try
	    {
		in = new java.io.FileInputStream(name);
	    }
	    catch(java.io.FileNotFoundException ex)
	    {
		viewer.warning("Properties: configuration file `" + name +
			       "' not found");
		return;
	    }
	}
	catch(java.io.IOException ex)
	{
	    MessageViewer.instance().warning("Properties: unable to access " +
					     "configuration file `" +
					     name + "'");
	    return;
	}

	if(in == null)
	    throw new InternalError();

	try
	{
	    java.io.BufferedInputStream bin =
		new java.io.BufferedInputStream(in);
	    props_.load(bin);
	    in.close();
	}
	catch(java.io.IOException ex)
	{
	    viewer.warning("Properties: error occurred while reading " +
			   "configuration file `" + name + "'");
	}
    }

    //
    // Constructor
    //
    protected
    Properties()
    {
	if(instance_ != null)
	    throw new InternalError();
	instance_ = this;
    }

    //
    // Set a property
    //
    public void
    setProperty(String name, String value)
    {
	props_.put(name, value);
    }

    //
    // Get property
    //
    public String
    getProperty(String name)
    {
	return props_.getProperty(name);
    }

    //
    // Get all property keys starting with prefix
    //
    public String[]
    getKeys(String prefix)
    {
	java.util.Vector vec = new java.util.Vector();
	java.util.Enumeration e = props_.propertyNames();
	while(e.hasMoreElements())
	{
	    String key = (String)e.nextElement();
	    if(key.startsWith(prefix))
		vec.addElement(key);
	}

	String[] result = new String[vec.size()];
	vec.copyInto(result);
	return result;
    }

    //
    // Get all property keys
    //
    public String[]
    getKeys()
    {
	java.util.Vector vec = new java.util.Vector();
	java.util.Enumeration e = props_.propertyNames();
	while(e.hasMoreElements())
	    vec.addElement(e.nextElement());

	String[] result = new String[vec.size()];
	vec.copyInto(result);
	return result;
    }

    //
    // Merge a set of properties
    //
    public void
    merge(java.util.Properties properties)
    {
	java.util.Enumeration e = properties.propertyNames();
	while(e.hasMoreElements())
	{
	    String key = (String)e.nextElement();
	    setProperty(key, properties.getProperty(key));
	}
    }

    //
    // Get the properties singleton. This may be null, if the
    // properties have not yet been initialized.
    //
    public static Properties
    instance()
    {
	return instance_;
    }

    //
    // Initialize the properties
    //
    public static Properties
    init(String[] args)
    {
	Properties properties = instance();
	if(properties != null)
	    return properties;

	MessageViewer viewer = MessageViewer.instance();

	String configFile = null;

	//
	// First scan through the argument list looking for the config
	// file variable. We need to do this since command line arguments
	// have precendence over the environment variables.
	//
	int i = 0;
	while(i < args.length)
	{
	    if(args[i].equals("-ORBconfig"))
	    {
		if(i + 1 >= args.length)
		{
		    viewer.error("Properties.init: argument expected for " +
				 "-ORBconfig");
		    throw new org.omg.CORBA.INITIALIZE();
		}

		configFile = args[i + 1];
		break;
	    }
	    else
		++i;
	}

	properties = new Properties();

	//
	// Read the configuration file
	//
	try
	{
	    if(configFile == null)
		configFile = System.getProperty("ooc.config");
	}
	catch(java.lang.SecurityException ex)
	{
	    // ignore - may be thrown by applet
	}

	if(configFile != null)
	    properties.load(configFile);

	return properties;
    }
}
