// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class Request extends org.omg.CORBA.Request
{
    private ORBSingleton orb_;
    private org.omg.CORBA.Object target_;
    private Delegate delegate_;
    private String operation_;
    private org.omg.CORBA.NVList arguments_;
    private org.omg.CORBA.NamedValue result_;
    private org.omg.CORBA.Environment environment_;
    private org.omg.CORBA.ExceptionList exceptions_;
    private org.omg.CORBA.ContextList contexts_;
    private org.omg.CORBA.Context ctx_;
    private int reqId_;

    // ------------------------------------------------------------------
    // Private and protected functions
    // ------------------------------------------------------------------

    private OutputStream
    marshal()
    {
	Client clt = delegate_._OB_client();
	if(clt == null)
	    throw new org.omg.CORBA.NO_IMPLEMENT();

	int offset = clt.offset(delegate_, operation_);
	OutputStream out = new OutputStream(offset > 1024 ? offset : 1024);
	out.count_ = offset;

	try
	{
	    for(int i = 0 ; i < arguments_.count() ; i++)
	    {
		org.omg.CORBA.NamedValue nv = arguments_.item(i);
		if(nv.flags() != org.omg.CORBA.ARG_OUT.value)
		    nv.value().write_value(out);
	    }
        }
	catch(org.omg.CORBA.Bounds ex)
	{
	    throw new InternalError();
	}

	if(ctx_ != null)
	{
	    java.util.Vector ctxVec = new java.util.Vector();

	    try
	    {
		for(int i = 0 ; i < contexts_.count() ; i++)
		{
		    String item = contexts_.item(i);
		    ((Context)ctx_)._OB_getValues("", 0, item, ctxVec);
		}
	    }
	    catch(org.omg.CORBA.Bounds ex)
	    {
		throw new InternalError();
	    }

	    out.write_ulong(ctxVec.size());
	    for(int i = 0 ; i < ctxVec.size() ; i++)
		out.write_string((String)ctxVec.elementAt(i));
	}

	return out;
    }

    private void
    unmarshal(InputStream in, boolean exc)
    {
	if(exc)
	{
	    int pos = in.pos_;
	    String id = in.read_string();
	    in.pos_ = pos;

	    try
	    {
		for(int i = 0 ; i < exceptions_.count() ; i++)
		{
		    org.omg.CORBA.TypeCode tc = exceptions_.item(i);
		    if(tc.id().equals(id))
		    {
			org.omg.CORBA.Any any = orb_.create_any();
			any.read_value(in, tc);
			org.omg.CORBA.UnknownUserException ex =
			    new org.omg.CORBA.UnknownUserException(any);
			environment_.exception(ex);
			return;
		    }
		}
	    }
	    catch(org.omg.CORBA.Bounds ex)
	    {
		throw new InternalError();
	    }
	    catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	    {
		throw new InternalError();
	    }
	
	    environment_.exception(new org.omg.CORBA.UNKNOWN());
	    return;
	}

	org.omg.CORBA.Any any = result_.value();
	any.read_value(in, any.type());
    
	try
	{
	    for(int i = 0 ; i < arguments_.count() ; i++)
	    {
		org.omg.CORBA.NamedValue nv = arguments_.item(i);
		if(nv.flags() != org.omg.CORBA.ARG_IN.value)
		{
		    any = nv.value();
		    any.read_value(in, any.type());
		}
	    }
	}
	catch(org.omg.CORBA.Bounds ex)
	{
	    throw new InternalError();
	}
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public org.omg.CORBA.Object
    target()
    {
	return target_;
    }

    public String
    operation()
    {
	return operation_;
    }

    public org.omg.CORBA.NVList
    arguments()
    {
	return arguments_;
    }

    public org.omg.CORBA.NamedValue
    result()
    {
	return result_;
    }

    public org.omg.CORBA.Environment
    env()
    {
	return environment_;
    }

    public org.omg.CORBA.ExceptionList
    exceptions()
    {
	return exceptions_;
    }

    public org.omg.CORBA.ContextList
    contexts()
    {
	return contexts_;
    }

    public org.omg.CORBA.Context
    ctx()
    {
	return ctx_;
    }

    public void
    ctx(org.omg.CORBA.Context c)
    {
	ctx_ = c;
    }

    public org.omg.CORBA.Any
    add_in_arg()
    {
	return (arguments_.add(org.omg.CORBA.ARG_IN.value)).value();
    }

    public org.omg.CORBA.Any
    add_named_in_arg(String name)
    {
	return (arguments_.add_item(name,
				    org.omg.CORBA.ARG_IN.value)).value();
    }

    public org.omg.CORBA.Any
    add_inout_arg()
    {
	return (arguments_.add(org.omg.CORBA.ARG_INOUT.value)).value();
    }

    public org.omg.CORBA.Any
    add_named_inout_arg(String name)
    {
	return (arguments_.add_item(name,
				    org.omg.CORBA.ARG_INOUT.value)).value();
    }

    public org.omg.CORBA.Any
    add_out_arg()
    {
	return (arguments_.add(org.omg.CORBA.ARG_OUT.value)).value();
    }

    public org.omg.CORBA.Any
    add_named_out_arg(String name)
    {
	return (arguments_.add_item(name,
				    org.omg.CORBA.ARG_OUT.value)).value();
    }

    public void
    set_return_type(org.omg.CORBA.TypeCode tc)
    {
	result_.value().type(tc);
    }

    public org.omg.CORBA.Any
    return_value()
    {
	return result_.value();
    }

    public void
    invoke()
    {
	try
	{
	    OutputStream out = marshal();
	    
	    Client clt = delegate_._OB_client();
	    if(clt == null)
		throw new org.omg.CORBA.NO_IMPLEMENT();
	    
	    org.omg.CORBA.BooleanHolder exc
		= new org.omg.CORBA.BooleanHolder();
	    org.omg.CORBA.BooleanHolder fwd
		= new org.omg.CORBA.BooleanHolder();

	    InputStream in;

	    in = clt.request(delegate_, operation_, out, exc, fwd,
			     delegate_.timeout(), delegate_.retry());
	    
	    if(in == null)
		throw new InternalError();

	    if(fwd.value)
	    {
		org.omg.IOP.IOR ior = org.omg.IOP.IORHelper.read(in);
		delegate_._OB_orb()._OB_changeDelegate(delegate_, ior);
		invoke();
		return;
	    }
	    
	    unmarshal(in, exc.value);
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    environment_.exception(ex);
            if(ORB._OB_raiseDIIExceptions())
                throw ex;
	}
    }

    public void
    send_oneway()
    {
	try
	{
	    OutputStream out = marshal();
		
	    Client clt = delegate_._OB_client();
	    if(clt == null)
		throw new org.omg.CORBA.NO_IMPLEMENT();
	    
	    clt.oneway(delegate_, operation_, out, delegate_.retry());

	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    environment_.exception(ex);
            if(ORB._OB_raiseDIIExceptions())
                throw ex;
	}
    }

    public void
    send_deferred()
    {
	try
	{
	    OutputStream out = marshal();
	    
	    Client clt = delegate_._OB_client();
	    if(clt == null)
		throw new org.omg.CORBA.NO_IMPLEMENT();
	    
	    org.omg.CORBA.IntHolder reqId
		= new org.omg.CORBA.IntHolder();

	    clt.deferred(delegate_, operation_, out, reqId, delegate_.retry());

	    reqId_ = reqId.value;
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    environment_.exception(ex);
            if(ORB._OB_raiseDIIExceptions())
                throw ex;
	}
    }

    public void
    get_response()
    {
	try
	{
	    Client clt = delegate_._OB_client();
	    if(clt == null)
		throw new org.omg.CORBA.NO_IMPLEMENT();
	    
	    org.omg.CORBA.BooleanHolder exc
		= new org.omg.CORBA.BooleanHolder();
	    org.omg.CORBA.BooleanHolder fwd
		= new org.omg.CORBA.BooleanHolder();

	    InputStream in =
		clt.response(reqId_, exc, fwd, delegate_.timeout());
	    
	    if(in == null)
		throw new InternalError();

	    if(fwd.value)
	    {
		org.omg.IOP.IOR ior = org.omg.IOP.IORHelper.read(in);
		delegate_._OB_orb()._OB_changeDelegate(delegate_, ior);
		get_response();
		return;
	    }
	    
	    unmarshal(in, exc.value);
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    environment_.exception(ex);
            if(ORB._OB_raiseDIIExceptions())
                throw ex;
	}
    }

    public boolean
    poll_response()
    {
	try
	{
	    Client clt = delegate_._OB_client();
	    if(clt == null)
		throw new org.omg.CORBA.NO_IMPLEMENT();
	    
	    org.omg.CORBA.BooleanHolder exc
		= new org.omg.CORBA.BooleanHolder();
	    org.omg.CORBA.BooleanHolder fwd
		= new org.omg.CORBA.BooleanHolder();

	    InputStream in = clt.poll(reqId_, exc, fwd);

	    if(in == null)
		return false;
	    
	    if(fwd.value)
	    {
		org.omg.IOP.IOR ior = org.omg.IOP.IORHelper.read(in);
		delegate_._OB_orb()._OB_changeDelegate(delegate_, ior);
		return poll_response();
	    }
	    
	    unmarshal(in, exc.value);
	    return true;
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    environment_.exception(ex);
            if(ORB._OB_raiseDIIExceptions())
                throw ex;
	    return true;
	}
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    Request(org.omg.CORBA.Object object,
	    String operation)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();

	target_ = object;
	org.omg.CORBA.portable.ObjectImpl target =
	    (org.omg.CORBA.portable.ObjectImpl)target_;
	delegate_ = (Delegate)(target._get_delegate());
	operation_ = operation;

	arguments_ = new NVList();
	result_ = new NamedValue("", orb_.create_any(),
				 org.omg.CORBA.ARG_OUT.value);
	environment_ = new Environment();
	exceptions_ = new ExceptionList();
	contexts_ = new ContextList();
	reqId_ = 0;
    }

    Request(org.omg.CORBA.Object object,
	    String operation,
	    org.omg.CORBA.NVList arg_list,
	    org.omg.CORBA.NamedValue result)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();

	target_ = object;
	org.omg.CORBA.portable.ObjectImpl target =
	    (org.omg.CORBA.portable.ObjectImpl)target_;
	delegate_ = (Delegate)(target._get_delegate());
	operation_ = operation;
	arguments_ = arg_list;
	result_ = result;

	environment_ = new Environment();
	exceptions_ = new ExceptionList();
	contexts_ = new ContextList();
	reqId_ = 0;
    }

    Request(org.omg.CORBA.Object object,
	    String operation,
	    org.omg.CORBA.NVList arg_list,
	    org.omg.CORBA.NamedValue result,
	    org.omg.CORBA.ExceptionList exclist,
	    org.omg.CORBA.ContextList ctxlist)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();

	target_ = object;
	org.omg.CORBA.portable.ObjectImpl target =
	    (org.omg.CORBA.portable.ObjectImpl)target_;
	delegate_ = (Delegate)(target._get_delegate());
	operation_ = operation;
	arguments_ = arg_list;
	result_ = result;
	exceptions_ = exclist;
	contexts_ = ctxlist;

	environment_ = new Environment();
	reqId_ = 0;
    }
}

