// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class ServerRequest extends org.omg.CORBA.ServerRequest
{
    private String name_;
    private org.omg.CORBA.portable.InputStream in_;
    private org.omg.CORBA.Context ctx_;
    private org.omg.CORBA.NVList params_;
    private org.omg.CORBA.Any result_;
    private org.omg.CORBA.Any except_;
    
    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public String
    op_name()
    {
	return name_;
    }

    public org.omg.CORBA.Context
    ctx()
    {
	int len = in_.read_ulong();
	String[] strings = new String[len];
	for(int i = 0 ; i < len ; i++)
	    strings[i] = in_.read_string();
	
	ctx_ = new Context("", strings);

	return ctx_;
    }

    public void
    params(org.omg.CORBA.NVList parms)
    {
	params_ = parms;

	if(params_ != null)
	{

	    try
   	    {
		for(int i = 0 ; i < params_.count() ; i++)
		{
		    org.omg.CORBA.NamedValue nv = params_.item(i);
		    
		    if(nv.flags() != org.omg.CORBA.ARG_OUT.value)
			nv.value().read_value(in_, nv.value().type());
		}
	    }
	    catch(org.omg.CORBA.Bounds ex)
	    {
		throw new InternalError();
	    }
	}
    }

    public void
    result(org.omg.CORBA.Any a)
    {
	result_ = a;
    }

    public void
    except(org.omg.CORBA.Any a)
    {
	except_ = a;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    ServerRequest(String name, org.omg.CORBA.portable.InputStream in)
    {
	name_ = name;
	in_ = in;
    }

    public org.omg.CORBA.NVList
    _OB_params()
    {
	return params_;
    }
   
    public org.omg.CORBA.Any
    _OB_result()
    {
	return result_;
    }
   
    public org.omg.CORBA.Any
    _OB_except()
    {
	return except_;
    }
   
}
