// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

// Note: TypeCodes are immutable, so I don't need thread
// synchronization

final class TypeCode extends org.omg.CORBA.TypeCode
{
    //
    // TypeCode kind
    //
    org.omg.CORBA.TCKind kind_;

    //
    // tk_objref, tk_struct, tk_union, tk_enum,
    // tk_alias, tk_except
    //
    String id_;
    String name_;
 
    //
    // tk_struct, tk_union, tk_enum, tk_except
    //
    String[] memberNames_;
 
    //
    // tk_struct, tk_union, tk_except
    //
    TypeCode[] memberTypes_;

    //
    // tk_union
    //
    org.omg.CORBA.Any[] labels_;

    //
    // tk_union
    //
    TypeCode discriminatorType_;

    //
    // tk_string, tk_sequence, tk_array
    //
    int length_;

    //
    // tk_sequence, tk_array, tk_alias
    //
    TypeCode contentType_;

    //
    // tk_sequence (for recursive sequence type codes)
    //
    int offset_;

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public boolean
    equal(org.omg.CORBA.TypeCode t)
    {
	TypeCode tc = (TypeCode)t;

	if(tc == this)
	    return true;

	TypeCode tc1 = _OB_getOrigType();
	TypeCode tc2 = tc._OB_getOrigType();

	if(tc1.kind_ != tc2.kind_)
	    return false;

	//
	// Repository ids are only required for tk_objref and tk_except
	//
	if(tc1.kind_ == org.omg.CORBA.TCKind.tk_objref ||
	   tc1.kind_ == org.omg.CORBA.TCKind.tk_except)
	{
	    if(!tc1.id_.equals(tc2.id_))
		return false;
	}
	else if(tc1.kind_ == org.omg.CORBA.TCKind.tk_struct ||
		tc1.kind_ == org.omg.CORBA.TCKind.tk_union ||
		tc1.kind_ == org.omg.CORBA.TCKind.tk_enum ||
		tc1.kind_ == org.omg.CORBA.TCKind.tk_alias)
	{
	    if(tc1.id_.length() > 0 && tc2.id_.length() > 0 &&
	       !tc1.id_.equals(tc2.id_))
		return false;
	}

	if(tc1.kind_ == org.omg.CORBA.TCKind.tk_struct ||
	   tc1.kind_ == org.omg.CORBA.TCKind.tk_union ||
	   tc1.kind_ == org.omg.CORBA.TCKind.tk_except)
	{
	    if(tc1.memberTypes_.length != tc2.memberTypes_.length)
		return false;

	    for(int i = 0; i < tc1.memberTypes_.length; i++)
	    {
		if(!(tc1.memberTypes_[i].equal(tc2.memberTypes_[i])))
		    return false;
	    }
	}

	if(tc1.kind_ == org.omg.CORBA.TCKind.tk_union)
	{
	    if(tc1.labels_.length != tc2.labels_.length)
		return false;
	    
	    for(int i = 0; i < tc1.memberTypes_.length; i++)
		if(!tc1.labels_[i].equal(tc2.labels_[i]))
		    return false;
	}
	
	if(tc1.kind_ == org.omg.CORBA.TCKind.tk_union)
	{
	    if(!tc1.discriminatorType_.equal(tc2.discriminatorType_))
		return false;
	}

	if(tc1.kind_ == org.omg.CORBA.TCKind.tk_string ||
	   tc1.kind_ == org.omg.CORBA.TCKind.tk_sequence ||
	   tc1.kind_ == org.omg.CORBA.TCKind.tk_array)
	{
	    if(tc1.length_ != tc2.length_)
		return false;
	}

	if(tc1.kind_ == org.omg.CORBA.TCKind.tk_array ||
	   tc1.kind_ == org.omg.CORBA.TCKind.tk_alias)
	{
	    if(!tc1.contentType_.equal(tc2.contentType_))
		return false;
	}

	if(tc1.kind_ == org.omg.CORBA.TCKind.tk_sequence)
	{
	    if(tc1.offset_ == 0 && tc2.offset_ == 0)
	    {
		if(!tc1.contentType_.equal(tc2.contentType_))
		    return false;
	    }
	    else
	    {
		if(tc1.offset_ != tc2.offset_)
		    return false;
		
		if((tc1.contentType_ == null) != (tc2.contentType_ == null))
		    return false;
		
		if(tc1.contentType_ != null)
		{
		    if(tc1.contentType_.kind_ !=  tc2.contentType_.kind_)
			return false;
		    
		    if(tc1.contentType_.kind_ !=
		       org.omg.CORBA.TCKind.tk_struct &&
		       tc1.contentType_.kind_ !=
		       org.omg.CORBA.TCKind.tk_union &&
		       tc1.contentType_.kind_ !=
		       org.omg.CORBA.TCKind.tk_except)
			throw new InternalError();
		    
		    if(!tc1.contentType_.id_.equals(tc2.contentType_.id_) ||
		       !tc1.contentType_.name_.equals(tc2.contentType_.name_))
			return false;
		}
	    }
	}

	return true;
    }

    public org.omg.CORBA.TCKind
    kind()
    {
	return kind_;
    }

    public String
    id()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_objref ||
	     kind_ == org.omg.CORBA.TCKind.tk_struct ||
	     kind_ == org.omg.CORBA.TCKind.tk_union ||
	     kind_ == org.omg.CORBA.TCKind.tk_enum ||
	     kind_ == org.omg.CORBA.TCKind.tk_alias ||
	     kind_ == org.omg.CORBA.TCKind.tk_except))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	return id_;
    }

    public String
    name()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_objref ||
	     kind_ == org.omg.CORBA.TCKind.tk_struct ||
	     kind_ == org.omg.CORBA.TCKind.tk_union ||
	     kind_ == org.omg.CORBA.TCKind.tk_enum ||
	     kind_ == org.omg.CORBA.TCKind.tk_alias ||
	     kind_ == org.omg.CORBA.TCKind.tk_except))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	return name_;
    }

    public int
    member_count()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_struct ||
	     kind_ == org.omg.CORBA.TCKind.tk_union ||
	     kind_ == org.omg.CORBA.TCKind.tk_enum ||
	     kind_ == org.omg.CORBA.TCKind.tk_except))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();
    
	return memberNames_.length;
    }

    public String
    member_name(int index)
	throws org.omg.CORBA.TypeCodePackage.BadKind,
	       org.omg.CORBA.TypeCodePackage.Bounds
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_struct ||
	     kind_ == org.omg.CORBA.TCKind.tk_union ||
	     kind_ == org.omg.CORBA.TCKind.tk_enum ||
	     kind_ == org.omg.CORBA.TCKind.tk_except))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	try
	{
	    return memberNames_[index];
	}
	catch(ArrayIndexOutOfBoundsException ex)
	{
	    throw new org.omg.CORBA.TypeCodePackage.Bounds();
	}
    }

    public org.omg.CORBA.TypeCode
    member_type(int index)
	throws org.omg.CORBA.TypeCodePackage.BadKind,
               org.omg.CORBA.TypeCodePackage.Bounds
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_struct ||
	     kind_ == org.omg.CORBA.TCKind.tk_union ||
	     kind_ == org.omg.CORBA.TCKind.tk_except))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	try
	{
	    return (org.omg.CORBA.TypeCode)memberTypes_[index];
	}
	catch(ArrayIndexOutOfBoundsException ex)
	{
	    throw new org.omg.CORBA.TypeCodePackage.Bounds();
	}
    }

    public org.omg.CORBA.Any
    member_label(int index)
	throws org.omg.CORBA.TypeCodePackage.BadKind,
               org.omg.CORBA.TypeCodePackage.Bounds
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_union))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	try
	{
	    return labels_[index];
	}
	catch(ArrayIndexOutOfBoundsException ex)
	{
	    throw new org.omg.CORBA.TypeCodePackage.Bounds();
	}
    }

    public org.omg.CORBA.TypeCode
    discriminator_type()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_union))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	return discriminatorType_;
    }

    public int
    default_index()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_union))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	for(int i = 0 ; i < labels_.length ; i++)
	{
	    org.omg.CORBA.TypeCode tc = labels_[i].type();
	    if(tc.kind() == org.omg.CORBA.TCKind.tk_octet)
		return i;
	}

	return -1;
    }

    public int
    length()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_string ||
	     kind_ == org.omg.CORBA.TCKind.tk_sequence ||
	     kind_ == org.omg.CORBA.TCKind.tk_array))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	return length_;
    }

    public org.omg.CORBA.TypeCode
    content_type()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(!(kind_ == org.omg.CORBA.TCKind.tk_sequence ||
	     kind_ == org.omg.CORBA.TCKind.tk_array ||
	     kind_ == org.omg.CORBA.TCKind.tk_alias))
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();

	return contentType_;
    }

    // ------------------------------------------------------------------
    // Additonal ORBacus specific functions
    // ------------------------------------------------------------------

    public boolean
    exactly_equal(org.omg.CORBA.TypeCode t)
    {
	TypeCode tc = (TypeCode)t;

	if(tc == this)
	    return true;

	if(kind_ != tc.kind_)
	    return false;

	if(kind_ == org.omg.CORBA.TCKind.tk_objref ||
	   kind_ == org.omg.CORBA.TCKind.tk_struct ||
	   kind_ == org.omg.CORBA.TCKind.tk_union ||
	   kind_ == org.omg.CORBA.TCKind.tk_enum ||
	   kind_ == org.omg.CORBA.TCKind.tk_alias ||
	   kind_ == org.omg.CORBA.TCKind.tk_except)
	{
	    if(!id_.equals(tc.id_) || !name_.equals(tc.name_))
		return false;
	}

	if(kind_ == org.omg.CORBA.TCKind.tk_struct ||
	   kind_ == org.omg.CORBA.TCKind.tk_union ||
	   kind_ == org.omg.CORBA.TCKind.tk_enum ||
	   kind_ == org.omg.CORBA.TCKind.tk_except)
	{
	    if(memberNames_.length != tc.memberNames_.length)
		return false;
	    
	    for(int i = 0; i < memberNames_.length; i++)
		if(!memberNames_[i].equals(tc.memberNames_[i]))
		    return false;
	}
	
	if(kind_ == org.omg.CORBA.TCKind.tk_struct ||
	   kind_ == org.omg.CORBA.TCKind.tk_union ||
	   kind_ == org.omg.CORBA.TCKind.tk_except)
	{
	    if(memberTypes_.length != tc.memberTypes_.length)
		return false;
	    
	    for(int i = 0; i < memberTypes_.length; i++)
		if(!memberTypes_[i].exactly_equal(tc.memberTypes_[i]))
		    return false;
	}
	
	if(kind_ == org.omg.CORBA.TCKind.tk_union)
	{
	    if(labels_.length != tc.labels_.length)
		return false;

	    for(int i = 0; i < memberTypes_.length; i++)
	    {
		if(!((TypeCode)labels_[i].type()).
		   exactly_equal(tc.labels_[i].type()))
		    return false;
		
		if(!labels_[i].equal(tc.labels_[i]))
		    return false;
	    }
	}

	if(kind_ == org.omg.CORBA.TCKind.tk_union)
	{
	    if(!discriminatorType_.exactly_equal(tc.discriminatorType_))
		return false;
	}
   
	if(kind_ == org.omg.CORBA.TCKind.tk_string ||
	   kind_ == org.omg.CORBA.TCKind.tk_sequence ||
	   kind_ == org.omg.CORBA.TCKind.tk_array)
	{
	    if(length_ != tc.length_)
		return false;
	}

	if(kind_ == org.omg.CORBA.TCKind.tk_array ||
	   kind_ == org.omg.CORBA.TCKind.tk_alias)
	{
	    if(!contentType_.exactly_equal(tc.contentType_))
		return false;
	}
	
	if(kind_ == org.omg.CORBA.TCKind.tk_sequence)
	{
	    if(offset_ == 0 && tc.offset_ == 0)
	    {
		if(!contentType_.exactly_equal(tc.contentType_))
		    return false;
	    }
	    else
	    {
		if(offset_ != tc.offset_)
		    return false;
		
		if((contentType_ == null) != (tc.contentType_ == null))
		    return false;
		
		if(contentType_ != null)
		{
		    if(contentType_.kind_ !=  tc.contentType_.kind_)
			return false;
		    
		    if(contentType_.kind_ != org.omg.CORBA.TCKind.tk_struct &&
		       contentType_.kind_ != org.omg.CORBA.TCKind.tk_union &&
		       contentType_.kind_ != org.omg.CORBA.TCKind.tk_except)
			throw new InternalError();
		    
		    if(!contentType_.id_.equals(tc.contentType_.id_) ||
		       !contentType_.name_.equals(tc.contentType_.name_))
			return false;
		}
	    }
	}
	
	return true;
    }

    int
    offset()
	throws org.omg.CORBA.TypeCodePackage.BadKind
    {
	if(kind_ != org.omg.CORBA.TCKind.tk_sequence)
	    throw new org.omg.CORBA.TypeCodePackage.BadKind();
	
	return offset_;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    TypeCode()
    {
    }

    TypeCode
    _OB_getOrigType()
    {
	return (TypeCode)_OB_getOrigType(this);
    }

    static org.omg.CORBA.TypeCode
    _OB_getOrigType(org.omg.CORBA.TypeCode tc)
    {
	try
	{
	    while(tc.kind() == org.omg.CORBA.TCKind.tk_alias)
		tc = tc.content_type();
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    throw new InternalError();
	}

	return tc;
    }

    boolean
    _OB_isSystemException()
    {
	if(kind_ != org.omg.CORBA.TCKind.tk_except)
	    return false;
	
	if(id_.equals("IDL:omg.org/CORBA/UNKNOWN:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/BAD_PARAM:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/NO_MEMORY:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/IMP_LIMIT:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/COMM_FAILURE:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/INV_OBJREF:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/NO_PERMISSION:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/INTERNAL:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/MARSHAL:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/INITIALIZE:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/BAD_TYPECODE:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/BAD_OPERATION:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/NO_RESOURCES:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/NO_RESPONSE:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/PERSIST_STORE:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/TRANSIENT:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/FREE_MEM:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/INV_IDENT:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/INV_FLAG:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/INTF_REPOS:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/BAD_CONTEXT:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/DATA_CONVERSION:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0") ||
	   id_.equals("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0") ||
           id_.equals("IDL:omg.org/CORBA/INV_POLICY:1.0"))
	{
	    return true;
	}
	else
	{
	    return false;
	}
    }
}
