// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class Util
{
    //
    // For ASCII to Hex conversion
    //
    final static private String asciiToHex = "0123456789abcdef";

    //
    // Generate ascii from octet sequence
    //
    static String
    octetsToAscii(byte[] oct, int count)
    {
	String str = new String();

	if(count > oct.length)
	    throw new InternalError();
	
	for(int i = 0 ; i < count ; i++)
	{
	    str += asciiToHex.charAt((oct[i] >> 4) & 0x0f);
	    str += asciiToHex.charAt(oct[i] & 0x0f);
	}
	
	return str;
    }

    //
    // Generate octet sequence from ascii
    //
    static byte[]
    asciiToOctets(String str)
    {
	//
	// Two ASCII characters for each octet
	//
	if(str.length() % 2 != 0)
	    return null;

	int len = str.length() / 2;
	byte[] oct = new byte[len];

	str = str.toLowerCase();

	for(int i = 0, j = 0 ; i < len ; i++)
	{
	    int high = asciiToHex.indexOf(str.charAt(j++));
	    int low = asciiToHex.indexOf(str.charAt(j++));

	    //
	    // Check ASCII range (0-9, A-F)
	    //
	    if(high == -1 || low == -1)
		return null;

	    oct[i] = (byte)(16 * high + low);
	}

	return oct;
    }

    //
    // Unmarshal a system exception
    //
    static org.omg.CORBA.SystemException
    unmarshalSystemException(org.omg.CORBA.portable.InputStream in)
    {
	String id = in.read_string();
	int minor = in.read_ulong();
	org.omg.CORBA.CompletionStatus status =
	    org.omg.CORBA.CompletionStatus.from_int(in.read_ulong());

	if(id.equals("IDL:omg.org/CORBA/BAD_PARAM:1.0"))
	{
	    return new org.omg.CORBA.BAD_PARAM(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/NO_MEMORY:1.0"))
	{
	    return new org.omg.CORBA.NO_MEMORY(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/IMP_LIMIT:1.0"))
	{
	    return new org.omg.CORBA.IMP_LIMIT(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/COMM_FAILURE:1.0"))
	{
	    return new org.omg.CORBA.COMM_FAILURE(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/INV_OBJREF:1.0"))
	{
	    return new org.omg.CORBA.INV_OBJREF(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/NO_PERMISSION:1.0"))
	{
	    return new org.omg.CORBA.NO_PERMISSION(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/INTERNAL:1.0"))
	{
	    return new org.omg.CORBA.INTERNAL(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/MARSHAL:1.0"))
	{
	    return new org.omg.CORBA.MARSHAL(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/INITIALIZE:1.0"))
	{
	    return new org.omg.CORBA.INITIALIZE(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0"))
	{
	    return new org.omg.CORBA.NO_IMPLEMENT(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/BAD_TYPECODE:1.0"))
	{
	    return new org.omg.CORBA.BAD_TYPECODE(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/BAD_OPERATION:1.0"))
	{
	    return new org.omg.CORBA.BAD_OPERATION(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/NO_RESOURCES:1.0"))
	{
	    return new org.omg.CORBA.NO_RESOURCES(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/NO_RESPONSE:1.0"))
	{
	    return new org.omg.CORBA.NO_RESPONSE(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/PERSIST_STORE:1.0"))
	{
	    return new org.omg.CORBA.PERSIST_STORE(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0"))
	{
	    return new org.omg.CORBA.BAD_INV_ORDER(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/TRANSIENT:1.0"))
	{
	    return new org.omg.CORBA.TRANSIENT(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/FREE_MEM:1.0"))
	{
	    return new org.omg.CORBA.FREE_MEM(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/INV_IDENT:1.0"))
	{
	    return new org.omg.CORBA.INV_IDENT(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/INV_FLAG:1.0"))
	{
	    return new org.omg.CORBA.INV_FLAG(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/INTF_REPOS:1.0"))
	{
	    return new org.omg.CORBA.INTF_REPOS(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/BAD_CONTEXT:1.0"))
	{
	    return new org.omg.CORBA.BAD_CONTEXT(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0"))
	{
	    return new org.omg.CORBA.OBJ_ADAPTER(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/DATA_CONVERSION:1.0"))
	{
	    return new org.omg.CORBA.DATA_CONVERSION(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0"))
	{
	    return new org.omg.CORBA.OBJECT_NOT_EXIST(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0"))
	{
	    return new org.omg.CORBA.TRANSACTION_REQUIRED(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0"))
	{
	    return new org.omg.CORBA.TRANSACTION_ROLLEDBACK(minor, status);
	}
	else if(id.equals("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0"))
	{
	    return new org.omg.CORBA.INVALID_TRANSACTION(minor, status);
	}
        else if(id.equals("IDL:omg.org/CORBA/INV_POLICY:1.0"))
	{
	    return new org.omg.CORBA.INV_POLICY(minor, status);
	}

	//
	// Unknown exception
	//
	return new org.omg.CORBA.UNKNOWN(minor, status);
    }

    //
    // Unmarshal and throw a system exception
    //
    static void
    unmarshalSystemExceptionThrow(org.omg.CORBA.portable.InputStream in)
    {
	org.omg.CORBA.SystemException ex = unmarshalSystemException(in);
	throw ex;
    }

    //
    // Marshal a system exception
    //
    static void
    marshalSystemException(org.omg.CORBA.portable.OutputStream out,
			   org.omg.CORBA.SystemException ex)
    {
	String className = ex.getClass().getName();

	if(className.equals("org.omg.CORBA.BAD_PARAM"))
	{
	    out.write_string("IDL:omg.org/CORBA/BAD_PARAM:1.0");
	}
	else if(className.equals("org.omg.CORBA.NO_MEMORY"))
	{
	    out.write_string("IDL:omg.org/CORBA/NO_MEMORY:1.0");
	}
	else if(className.equals("org.omg.CORBA.IMP_LIMIT"))
	{
	    out.write_string("IDL:omg.org/CORBA/IMP_LIMIT:1.0");
	}
	else if(className.equals("org.omg.CORBA.COMM_FAILURE"))
	{
	    out.write_string("IDL:omg.org/CORBA/COMM_FAILURE:1.0");
	}
	else if(className.equals("org.omg.CORBA.INV_OBJREF"))
	{
	    out.write_string("IDL:omg.org/CORBA/INV_OBJREF:1.0");
	}
	else if(className.equals("org.omg.CORBA.NO_PERMISSION"))
	{
	    out.write_string("IDL:omg.org/CORBA/NO_PERMISSION:1.0");
	}
	else if(className.equals("org.omg.CORBA.INTERNAL"))
	{
	    out.write_string("IDL:omg.org/CORBA/INTERNAL:1.0");
	}
	else if(className.equals("org.omg.CORBA.MARSHAL"))
	{
	    out.write_string("IDL:omg.org/CORBA/MARSHAL:1.0");
	}
	else if(className.equals("org.omg.CORBA.INITIALIZE"))
	{
	    out.write_string("IDL:omg.org/CORBA/INITIALIZE:1.0");
	}
	else if(className.equals("org.omg.CORBA.NO_IMPLEMENT"))
	{
	    out.write_string("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0");
	}
	else if(className.equals("org.omg.CORBA.BAD_TYPECODE"))
	{
	    out.write_string("IDL:omg.org/CORBA/BAD_TYPECODE:1.0");
	}
	else if(className.equals("org.omg.CORBA.BAD_OPERATION"))
	{
	    out.write_string("IDL:omg.org/CORBA/BAD_OPERATION:1.0");
	}
	else if(className.equals("org.omg.CORBA.NO_RESOURCES"))
	{
	    out.write_string("IDL:omg.org/CORBA/NO_RESOURCES:1.0");
	}
	else if(className.equals("org.omg.CORBA.NO_RESPONSE"))
	{
	    out.write_string("IDL:omg.org/CORBA/NO_RESPONSE:1.0");
	}
	else if(className.equals("org.omg.CORBA.PERSIST_STORE"))
	{
	    out.write_string("IDL:omg.org/CORBA/PERSIST_STORE:1.0");
	}
	else if(className.equals("org.omg.CORBA.BAD_INV_ORDER"))
	{
	    out.write_string("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0");
	}
	else if(className.equals("org.omg.CORBA.TRANSIENT"))
	{
	    out.write_string("IDL:omg.org/CORBA/TRANSIENT:1.0");
	}
	else if(className.equals("org.omg.CORBA.FREE_MEM"))
	{
	    out.write_string("IDL:omg.org/CORBA/FREE_MEM:1.0");
	}
	else if(className.equals("org.omg.CORBA.INV_IDENT"))
	{
	    out.write_string("IDL:omg.org/CORBA/INV_IDENT:1.0");
	}
	else if(className.equals("org.omg.CORBA.INV_FLAG"))
	{
	    out.write_string("IDL:omg.org/CORBA/INV_FLAG:1.0");
	}
	else if(className.equals("org.omg.CORBA.INTF_REPOS"))
	{
	    out.write_string("IDL:omg.org/CORBA/INTF_REPOS:1.0");
	}
	else if(className.equals("org.omg.CORBA.BAD_CONTEXT"))
	{
	    out.write_string("IDL:omg.org/CORBA/BAD_CONTEXT:1.0");
	}
	else if(className.equals("org.omg.CORBA.OBJ_ADAPTER"))
	{
	    out.write_string("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0");
	}
	else if(className.equals("org.omg.CORBA.DATA_CONVERSION"))
	{
	    out.write_string("IDL:omg.org/CORBA/DATA_CONVERSION:1.0");
	}
	else if(className.equals("org.omg.CORBA.OBJECT_NOT_EXIST"))
	{
	    out.write_string("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0");
	}
	else if(className.equals("org.omg.CORBA.TRANSACTION_REQUIRED"))
	{
	    out.write_string("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0");
	}
	else if(className.equals("org.omg.CORBA.TRANSACTION_ROLLEDBACK"))
	{
	    out.write_string("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0");
	}
	else if(className.equals("org.omg.CORBA.INVALID_TRANSACTION"))
	{
	    out.write_string("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0");
	}
        else if(className.equals("org.omg.CORBA.INV_POLICY"))
	{
	    out.write_string("IDL:omg.org/CORBA/INV_POLICY:1.0");
	}
	else
	    out.write_string("IDL:omg.org/CORBA/UNKNOWN:1.0");

	out.write_ulong(ex.minor);
	out.write_ulong(ex.completed.value());
    }
}
