// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI;

public final class Buffer
{
    private byte[] data_; // The octet buffer
    private int len_; // The number of valid bytes in the octet buffer
    private int pos_; // The position counter

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public byte[]
    data()
    {
	return data_;
    }

    public int
    length()
    {
	return len_;
    }

    public int
    rest_length()
    {
	return len_ - pos_;
    }

    public int
    pos()
    {
	return pos_;
    }

    public void
    pos(int pos)
    {
	pos_ = pos;
    }

    public void
    advance(int delta)
    {
	pos_ += delta;
    }

    public boolean
    is_full()
    {
	return pos_ >= len_;
    }

    // ------------------------------------------------------------------
    // Additional ORBacus specific functions
    // ------------------------------------------------------------------

    public void
    alloc(int n)
    {
	data_ = new byte[n];
	len_ = n;
    }

    public void
    realloc(int n)
    {
	byte[] newData = new byte[n];
	System.arraycopy(data_, 0, newData, 0, len_);
	data_ = newData;
	len_ = n;
    }

    public void
    data(byte[] data, int n)
    {
	data_ = data;
	len_ = n;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    Buffer()
    {
    }

    public
    Buffer(int n)
    {
	data_ = new byte[n];
	len_ = n;
    }
}
