// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class Acceptor extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.Acceptor
{
    // Some data member must not be private because the info object
    // must be able to access them
    /* private */ String host_; // The host
    private int port_; // The port
    /* private */ java.net.ServerSocket socket_; // The socket
    private AcceptorInfo info_; // Acceptor information

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int
    tag()
    {
	return org.omg.IOP.TAG_INTERNET_IOP.value;
    }

    public int
    handle()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public void
    close()
    {
	//
	// Destroy the info object
	//
	info_._OB_destroy();

	//
	// Close the socket
	//
        try
        {
            socket_.close();
	    socket_ = null;
        }
        catch(java.io.IOException ex)
        {
        }
    }

    public void
    unblock_threads()
    {
        //
        // Create socket for interrupt
	// Connect to the acceptor socket
	// Close the interrupt socket
        //
        try
        {
	    //
	    // Don't use getLocalHost()! getLocalHost() sometimes
	    // returns an address that's not usable for stand-alone
	    // computers.
	    //
	    //java.net.InetAddress address =
  	    //	java.net.InetAddress.getLocalHost();

            java.net.InetAddress address =
		java.net.InetAddress.getByName("127.0.0.1");

            java.net.Socket socket = new java.net.Socket(address, port_);
	    socket.close();
        }
        catch(java.net.UnknownHostException ex)
        {
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorGethostbyname,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
	}
        catch(java.io.IOException ex)
        {
	    //
	    // Ignore connect failures - it's possible that accept has not
	    // been called
	    //
/*
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorSocket,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
*/
        }
    }

    public void
    listen()
    {
        //
        // This operation does nothing in the Java implementation
        //
    }
    
    public com.ooc.OCI.Transport
    accept()
    {
	//
	// Accept
	//
	java.net.Socket socket;
        try
        {
	    socket = socket_.accept();
        }
        catch(java.io.IOException ex)
        {
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorAccept,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
	}

        if(com.ooc.CORBA.MessageViewer.getTraceLevel() >= 1)
        {
            String msg = "New connection from ";
            msg += socket.getInetAddress().getHostAddress();
            msg += ":";
            msg += socket.getPort();
            com.ooc.CORBA.MessageViewer.instance().trace(1, msg);
        }

	//
	// Set TCP_NODELAY option
	//
	try
        {
            socket.setTcpNoDelay(true);
        }
        catch(java.net.SocketException ex)
        {
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorSetsockopt,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
        }
        
	//
	// Create new transport
	//
	com.ooc.OCI.Transport tr = new Transport(this, socket);

	//
	// Call callbacks
	//
        com.ooc.OCI.TransportInfo trInfo = tr.get_info();
	try
	{
	    info_._OB_callAcceptCB(trInfo);
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    tr.close(true);
	    throw ex;
	}

	//
	// Return new transport
	//
	return tr;
    }

    public void
    add_profile(byte[] key, org.omg.IOP.IORHolder ior)
    {
	org.omg.IIOP.ProfileBody body = new org.omg.IIOP.ProfileBody();
	body.iiop_version = new org.omg.IIOP.Version();
	body.iiop_version.major = 1;
	body.iiop_version.minor = 0;
	body.host = host_;
	if(port_ >= 0x8000)
	    body.port = (short)(port_ - 0xffff - 1);
	else
	    body.port = (short)port_;
	body.object_key = key;	

	int len = ior.value.profiles.length + 1;    
	org.omg.IOP.TaggedProfile[] profiles =
	    new org.omg.IOP.TaggedProfile[len];
	System.arraycopy(ior.value.profiles, 0, profiles, 0,
			 ior.value.profiles.length);
	ior.value.profiles = profiles;
	ior.value.profiles[len - 1] = new org.omg.IOP.TaggedProfile();
	ior.value.profiles[len - 1].tag = tag();
	com.ooc.CORBA.OutputStream out = new com.ooc.CORBA.OutputStream();
	out._OB_writeEndian();
	org.omg.IIOP.ProfileBodyHelper.write(out, body);
	byte[] pData = new byte[out._OB_count()];
        System.arraycopy(out._OB_buffer(), 0, pData, 0, pData.length);
	ior.value.profiles[len - 1].profile_data = pData;
    }

    public byte[]
    is_local(org.omg.IOP.IOR ior)
    {
	return Util.extractKey(ior, host_, port_, true);
    }
    
    public com.ooc.OCI.AcceptorInfo
    get_info()
    {
        return info_;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    Acceptor(String host, int port)
    {
	//System.out.println("Acceptor");
	host_ = host;
        info_ = new AcceptorInfo(this);

        //
        // Create socket
        //
        try
        {
            socket_ = new java.net.ServerSocket(port);
	    port_ = socket_.getLocalPort();
        }
        catch(java.io.IOException ex)
        {
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorSocket,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
        }

        if(com.ooc.CORBA.MessageViewer.getTraceLevel() >= 1)
        {
            String msg = "Accepting connections on port ";
            msg += port_;
            com.ooc.CORBA.MessageViewer.instance().trace(1, msg);
        }
    }

    public void
    finalize()
	throws Throwable
    {
	//System.out.println("~Acceptor");
	if(socket_ != null)
	    close();

	super.finalize();
    }
}

