// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class AcceptorInfo extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.IIOP.AcceptorInfo
{
    private Acceptor acceptor_; // The associated acceptor

    //
    // All accept callback objects
    //
    private java.util.Vector acceptCBVec_ = new java.util.Vector();

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int tag()
    {
        return org.omg.IOP.TAG_INTERNET_IOP.value;
    }

    public synchronized void
    add_accept_cb(com.ooc.OCI.AcceptCB cb)
    {
        int length = acceptCBVec_.size();
        for(int i = 0; i < length; ++i)
            if(acceptCBVec_.elementAt(i) == cb)
                return; // Already registered
        acceptCBVec_.addElement(cb);
    }

    public synchronized void
    remove_accept_cb(com.ooc.OCI.AcceptCB cb)
    {
        int length = acceptCBVec_.size();
        for(int i = 0; i < length; ++i)
            if(acceptCBVec_.elementAt(i) == cb)
            {
                acceptCBVec_.removeElementAt(i);
                return;
            }
    }

    public synchronized String host()
    {
	if(acceptor_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        return acceptor_.host_;
    }

    public synchronized byte[] addr()
    {
	if(acceptor_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        return acceptor_.socket_.getInetAddress().getAddress();
    }

    public synchronized short port()
    {
	if(acceptor_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

	int port = acceptor_.socket_.getLocalPort();

	if(port >= 0x8000)
	    return (short)(port - 0xffff - 1);
	else
	    return (short)port;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    AcceptorInfo(Acceptor acceptor)
    {
        acceptor_ = acceptor;
    }

    synchronized void
    _OB_callAcceptCB(com.ooc.OCI.TransportInfo info)
    {
        int length = acceptCBVec_.size();
        for(int i = 0; i < length; ++i)
        {
            com.ooc.OCI.AcceptCB cb =
                (com.ooc.OCI.AcceptCB)acceptCBVec_.elementAt(i);
            cb.accept_cb(info);
        }
    }

    synchronized void
    _OB_destroy()
    {
	acceptor_ = null;
    }
}
