// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class ConFactory extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.ConFactory
{
    //
    // ConFactory information
    //
    private com.ooc.OCI.IIOP.impl.ConFactoryInfo info_;

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int
    tag()
    {
	return org.omg.IOP.TAG_INTERNET_IOP.value;
    }

    public com.ooc.OCI.Connector
    create(org.omg.IOP.IOR ior)
    {
	for(int i = 0; i < ior.profiles.length; i++)
	{
	    if(ior.profiles[i].tag == tag())
	    {
		//
		// Get the IIOP profile body
		//
		byte[] buf = ior.profiles[i].profile_data;
		com.ooc.CORBA.InputStream in =
		    new com.ooc.CORBA.InputStream(buf);
		in._OB_readEndian();
		org.omg.IIOP.ProfileBody body =
		    org.omg.IIOP.ProfileBodyHelper.read(in);

		//
		// Create new connector
		//
		int port;
		if(body.port < 0)
		    port = 0xffff + (int)body.port + 1;
		else
		    port = (int)body.port;
                com.ooc.OCI.ConnectCB[] cbs = info_._OB_getConnectCBSeq();
		return new Connector(body.host, port, cbs);
	    }
	}

	return null;
    }

    public com.ooc.OCI.Connector
    create_with_policies(org.omg.IOP.IOR ior,
                         org.omg.CORBA.Policy[] policies)
    {
        if(!consider_with_policies(ior, policies))
            return null;

        return create(ior);
    }
    
    public boolean
    consider_with_policies(org.omg.IOP.IOR ior,
			   org.omg.CORBA.Policy[] policies)
    {
        for(int i = 0 ; i < ior.profiles.length ; i++)
        {
            if(ior.profiles[i].tag == tag())
            {
		//
		// Make sure that the policies are met
		//
                for(int j = 0; j < policies.length; j++)
                {
                    if(policies[j].policy_type() ==
                       com.ooc.SSL.CONNECT_POLICY.value)
                    {
                        com.ooc.SSL.ConnectPolicy connectPolicy =
			    com.ooc.SSL.ConnectPolicyHelper.narrow(
				policies[j]);
                        if(connectPolicy.value() ==
                           com.ooc.SSL.ConnectPolicyType.ConnectSecure)
                            return false;
                    }
                    else if(policies[j].policy_type() ==
                            com.ooc.OB.PROTOCOL_POLICY.value)
                    {
                        com.ooc.OB.ProtocolPolicy protocolPolicy =
                            com.ooc.OB.ProtocolPolicyHelper.
                                narrow(policies[j]);
                        if(protocolPolicy.value() != tag())
                            return false;
                    }
                }

		return true;
            }
        }

        return false;
    }

    public boolean
    equivalent(org.omg.IOP.IOR ior1, org.omg.IOP.IOR ior2)
    {
	return Util.equivalent(ior1, ior2);
    }

    public int
    hash(org.omg.IOP.IOR ior, int max)
    {
        return Util.hash(ior, max);
    }
    
    public com.ooc.OCI.ConFactoryInfo
    get_info()
    {
        return info_;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    ConFactory()
    {
	//System.out.println("ConFactory");
        info_ = new ConFactoryInfo();
    }

    public void
    finalize()
	throws Throwable
    {
	//System.out.println("~ConFactory");
	super.finalize();
    }
}
