// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class Connector extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.Connector
{
    // Some data member must not be private because the info object
    // must be able to access them
    private String host_; // The host
    /*private*/ int port_; // The port
    /*private*/ java.net.InetAddress address_; // The address
    private ConnectorInfo info_; // Connector information
    private java.net.Socket socket_; // The socket

    // ------------------------------------------------------------------
    // Private and protected functions
    // ------------------------------------------------------------------

    private void
    close()
    {
	//
	// Destroy the info object
	//
	info_._OB_destroy();

	//
	// Close the socket
	//
        try
        {
            socket_.close();
	    socket_ = null;
        }
        catch(java.io.IOException ex)
        {
        }
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int
    tag()
    {
	return org.omg.IOP.TAG_INTERNET_IOP.value;
    }

    public com.ooc.OCI.Transport
    connect()
    {
	if(socket_ != null)
	    close();

        //
        // Create socket and connect
        //
        try
        {
	    if(com.ooc.CORBA.MessageViewer.getTraceLevel() >= 1)
	    {
		String msg = "New connection to ";
		msg += address_.getHostAddress();
		msg += ":";
		msg += port_;
		com.ooc.CORBA.MessageViewer.instance().trace(1, msg);
	    }

            socket_ = new java.net.Socket(address_, port_);
        }
        catch(java.io.IOException ex)
        {
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorSocket,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
        }

	//
	// Set TCP_NODELAY option
	//
	try
        {
            socket_.setTcpNoDelay(true);
        }
        catch(java.net.SocketException ex)
        {
	    try
	    {
		socket_.close();
	    }
	    catch(java.io.IOException e)
	    {
	    }
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorSetsockopt,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
        }

	//
	// Create new transport
	//
	Transport tr = new Transport(this, socket_);
	socket_ = null;

	//
	// Call callbacks
	//
        com.ooc.OCI.TransportInfo trInfo = tr.get_info();
	try
	{
	    info_._OB_callConnectCB(trInfo);
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    tr.close(true);
	    throw ex;
	}

	//
	// Return new transport
	//
	return tr;
    }

    //
    // Helper class for connect_timeout()
    //
    private class ConnectTimeout extends Thread
    {
	private java.net.Socket so_ = null;
	private java.io.IOException ex_ = null;
	private boolean finished_ = false;
	private boolean timeout_ = false;

	public void run()
	{
	    try
	    {
		so_ = new java.net.Socket(address_, port_);
	    }
	    catch(java.io.IOException ex)
	    {
		ex_ = ex;
	    }

	    synchronized(this)
	    {
		if(timeout_)
		{
		    try
		    {
			so_.close();
		    }
		    catch(java.io.IOException ex)
		    {
		    }

		    so_ = null;
		}
		else
		{
		    finished_ = true;
		    notify();
		}
	    }
	}

	synchronized public java.net.Socket waitForConnect(int t)
	    throws java.io.IOException
	{
	    while(!finished_)
	    {
		try
		{
		    wait(t);
		}
		catch(InterruptedException ex)
		{
		    continue;
		}

		if(!finished_) // Timeout
		{
		    timeout_ = true;
		    return null;
		}
	    }

	    if(so_ != null) // Connect succeeded
		return so_;

	    if(ex_ != null) // Connect failed
		throw ex_;
	    
	    throw new InternalError();
	}
    }

    public com.ooc.OCI.Transport
    connect_timeout(int t)
    {
	if(socket_ != null)
	    close();

        //
        // Create socket and connect
        //
        try
        {
	    if(com.ooc.CORBA.MessageViewer.getTraceLevel() >= 1)
	    {
		String msg = "New connection to ";
		msg += address_.getHostAddress();
		msg += ":";
		msg += port_;
		com.ooc.CORBA.MessageViewer.instance().trace(1, msg);
	    }

	    ConnectTimeout connectTimeout = new ConnectTimeout();
	    connectTimeout.start();

            socket_ = connectTimeout.waitForConnect(t);

	    if(socket_ == null)
	    {
		connectTimeout.stop();
		return null;
	    }
        }
        catch(java.io.IOException ex)
        {
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorSocket,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
        }

	//
	// Set TCP_NODELAY option
	//
	try
        {
            socket_.setTcpNoDelay(true);
        }
        catch(java.net.SocketException ex)
        {
	    try
	    {
		socket_.close();
	    }
	    catch(java.io.IOException e)
	    {
	    }
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorSetsockopt,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
        }

	//
	// Create new transport
	//
	Transport tr = new Transport(this, socket_);
	socket_ = null;

	//
	// Call callbacks
	//
        com.ooc.OCI.TransportInfo trInfo = tr.get_info();
	try
	{
	    info_._OB_callConnectCB(trInfo);
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    tr.close(true);
	    throw ex;
	}

	//
	// Return new transport
	//
	return tr;
    }

    public byte[]
    is_usable(org.omg.IOP.IOR ior)
    {
	return Util.extractKey(ior, host_, port_, false);
    }

    public byte[]
    is_usable_with_policies(org.omg.IOP.IOR ior,
			    org.omg.CORBA.Policy[] policies)
    {
        //
        // Make sure that the set of policies is met
        //
        for(int i = 0; i < policies.length; i++)
        {
            if(policies[i].policy_type() == com.ooc.SSL.CONNECT_POLICY.value)
            {
		com.ooc.SSL.ConnectPolicy connectPolicy =
		    com.ooc.SSL.ConnectPolicyHelper.narrow(policies[i]);
                if(connectPolicy.value() ==
                   com.ooc.SSL.ConnectPolicyType.ConnectSecure)
                    return new byte[0];
            }
            else if(policies[i].policy_type() ==
		    com.ooc.OB.PROTOCOL_POLICY.value)
            {
                com.ooc.OB.ProtocolPolicy protocolPolicy =
                    com.ooc.OB.ProtocolPolicyHelper.narrow(policies[i]);
                if(protocolPolicy.value() != tag())
                    return new byte[0];
            }
        }

	//
	// Make sure that the IOR is usable
	//
	return is_usable(ior);
    }

    public com.ooc.OCI.ConnectorInfo
    get_info()
    {
        return info_;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    Connector(String host, int port, com.ooc.OCI.ConnectCB[] cb)
    {
	//System.out.println("Connector");
	host_ = host;
	port_ = port;
        info_ = new ConnectorInfo(this, cb);

        try
        {
            address_ = java.net.InetAddress.getByName(host_);
        }
        catch(java.net.UnknownHostException ex)
        {
            throw new org.omg.CORBA.COMM_FAILURE(
                ex.toString(),
		com.ooc.CORBA.MinorCommFailure._MinorGethostbyname,
                org.omg.CORBA.CompletionStatus.COMPLETED_NO);
	}
    }

    public void
    finalize()
	throws Throwable
    {
	//System.out.println("~Connector");
	if(socket_ != null)
	    close();

	super.finalize();
    }
}
