// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class ConnectorInfo extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.IIOP.ConnectorInfo
{
    private Connector connector_; // The associated connector

    //
    // All connect callback objects
    //
    private java.util.Vector connectCBVec_ = new java.util.Vector();

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int tag()
    {
        return org.omg.IOP.TAG_INTERNET_IOP.value;
    }

    public synchronized void
    add_connect_cb(com.ooc.OCI.ConnectCB cb)
    {
        int length = connectCBVec_.size();
        for(int i = 0; i < length; ++i)
            if(connectCBVec_.elementAt(i) == cb)
                return; // Already registered
        connectCBVec_.addElement(cb);
    }

    public synchronized void
    remove_connect_cb(com.ooc.OCI.ConnectCB cb)
    {
        int length = connectCBVec_.size();
        for(int i = 0; i < length; ++i)
            if(connectCBVec_.elementAt(i) == cb)
            {
                connectCBVec_.removeElementAt(i);
                return;
            }
    }

    public synchronized byte[] remote_addr()
    {
	if(connector_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        return connector_.address_.getAddress();
    }

    public synchronized short remote_port()
    {
	if(connector_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        int port = connector_.port_;

	if(port >= 0x8000)
	    return (short)(port - 0xffff - 1);
	else
	    return (short)port;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    ConnectorInfo(Connector connector, com.ooc.OCI.ConnectCB[] cb)
    {
        connector_ = connector;

        for(int i = 0; i < cb.length; ++i)
            connectCBVec_.addElement(cb[i]);
    }

    synchronized void
    _OB_callConnectCB(com.ooc.OCI.TransportInfo info)
    {
        int length = connectCBVec_.size();
        for(int i = 0; i < length; ++i)
        {
            com.ooc.OCI.ConnectCB cb =
                (com.ooc.OCI.ConnectCB)connectCBVec_.elementAt(i);
            cb.connect_cb(info);
        }
    }

    synchronized void
    _OB_destroy()
    {
	connector_ = null;
    }
}
