// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class Transport extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.Transport
{
    // Some data member must not be private because the info object
    // must be able to access them
    /*private*/ java.net.Socket socket_; // The socket
    private int soTimeout_ = 0; // The value for setSoTimeout()
    private TransportInfo info_; // Transport information

    private int
    convert(byte b)
    {
        if(b < 0)
            return 0xff + (int)b + 1;
        return b;
    }
    
    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int
    tag()
    {
	return org.omg.IOP.TAG_INTERNET_IOP.value;
    }

    public int
    handle()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public int
    fragmentation()
    {
	return 0;
    }

    public void
    close(boolean discard) // The discard parameter is not used in the
                           // current version
    {
	if(socket_ == null) // unblock_threads() calls close()
	    return;

        if(com.ooc.CORBA.MessageViewer.getTraceLevel() >= 1)
        {
	    com.ooc.OCI.AcceptorInfo accInfo = info_.acceptor_info();
	    String msg;
	    if(accInfo != null)
		msg = "Closing connection from ";
	    else
		msg = "Closing connection to ";
	    byte[] addr = info_.remote_addr();
	    msg += convert(addr[0]);
	    msg += ".";
	    msg += convert(addr[1]);
	    msg += ".";
	    msg += convert(addr[2]);
	    msg += ".";
	    msg += convert(addr[3]);
	    msg += ":";
	    int port = info_.remote_port();
	    if(port < 0)
		port = 0xffff + (int)port + 1;
	    msg += port;
	    com.ooc.CORBA.MessageViewer.instance().trace(1, msg);
	}

	//
	// Call callbacks
	//
	info_._OB_callCloseCB(info_);

	//
	// Destroy the info object
	//
	info_._OB_destroy();

	//
	// Close the socket
	//
        try
        {
            socket_.close();
	    socket_ = null;
        }
        catch(java.io.IOException ex)
        {
        }
    }

    public void
    unblock_threads(boolean discard)
    {
	//
	// Closing the socket unblocks threads
	//
	close(discard);
    }

    public void
    receive(com.ooc.OCI.Buffer buf, boolean block)
    {
	try
	{
	    if(block)
	    {
		if(soTimeout_ != 0)
		{
		    soTimeout_ = 0;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }
	    else
	    {
		if(soTimeout_ != 1)
		{
		    soTimeout_ = 1;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }

	    while(!buf.is_full())
	    {
		java.io.InputStream in = socket_.getInputStream();
		int result = in.read(buf.data(), buf.pos(), buf.rest_length());
		if(result <= 0)
		{
		    throw new org.omg.CORBA.COMM_FAILURE(
			"", com.ooc.CORBA.MinorCommFailure._MinorRecvZero,
			org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
		}
		buf.advance(result);
	    }
	}
	catch(java.io.InterruptedIOException ex)
	{
	    buf.advance(ex.bytesTransferred);
	}
	catch(java.io.IOException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		ex.toString(), com.ooc.CORBA.MinorCommFailure._MinorRecv,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
	catch(java.lang.NullPointerException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", com.ooc.CORBA.MinorCommFailure._MinorRecv,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
    }

    public boolean
    receive_detect(com.ooc.OCI.Buffer buf, boolean block)
    {
	try
	{
	    if(block)
	    {
		if(soTimeout_ != 0)
		{
		    soTimeout_ = 0;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }
	    else
	    {
		if(soTimeout_ != 1)
		{
		    soTimeout_ = 1;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }
		
	    while(!buf.is_full())
	    {
		java.io.InputStream in = socket_.getInputStream();
		int result = in.read(buf.data(), buf.pos(), buf.rest_length());
		if(result <= 0)
		    return false;
		buf.advance(result);
	    }
	}
	catch(java.io.InterruptedIOException ex)
	{
	    buf.advance(ex.bytesTransferred);
	}
	catch(java.io.IOException ex)
	{
	    return false;
	}
	catch(java.lang.NullPointerException ex)
	{
	    return false;
	}

	return true;
    }

    public void
    receive_timeout(com.ooc.OCI.Buffer buf, int t)
    {
	if(t < 0)
	    throw new InternalError();

	try
	{
	    if(t < 1)
		t = 1;

	    if(soTimeout_ != t)
	    {
		soTimeout_ = t;
		socket_.setSoTimeout(soTimeout_);
	    }
		
	    while(!buf.is_full())
	    {
		java.io.InputStream in = socket_.getInputStream();
		int result = in.read(buf.data(), buf.pos(), buf.rest_length());
		if(result <= 0)
		{
		    throw new org.omg.CORBA.COMM_FAILURE(
			"", com.ooc.CORBA.MinorCommFailure._MinorRecvZero,
			org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
		}
		buf.advance(result);
	    }
	}
	catch(java.io.InterruptedIOException ex)
	{
	    buf.advance(ex.bytesTransferred);
	}
	catch(java.net.SocketException ex)
	{
	    // Sometimes I get `java.net.SocketException: Interrupted
	    // system call' instead of java.io.InterruptedIOException
	    // at this point.  Is this a bug in the JDK?
	}
	catch(java.io.IOException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		ex.toString(), com.ooc.CORBA.MinorCommFailure._MinorRecv,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
	catch(java.lang.NullPointerException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", com.ooc.CORBA.MinorCommFailure._MinorRecv,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
    }

    public void
    send(com.ooc.OCI.Buffer buf, boolean block)
    {
	try
	{
	    if(block)
	    {
		if(soTimeout_ != 0)
		{
		    soTimeout_ = 0;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }
	    else
	    {
		if(soTimeout_ != 1)
		{
		    soTimeout_ = 1;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }
		
	    java.io.OutputStream out = socket_.getOutputStream();
	    out.write(buf.data(), buf.pos(), buf.rest_length());
	    out.flush();
	    buf.pos(buf.length());
	}
	catch(java.io.InterruptedIOException ex)
	{
	    buf.advance(ex.bytesTransferred);
	}
	catch(java.io.IOException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		ex.toString(), com.ooc.CORBA.MinorCommFailure._MinorSend,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
	catch(java.lang.NullPointerException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", com.ooc.CORBA.MinorCommFailure._MinorSend,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
    }

    public boolean
    send_detect(com.ooc.OCI.Buffer buf, boolean block)
    {
	try
	{
	    if(block)
	    {
		if(soTimeout_ != 0)
		{
		    soTimeout_ = 0;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }
	    else
	    {
		if(soTimeout_ != 1)
		{
		    soTimeout_ = 1;
		    socket_.setSoTimeout(soTimeout_);
		}
	    }
		
	    java.io.OutputStream out = socket_.getOutputStream();
	    out.write(buf.data(), buf.pos(), buf.rest_length());
	    out.flush();
	    buf.pos(buf.length());
	}
	catch(java.io.InterruptedIOException ex)
	{
	    buf.advance(ex.bytesTransferred);
	}
	catch(java.io.IOException ex)
	{
	    return false;
	}
	catch(java.lang.NullPointerException ex)
	{
	    return false;
	}

	return true;
    }

    public void
    send_timeout(com.ooc.OCI.Buffer buf, int t)
    {
	if(t < 0)
	    throw new InternalError();

	try
	{
	    if(t < 1)
		t = 1;

	    if(soTimeout_ != t)
	    {
		soTimeout_ = t;
		socket_.setSoTimeout(soTimeout_);
	    }
		
	    java.io.OutputStream out = socket_.getOutputStream();
	    out.write(buf.data(), buf.pos(), buf.rest_length());
	    out.flush();
	    buf.pos(buf.length());
	}
	catch(java.io.InterruptedIOException ex)
	{
	    buf.advance(ex.bytesTransferred);
	}
	catch(java.io.IOException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		ex.toString(), com.ooc.CORBA.MinorCommFailure._MinorSend,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
	catch(java.lang.NullPointerException ex)
	{
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", com.ooc.CORBA.MinorCommFailure._MinorSend,
                org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);  
	}
    }

    public com.ooc.OCI.TransportInfo
    get_info()
    {
        return info_;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    Transport(com.ooc.OCI.Connector connector,
              java.net.Socket socket)
    {
	//System.out.println("Transport");
	socket_ = socket;
        info_ = new TransportInfo(this, connector);
    }

    public
    Transport(com.ooc.OCI.Acceptor acceptor,
              java.net.Socket socket)
    {
	//System.out.println("Transport");
	socket_ = socket;
        info_ = new TransportInfo(this, acceptor);
    }

    public void
    finalize()
	throws Throwable
    {
	//System.out.println("~Transport");
	if(socket_ != null)
	    close(true);

	super.finalize();
    }
}

