// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class TransportInfo extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.IIOP.TransportInfo
{
    private com.ooc.OCI.ConnectorInfo connectorInfo_; // The connector info
    private com.ooc.OCI.AcceptorInfo acceptorInfo_; // The acceptor info
    private Transport transport_; // The associated transport

    //
    // All close callback objects
    //
    private java.util.Vector closeCBVec_ = new java.util.Vector();

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int tag()
    {
        return org.omg.IOP.TAG_INTERNET_IOP.value;
    }
    
    public synchronized com.ooc.OCI.ConnectorInfo connector_info()
    {
        return connectorInfo_;
    }
    
    public synchronized com.ooc.OCI.AcceptorInfo acceptor_info()
    {
        return acceptorInfo_;
    }

    public synchronized void
    add_close_cb(com.ooc.OCI.CloseCB cb)
    {
        int length = closeCBVec_.size();
        for(int i = 0; i < length; ++i)
            if(closeCBVec_.elementAt(i) == cb)
                return; // Already registered
        closeCBVec_.addElement(cb);
    }

    public synchronized void
    remove_close_cb(com.ooc.OCI.CloseCB cb)
    {
        int length = closeCBVec_.size();
        for(int i = 0; i < length; ++i)
            if(closeCBVec_.elementAt(i) == cb)
            {
                closeCBVec_.removeElementAt(i);
                return;
            }
    }

    public synchronized byte[] addr()
    {
	if(transport_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        return transport_.socket_.getLocalAddress().getAddress();
    }

    public synchronized short port()
    {
	if(transport_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        int port = transport_.socket_.getLocalPort();

	if(port >= 0x8000)
	    return (short)(port - 0xffff - 1);
	else
	    return (short)port;
    }

    public synchronized byte[] remote_addr()
    {
	if(transport_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        return transport_.socket_.getInetAddress().getAddress();
    }

    public synchronized short remote_port()
    {
	if(transport_ == null)
	    throw new org.omg.CORBA.NO_RESOURCES();

        int port = transport_.socket_.getPort();

	if(port >= 0x8000)
	    return (short)(port - 0xffff - 1);
	else
	    return (short)port;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    TransportInfo(Transport transport,
                  com.ooc.OCI.Connector connector)
    {
        transport_ = transport;
        connectorInfo_ = connector.get_info();
    }

    TransportInfo(Transport transport,
                  com.ooc.OCI.Acceptor acceptor)
    {
        transport_ = transport;
        acceptorInfo_ = acceptor.get_info();
    }

    synchronized void
    _OB_callCloseCB(com.ooc.OCI.TransportInfo info)
    {
        int length = closeCBVec_.size();
        for(int i = 0; i < length; ++i)
        {
            com.ooc.OCI.CloseCB cb =
                (com.ooc.OCI.CloseCB)closeCBVec_.elementAt(i);
            cb.close_cb(info);
        }
    }

    synchronized void
    _OB_destroy()
    {
	transport_ = null;
    }
}
