// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.IIOP.impl;

final public class Util
{
    static public org.omg.IOP.IOR
    createIOR(String host, int port, byte[] key, String id)
    {
	//
	// Create a new profile
	//
	org.omg.IIOP.ProfileBody body = new org.omg.IIOP.ProfileBody();
	body.iiop_version = new org.omg.IIOP.Version();
	body.iiop_version.major = 1;
	body.iiop_version.minor = 0;
	body.host = host;
	if(port >= 0x8000)
	    body.port = (short)(port - 0xffff - 1);
	else
	    body.port = (short)port;
	body.object_key = key;
	
	//
	// Create new IOR with the new profile
	//
	org.omg.IOP.IOR ior = new org.omg.IOP.IOR();
	ior.type_id = id;
	ior.profiles = new org.omg.IOP.TaggedProfile[1];
	ior.profiles[0] = new org.omg.IOP.TaggedProfile();
	ior.profiles[0].tag = org.omg.IOP.TAG_INTERNET_IOP.value;
	com.ooc.CORBA.OutputStream out = new com.ooc.CORBA.OutputStream();
	out._OB_writeEndian();
	org.omg.IIOP.ProfileBodyHelper.write(out, body);
	byte[] pData = new byte[out._OB_count()];
        System.arraycopy(out._OB_buffer(), 0, pData, 0, pData.length);
	ior.profiles[0].profile_data = pData;
	
	return ior;
    }

    static public boolean
    compareBodies(org.omg.IIOP.ProfileBody body1,
		  org.omg.IIOP.ProfileBody body2)
    {
	//
	// Compare versions
	//
	if(body1.iiop_version.major != body2.iiop_version.major ||
	   body1.iiop_version.minor != body2.iiop_version.minor)
	    return false;
	
	//
	// Compare ports
	//
	if(body1.port != body2.port)
	    return false;
	
	//
	// Compare object keys
	//
	if(body1.object_key.length != body2.object_key.length)
	    return false;
	
	int k;
	for(k = 0 ; k < body1.object_key.length ; k++)
	    if(body1.object_key[k] != body2.object_key[k])
		break;
	
	if(k < body1.object_key.length)
	    return false;
	
	//
	// Direct host name comparison
	//
	if(!body1.host.equals(body2.host))
	{
	    //
	    // Direct host name comparision failed - must look up
	    // addresses to be really sure if the hosts differ
	    //
	    try
	    {
		if(!java.net.InetAddress.getByName(body1.host)
		   .equals(java.net.InetAddress.getByName(body2.host)))
		    return false;
	    }
	    catch(java.net.UnknownHostException ex)
	    {
		//
		// Return false on hostname lookup failure
		//
		return false;
	    }
	}

	//
	// OK, found a match
	//
	return true;
    }

    static public boolean
    equivalent(org.omg.IOP.IOR ior1, org.omg.IOP.IOR ior2)
    {
        int p1, p2, b1, b2;
        int cnt1 = 0, cnt2 = 0;
        org.omg.IIOP.ProfileBody[] bodies1;
        org.omg.IIOP.ProfileBody[] bodies2;

	//
	// Calculate number of IIOP profiles in ior1
	//
	for(p1 = 0; p1 < ior1.profiles.length; p1++)
	    if(ior1.profiles[p1].tag == org.omg.IOP.TAG_INTERNET_IOP.value)
		cnt1++;

	//
	// Calculate number of IIOP profiles in ior2
	//
	for(p2 = 0; p2 < ior2.profiles.length; p2++)
	    if(ior2.profiles[p2].tag == org.omg.IOP.TAG_INTERNET_IOP.value)
		cnt2++;

	//
	// Return false now if the number of IIOP profile bodies do
	// not match
	//
	if(cnt1 != cnt2)
	    return false;

	//
	// Create an array with all IIOP profile bodies of ior1
	//
	bodies1 = new org.omg.IIOP.ProfileBody[cnt1];
	for(p1 = 0, b1 = 0; p1 < ior1.profiles.length; p1++)
	    if(ior1.profiles[p1].tag == org.omg.IOP.TAG_INTERNET_IOP.value)
	    {
		byte[] buf = ior1.profiles[p1].profile_data;
		com.ooc.CORBA.InputStream in =
		    new com.ooc.CORBA.InputStream(buf);
		in._OB_readEndian();
		bodies1[b1++] = org.omg.IIOP.ProfileBodyHelper.read(in);
	    }
	
	if(b1 != cnt1)
	    throw new InternalError();
            
	//
	// Create an array with all IIOP profile bodies of ior2
	//
	bodies2 = new org.omg.IIOP.ProfileBody[cnt2];
	for(p2 = 0, b2 = 0; p2 < ior2.profiles.length; p2++)
	    if(ior2.profiles[p2].tag == org.omg.IOP.TAG_INTERNET_IOP.value)
	    {
		byte[] buf = ior2.profiles[p2].profile_data;
		com.ooc.CORBA.InputStream in =
		    new com.ooc.CORBA.InputStream(buf);
		in._OB_readEndian();
		bodies2[b2++] = org.omg.IIOP.ProfileBodyHelper.read(in);
	    }
	
	if(b2 != cnt2)
	    throw new InternalError();
            
	//
	// Check for profile body matches
	//
	for(b1 = 0 ; b1 < cnt1 ; b1++)
	{
	    for(b2 = 0 ; b2 < cnt2 ; b2++)
	    {
		if(bodies2[b2] == null)
		    continue;
                
		//
		// Compare profile bodies
		//
		if(!compareBodies(bodies1[b1], bodies2[b2]))
		    continue;
		
		//
		// OK, found a match
		//
		bodies1[b1] = null;
		bodies2[b2] = null;
	    }
        }

	//
	// Check whether there are any unmatched IIOP profile bodies
	//
	int unmatched1 = 0;
        for(b1 = 0; b1 < cnt1; b1++)
            if(bodies1[b1] != null)
                unmatched1++;
        
	int unmatched2 = 0;
        for(b2 = 0; b2 < cnt2; b2++)
            if(bodies2[b2] != null)
                unmatched2++;
        
	return unmatched1 == 0 && unmatched2 == 0;
    }
    
    static public int
    hash(org.omg.IOP.IOR ior, int maximum)
    {
        int hash = 0;

	for(int i = 0; i < ior.profiles.length; i++)
	{
	    if(ior.profiles[i].tag == org.omg.IOP.TAG_INTERNET_IOP.value)
	    {
		//
		// Get the IIOP profile body
		//
		byte[] buf = ior.profiles[i].profile_data;
		com.ooc.CORBA.InputStream in =
		    new com.ooc.CORBA.InputStream(buf);
		in._OB_readEndian();
		org.omg.IIOP.ProfileBody body =
		    org.omg.IIOP.ProfileBodyHelper.read(in);
		
		//
		// Add port to hash
		//
		hash ^= body.port;
		
		//
		// Add object key to hash
		//
		for(int j = 0; j + 1 < body.object_key.length; j += 2)
		    hash ^= body.object_key[j + 1] * 256 +
			body.object_key[j];
	    }
	}
	
        return hash % (maximum + 1);
    }

    static public byte[]
    extractKey(org.omg.IOP.IOR ior, String host, int port,
	       boolean loopbackMatches)
    {
	for(int i = 0; i < ior.profiles.length; i++)
	{
	    if(ior.profiles[i].tag == org.omg.IOP.TAG_INTERNET_IOP.value)
	    {
		//
		// Get the IIOP profile body
		//
		byte[] buf = ior.profiles[i].profile_data;
		com.ooc.CORBA.InputStream in =
		    new com.ooc.CORBA.InputStream(buf);
		in._OB_readEndian();
		org.omg.IIOP.ProfileBody body =
		    org.omg.IIOP.ProfileBodyHelper.read(in);
		
		//
		// Compare ports
		//
		int intPort;
		if(body.port < 0)
		    intPort = 0xffff + (int)body.port + 1;
		else
		    intPort = (int)body.port;
		if(port != intPort)
		    continue;
		
		//
		// Direct host name comparison
		//
		if(!host.equals(body.host))
		{
		    //
		    // Direct host name comparision failed - must look up
		    // addresses to be really sure if the hosts differ
		    //
		    try
		    {
			if(!java.net.InetAddress.getByName(host).equals(
			    java.net.InetAddress.getByName(body.host)))
			{
			    //
			    // Address comparison failed - shall I extract
			    // the key if the profile body contains the
			    // loopback address?
			    //
			    if(loopbackMatches)
			    {
				if(!java.net.InetAddress.getLocalHost().equals(
				    java.net.InetAddress.getByName(body.host)))
				{
				    continue;
				}
			    }
			    else
				continue;
			}
		    }
		    catch(java.net.UnknownHostException ex)
		    {
			//
			// Continue on hostname lookup failure
			//
			continue;
		    }
		}
		
		//
		// OK, found a match
		//
		return body.object_key; // No duplication for optimization
	    }
	}
	
	return new byte[0];
    }
}
