// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.impl;
import com.ooc.OCI.*;

public final class AccRegistry extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.AccRegistry
{
    //
    // All acceptors
    //
    java.util.Vector acceptors_ = new java.util.Vector();

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public synchronized void
    add_acceptor(Acceptor acceptor)
    {
	acceptors_.addElement(acceptor);
    }

    public synchronized Acceptor[]
    get_acceptors()
    {
	Acceptor[] acceptors = new Acceptor[acceptors_.size()];

	for(int i = 0 ; i < acceptors_.size() ; i++)
	{
	    Acceptor acceptor = (Acceptor)acceptors_.elementAt(i);
	    acceptors[i] = acceptor;
	}

	return acceptors;
    }

    public synchronized void
    add_profiles(byte[] key, org.omg.IOP.IORHolder ior)
    {
	for(int i = 0 ; i < acceptors_.size() ; i++)
	{
	    Acceptor acceptor = (Acceptor)acceptors_.elementAt(i);
	    acceptor.add_profile(key, ior);
	}
    }

    public byte[]
    is_local(org.omg.IOP.IOR ior)
    {
	for(int i = 0 ; i < acceptors_.size() ; i++)
	{
	    Acceptor acceptor = (Acceptor)acceptors_.elementAt(i);
	    byte[] key = acceptor.is_local(ior);
	    if(key.length > 0)
		return key;
	}

	return new byte[0];
    }
    
    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    AccRegistry()
    {
    }
}
