// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.OCI.impl;
import com.ooc.OCI.*;

public final class ConFactoryRegistry extends com.ooc.CORBA.LocalObject
    implements com.ooc.OCI.ConFactoryRegistry
{
    //
    // All connector factories
    //
    java.util.Vector factories_ = new java.util.Vector();

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public void
    add_factory(ConFactory factory)
    {
        factories_.insertElementAt(factory, 0);
    }

    public ConFactory
    get_factory(org.omg.IOP.IOR ior)
    {
        org.omg.CORBA.Policy[] dummyPolicies = new org.omg.CORBA.Policy[0];
        return get_factory_with_policies(ior, dummyPolicies);
    }

    public ConFactory
    get_factory_with_policies(org.omg.IOP.IOR ior,
                              org.omg.CORBA.Policy[] policies)
    {

        for(int j = 0 ; j < factories_.size() ; j++)
        {
            ConFactory factory = (ConFactory)factories_.elementAt(j);
            if(factory.consider_with_policies(ior, policies))
                return factory;
        }
	return null;
    }
    
    public ConFactory[]
    get_factories()
    {
	ConFactory[] factories = new ConFactory[factories_.size()];

	for(int i = 0 ; i < factories_.size() ; i++)
	{
	    ConFactory factory = (ConFactory)factories_.elementAt(i);
	    factories[i] = factory;
	}

	return factories;
    }

    public boolean
    equivalent(org.omg.IOP.IOR ior1, org.omg.IOP.IOR ior2)
    {
	for(int i = 0 ; i < factories_.size() ; i++)
	{
	    ConFactory factory = (ConFactory)factories_.elementAt(i);
	    if(!factory.equivalent(ior1, ior2))
		return false;
	}

	return true;
    }

    public int
    hash(org.omg.IOP.IOR ior, int maximum)
    {
        int hash = 0;
        
        for(int i = 0 ; i < factories_.size() ; i++)
        {
            ConFactory factory = (ConFactory)factories_.elementAt(i);
            hash ^= factory.hash(ior, maximum);
        }
        
        return hash % (maximum + 1);
    }
    
    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    ConFactoryRegistry()
    {
    }
}
