// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package org.omg.CORBA;

final public class COMM_FAILUREHelper
{
    public static void
    insert(Any any, COMM_FAILURE val)
    {
	any.type(type());
        write(any.create_output_stream(), val);
    }

    public static COMM_FAILURE
    extract(Any any)
    {
	if(any.type().equal(type()))
	    return read(any.create_input_stream());
	else
	    throw new BAD_OPERATION();
    }

    private static TypeCode typeCode_;

    public static TypeCode
    type()
    {
        if(typeCode_ == null)
        {
            ORB orb = ORB.init();
            StructMember[] members = new StructMember[0];

            typeCode_ = orb.create_exception_tc(id(), "COMM_FAILURE", members);
        }

        return typeCode_;
    }

    public static String
    id()
    {
        return "IDL:omg.org/CORBA/COMM_FAILURE:1.0";
    }

    public static COMM_FAILURE
    read(org.omg.CORBA.portable.InputStream in)
    {
        if(!id().equals(in.read_string()))
            throw new MARSHAL();

        COMM_FAILURE val = new COMM_FAILURE();
	val.minor = in.read_ulong();
	val.completed = CompletionStatus.from_int(in.read_ulong());
        return val;
    }

    public static void
    write(org.omg.CORBA.portable.OutputStream out, COMM_FAILURE val)
    {
        out.write_string(id());
	out.write_ulong(val.minor);
	out.write_ulong(val.completed.value());
    }
}
