// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package org.omg.CORBA;

public final class CompletionStatus
{
    private static CompletionStatus[] values_ = new CompletionStatus[3];
    private int value_;

    public static final int _COMPLETED_YES = 0;
    public static final int _COMPLETED_NO = 1;
    public static final int _COMPLETED_MAYBE = 2;

    public static final CompletionStatus COMPLETED_YES =
        new CompletionStatus(_COMPLETED_YES);
    public static final CompletionStatus COMPLETED_NO =
        new CompletionStatus(_COMPLETED_NO);
    public static final CompletionStatus COMPLETED_MAYBE =
        new CompletionStatus(_COMPLETED_MAYBE);

    public int value()
    {
	return value_;
    }

    public static CompletionStatus from_int(int value)
    {
	return values_[value];
    }

    private CompletionStatus(int value)
    {
	values_[value] = this;
	value_ = value;
    }
}
