// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package org.omg.CORBA;

public abstract class ORB
{
    public abstract String[]
    list_initial_services();

    public abstract org.omg.CORBA.Object
    resolve_initial_references(String object_name)
	throws org.omg.CORBA.ORBPackage.InvalidName;

    public abstract String
    object_to_string(org.omg.CORBA.Object object);

    public abstract org.omg.CORBA.Object
    string_to_object(String str);

    public abstract NVList
    create_list(int count);

    public abstract NVList
    create_operation_list(OperationDef oper);

    public abstract NamedValue
    create_named_value(String name, Any value, int flags);

    public abstract ExceptionList
    create_exception_list();

    public abstract ContextList
    create_context_list();

    public abstract Context
    get_default_context();

    public abstract Environment
    create_environment();

    public abstract void
    send_multiple_requests_oneway(Request[] req);

    public abstract void
    send_multiple_requests_deferred(Request[] req);

    public abstract boolean
    poll_next_response();

    public abstract Request
    get_next_response();

    public abstract TypeCode
    create_struct_tc(String id, String name, StructMember[] members);

    public abstract TypeCode
    create_union_tc(String id, String name, TypeCode discriminatorType,
		    UnionMember[] members);

    public abstract TypeCode
    create_enum_tc(String id, String name, String[] members);

    public abstract TypeCode
    create_alias_tc(String id, String name,TypeCode originalType);

    public abstract TypeCode
    create_exception_tc(String id, String name, StructMember[] members);

    public abstract TypeCode
    create_interface_tc(String id, String name);

    public abstract TypeCode
    create_string_tc(int bound);

    public abstract TypeCode
    create_wstring_tc(int bound);

    public abstract TypeCode
    create_sequence_tc(int bound, TypeCode elementType);

    public abstract TypeCode
    create_recursive_sequence_tc(int bound, int offset);

    public abstract TypeCode
    create_array_tc(int length, TypeCode elementType);

    public abstract TypeCode
    get_primitive_tc(TCKind kind);

    public abstract Any
    create_any();

    public abstract org.omg.CORBA.portable.OutputStream
    create_output_stream();

    public abstract void
    connect(org.omg.CORBA.Object obj);

    public abstract void
    disconnect(org.omg.CORBA.Object obj);

    public abstract org.omg.CORBA.DynAny
    create_dyn_any(org.omg.CORBA.Any value);

    public abstract org.omg.CORBA.DynAny
    create_basic_dyn_any(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode;

    public abstract org.omg.CORBA.DynStruct
    create_dyn_struct(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode;

    public abstract org.omg.CORBA.DynSequence
    create_dyn_sequence(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode;

    public abstract org.omg.CORBA.DynArray
    create_dyn_array(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode;

    public abstract org.omg.CORBA.DynUnion
    create_dyn_union(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode;

    public abstract org.omg.CORBA.DynEnum
    create_dyn_enum(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode;

    public abstract org.omg.CORBA.DynFixed
    create_dyn_fixed(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode;

     public abstract org.omg.CORBA.Policy
     create_policy(int policy_type, org.omg.CORBA.Any val)
          throws org.omg.CORBA.PolicyError;

    // Deprecated by CORBA 2.2
    public Current
    get_current()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    private static ORB ORBSingleton_;

    public static ORB
    init(String[] args, java.util.Properties props)
    {
	String orbClassName = null;

	if(props != null)
	    orbClassName = props.getProperty("DEFAULT_ORB_CLASS_NAME");

	if(orbClassName == null)
	    orbClassName = "com.ooc.CORBA.ORB";

	ORB orb;

	try
	{
	    orb = (ORB)Class.forName(orbClassName).newInstance();
	}
	catch(Throwable ex)
	{
	    throw new org.omg.CORBA.INITIALIZE
		("Invalid ORB class: " + orbClassName);
	}

	orb.set_parameters(args, props);

	ORBSingleton_ = orb;

	return orb;
    }

    public static ORB
    init(java.applet.Applet app, java.util.Properties props)
    {
	String orbClassName = null;

	if(props != null)
	    orbClassName = props.getProperty("DEFAULT_ORB_CLASS_NAME");

	if(orbClassName == null)
	    orbClassName = "com.ooc.CORBA.ORB";

	ORB orb;

	try
	{
	    orb = (ORB)Class.forName(orbClassName).newInstance();
	}
	catch(Throwable ex)
	{
	    throw new org.omg.CORBA.INITIALIZE
		("Invalid ORB class: " + orbClassName);
	}

	orb.set_parameters(app, props);

	ORBSingleton_ = orb;

	return orb;
    }

    public static ORB
    init()
    {
	if(ORBSingleton_ == null)
	{
	    String orbClassName = "com.ooc.CORBA.ORBSingleton";
	    
	    ORB orb;

	    try
	    {
		orb = (ORB)Class.forName(orbClassName).newInstance();
	    }
	    catch(Throwable ex)
	    {
		throw new org.omg.CORBA.INITIALIZE
		    ("Invalid ORB singleton class: " + orbClassName);
	    }

	    ORBSingleton_ = orb;
	}

	return ORBSingleton_;
    }

    protected abstract void
    set_parameters(String[] args, java.util.Properties props);

    protected abstract void
    set_parameters(java.applet.Applet app, java.util.Properties props);

    public abstract BOA
    BOA_init(String[] args, java.util.Properties props);

    public abstract BOA
    BOA_init(java.applet.Applet app, java.util.Properties props);
}
