// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Client extends TestBase
{
    static public int
    run(ORB orb)
	throws TestException
    {
	//
	// Get TestInterface
	//
	String impl;
	String implDSI;
	String implTie;

	try
	{
	    String refFile = "TestInterface.ref";
	    FileInputStream file = new FileInputStream(refFile);
	    BufferedReader in =
		new BufferedReader(new InputStreamReader(file));
	    impl = in.readLine();
	    implDSI = in.readLine();
	    implTie = in.readLine();
	    file.close();
 	}
	catch(IOException ex)
	{
	    System.err.println("Can't read from `" +
			       ex.getMessage() + "'");
	    return 1;
	}
 
	//
	// Run tests
	//
	System.out.print("Testing constants... ");
	System.out.flush();
	new TestConst();
	System.out.println("OK!");

	System.out.print("Testing TypeCode type... ");
	System.out.flush();
	new TestTypeCode();
	System.out.println("OK!");

	System.out.print("Testing any type... ");
	System.out.flush();
	new TestAny();
	System.out.println("OK!");

 	System.out.print("Testing DynAny... ");
 	System.out.flush();
 	new TestDynAny();
 	System.out.println("OK!");

	System.out.print("Testing some union types... ");
	System.out.flush();
	new TestUnion();
	System.out.println("OK!");

	System.out.print("Testing string_to_object()... ");
	System.out.flush();
 	org.omg.CORBA.Object obj = orb.string_to_object(impl);
 	TEST(obj != null);
	org.omg.CORBA.Object objDSI = orb.string_to_object(implDSI);
	TEST(objDSI != null);
        boolean tie = false;
	org.omg.CORBA.Object objTie = null;
	if(implTie != null)
	{
	    try
	    {
		objTie = orb.string_to_object(implTie);
		TEST(objTie != null);
		tie = true;
	    }
	    catch(org.omg.CORBA.INV_OBJREF ex)
	    {
	    }
	}
	System.out.println("OK!");

	System.out.print("Testing _narrow()... ");
	System.out.flush();
 	TestInterface ti = TestInterfaceHelper.narrow(obj);
 	TEST(ti != null);
	TestInterface tiDSI = TestInterfaceHelper.narrow(objDSI);
	TEST(tiDSI != null);
	TestInterface tiTie = null;
	if(tie)
	{
	    tiTie = TestInterfaceHelper.narrow(objTie);
	    TEST(tiTie != null);
	}

 	TestInterfaceEx tiex = TestInterfaceExHelper.narrow(obj);
 	TEST(tiex != null);
	TestInterfaceEx tiexDSI = TestInterfaceExHelper.narrow(objDSI);
	TEST(tiexDSI != null);
	TestInterfaceEx tiexTie = null;
	if(tie)
	{
	    tiexTie = TestInterfaceExHelper.narrow(objTie);
	    TEST(tiexTie != null);
	}

 	TestInterfaceTimeout titimeout = TestInterfaceTimeoutHelper.narrow(ti);
 	TEST(titimeout != null);
	System.out.println("OK!");

 	System.out.print("Testing interface stub... ");
 	System.out.flush();
 	new TestStub(ti);
 	System.out.println("OK!");

	System.out.print("Ditto, but with the DSI implementation... ");
	System.out.flush();
	new TestStub(tiDSI);
	System.out.println("OK!");

	if(tie)
	{
	    System.out.print("Ditto, but with the tie implementation... ");
	    System.out.flush();
	    new TestStub(tiTie);
	    System.out.println("OK!");
	}

	System.out.print("Testing interface stub with contexts... ");
	System.out.flush();
	new TestStubContext(orb, ti);
	System.out.println("OK!");

	System.out.print("Ditto, but with the DSI implementation... ");
	System.out.flush();
	new TestStubContext(orb, tiDSI);
	System.out.println("OK!");

	if(tie)
	{
	    System.out.print("Ditto, but with the tie implementation... ");
	    System.out.flush();
	    new TestStubContext(orb, tiTie);
	    System.out.println("OK!");
	}

	System.out.print("Testing interface stub with exceptions... ");
	System.out.flush();
	new TestStubException(tiex, false);
	System.out.println("OK!");

	System.out.print("Ditto, but with the DSI implementation... ");
	System.out.flush();
	new TestStubException(tiexDSI, true);
	System.out.println("OK!");

	if(tie)
	{
	    System.out.print("Ditto, but with the tie implementation... ");
	    System.out.flush();
	    new TestStubException(tiexTie, true);
	    System.out.println("OK!");
	}

 	System.out.print("Testing interface stub with timeouts... ");
 	System.out.flush();
 	new TestStubTimeout(orb, titimeout);
 	System.out.println("OK!");

	System.out.print("Testing DII... ");
	System.out.flush();
	new TestDII(obj);
	System.out.println("OK!");

	System.out.print("Ditto, but with the DSI implementation... ");
	System.out.flush();
	new TestDII(objDSI);
	System.out.println("OK!");

	if(tie)
	{
	    System.out.print("Ditto, but with the tie implementation... ");
	    System.out.flush();
	    new TestDII(objTie);
	    System.out.println("OK!");
	}

	System.out.print("Testing DII with contexts... ");
	System.out.flush();
	new TestDIIContext(orb, obj);
	System.out.println("OK!");

	System.out.print("Ditto, but with the DSI implementation... ");
	System.out.flush();
	new TestDIIContext(orb, tiDSI);
	System.out.println("OK!");

	if(tie)
	{
	    System.out.print("Ditto, but with the tie implementation... ");
	    System.out.flush();
	    new TestDIIContext(orb, tiTie);
	    System.out.println("OK!");
	}

	System.out.print("Testing DII with exceptions... ");
	System.out.flush();
	new TestDIIException(obj);
	System.out.println("OK!");

	System.out.print("Ditto, but with the DSI implementation... ");
	System.out.flush();
	new TestDIIException(objDSI);
	System.out.println("OK!");

	if(tie)
	{
	    System.out.print("Ditto, but with the tie implementation... ");
	    System.out.flush();
	    new TestDIIException(objTie);
	    System.out.println("OK!");
	}

	try
	{
	    ti.deactivate();
	}
	catch(org.omg.CORBA.TRANSIENT ex)
	{
	    // This call will deactivate the server and thus throw an
	    // exception
	}
	    
	return 0;
    }

    static public void
    main(String args[])
    {
	//
	// For debugging purposes
	//
	Runtime.runFinalizersOnExit(true);

	int status = 0;

	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

        try
        {
            //
            // Create ORB
            //
            ORB orb = ORB.init(args, props);

            //
	    // Run tests
	    //
	    status = run(orb);
	}
	catch(SystemException ex)
        {
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    status = 1;
	}

	System.exit(status);
    }
}
