// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Server
{
    static public int
    run(ORB orb, BOA boa)
    {
	//
	// Create implementation objects
	//
	TestInterfaceTimeout i = new TestInterfaceTimeout_impl(boa);
	org.omg.CORBA.Object p = i;
	String impl = orb.object_to_string(p);
    
	TestInterfaceExDSI_impl iDSI = new TestInterfaceExDSI_impl(orb, i);
	org.omg.CORBA.Object pDSI = iDSI;
	String implDSI = orb.object_to_string(pDSI);

	TestInterfaceTimeoutOperations op = (TestInterfaceTimeoutOperations)i;
	_TestInterfaceTimeoutImplBase_tie iTie =
	    new _TestInterfaceTimeoutImplBase_tie(op);
	org.omg.CORBA.Object pTie = iTie;
	String implTie = orb.object_to_string(pTie);

	//
	// Save references
	//
	String refFile = "TestInterface.ref";
	try
	{
	    FileOutputStream file = new FileOutputStream(refFile);
	    PrintWriter out = new PrintWriter(file);
	    out.println(impl);
	    out.println(implDSI);
	    out.println(implTie);
	    out.flush();
	    file.close();
 	}
	catch(IOException ex)
	{
	    System.err.println("Can't write to `" +
			       ex.getMessage() + "'");
	    return 1;
	}

	//
	// Run implementation
	//
	boa.impl_is_ready(null);

	//
	// Delete reference file
	//
 	File file = new File(refFile);
 	file.delete();

	return 0;
    }

    static public void
    main(String args[])
    {
	//
	// For debugging purposes
	//
	Runtime.runFinalizersOnExit(true);

	int status = 0;

	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

        try
        {
            //
            // Create ORB
            //
            ORB orb = ORB.init(args, props);

            //
            // Create BOA (This is ORBacus specific)
            //
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
	    // Run tests
	    //
	    status = run(orb, boa);
	}
	catch(SystemException ex)
        {
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    status = 1;
	}

	System.exit(status);
    }
}
