// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;

class TestConst extends TestBase
{
    static final long constLong = -1234;
    static final long constULong = (5432 + constLong ) * 100 % 124;
    static final double constDouble = 50.23 - constLong * (constULong - 3.14);
    static final float constFloat = (float)(constDouble * 1.11);
    static final short constShort = -23 % 10;
    static final boolean constBoolean = true;
    static final String constString = "This is ConstString";

    static final long constLongI = (0xf | 0xf000) & 0xfffe;
    static final char constChar1 = 'c';
    static final char constChar2 = '\n';
    static final char constChar3 = '\377';
    static final char constChar4 = '\210';
    static final char constChar5 = '\'';
    static final String constStringI = "\n\t\013\b\r\f\007\\?\'\"\377\377\007";

    TestConst()
    {
	{
	    TEST(constLong == ConstLong.value);
	    TEST(constULong == ConstULong.value);
	    TEST(constDouble == ConstDouble.value);
	    TEST(constFloat == ConstFloat.value);
	    TEST(constShort == ConstShort.value);
	    TEST(constBoolean == ConstBoolean.value);
	    // This fails if I use VJ++ 1.1. Must be a bug.
	    //TEST(constString.equals(ConstString.value));
	}

	{
	    TEST(constLongI == TestConstInterface.ConstLong);
	    TEST(constChar1 == TestConstInterface.ConstChar1);
	    TEST(constChar2 == TestConstInterface.ConstChar2);
	    TEST(constChar3 == TestConstInterface.ConstChar3);
	    TEST(constChar4 == TestConstInterface.ConstChar4);
	    TEST(constChar5 == TestConstInterface.ConstChar5);
	    // This fails if I use VJ++ 1.1. Must be a bug.
	    //TEST(constStringI.equals(TestConstInterface.ConstString));
	}
    }
}

