// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;

class TestDII extends TestBase
{
    TestDII(org.omg.CORBA.Object ti)
    {
	int i, j;

	ORB orb = ORB.init();

	{
	    Request request;

	    request = ti._request("opVoid");
	    request.invoke();
	}

	{
	    Request request;

	    short ret;
	    short inOut;
	    short out;

	    request = ti._request("_set_attrShort");
	    request.add_in_arg().insert_short((short)-32768);
	    request.invoke();
	    request = ti._request("_get_attrShort");
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_short));
	    request.invoke();
	    ret = request.return_value().extract_short();
	    TEST(ret == -32768);

	    request = ti._request("_set_attrShort");
	    request.add_in_arg().insert_short((short)32767);
	    request.invoke();
	    request = ti._request("_get_attrShort");
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_short));
	    request.invoke();
	    ret = request.return_value().extract_short();
	    TEST(ret == 32767);

	    request = ti._request("opShort");
	    request.add_in_arg().insert_short((short)10);
	    Any inOutAny = request.add_inout_arg();
	    inOutAny.insert_short((short)20);
	    Any outAny = request.add_out_arg();
	    outAny.insert_short((short)0);
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_short));
	    request.invoke();
	    inOut = inOutAny.extract_short();
	    out = outAny.extract_short();
	    ret = request.return_value().extract_short();
	    TEST(ret == 30);
	    TEST(inOut == 30);
	    TEST(out == 30);
	}

	{
	    Request request;

	    double ret;
	    double inOut;
	    double out;

	    request = ti._request("_set_attrDouble");
	    request.add_in_arg().insert_double(1.7976931348623157E+308);
	    request.invoke();
	    request = ti._request("_get_attrDouble");
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_double));
	    request.invoke();
	    ret = request.return_value().extract_double();
	    TEST(ret == 1.7976931348623157E+308);

	    request = ti._request("_set_attrDouble");
	    request.add_in_arg().insert_double(2.2250738585072014E-308);
	    request.invoke();
	    request = ti._request("_get_attrDouble");
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_double));
	    request.invoke();
	    ret = request.return_value().extract_double();
	    TEST(ret == 2.2250738585072014E-308);

	    request = ti._request("opDouble");
	    request.add_in_arg().insert_double(10.0);
	    Any inOutAny = request.add_inout_arg();
	    inOutAny.insert_double(20.0);
	    Any outAny = request.add_out_arg();
	    outAny.insert_double(0);
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_double));
	    request.invoke();
	    inOut = inOutAny.extract_double();
	    out = outAny.extract_double();
	    ret = request.return_value().extract_double();
	    TEST(ret == 30);
	    TEST(inOut == 30);
	    TEST(out == 30);
	}

	{
	    Request request;

	    String ret;
	    String inOut;
	    String out;

	    request = ti._request("_set_attrString");
	    request.add_in_arg().insert_string("Hello");
	    request.invoke();
	    request = ti._request("_get_attrString");
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_string));
	    request.invoke();
	    ret = request.return_value().extract_string();
	    TEST(ret.equals("Hello"));

	    request = ti._request("opString");
	    request.add_in_arg().insert_string("Hello, ");
	    Any inOutAny = request.add_inout_arg();
	    inOutAny.insert_string("world!");
	    Any outAny = request.add_out_arg();
	    outAny.insert_string("");
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_string));
	    request.invoke();
	    inOut = inOutAny.extract_string();
	    out = outAny.extract_string();
	    ret = request.return_value().extract_string();
	    TEST(ret.equals("Hello, world!"));
	    TEST(out.equals("Hello, world!"));
	}

	{
	    Request request;

	    String[] seq = { "!!!", "@@@", "###" };

	    String[] ret;
	    String[] inOut;
	    String[] out;

	    request = ti._request("_set_attrStringSequence");
	    StringSequenceHelper.insert(request.add_in_arg(), seq);
	    request.invoke();
	    request = ti._request("_get_attrStringSequence");
	    request.set_return_type(StringSequenceHelper.type());
	    request.invoke();
	    ret = StringSequenceHelper.extract(request.return_value());
	    TEST(ret.length == 3);
	    TEST(ret[0].equals("!!!"));
	    TEST(ret[1].equals("@@@"));
	    TEST(ret[2].equals("###"));

	    inOut = new String[2];
	    inOut[0] = "%";
	    inOut[1] = "^^";
	    request = ti._request("opStringSequence");
	    StringSequenceHelper.insert(request.add_in_arg(), seq);
	    Any inOutAny = request.add_inout_arg();
	    StringSequenceHelper.insert(inOutAny, inOut);
	    Any outAny = request.add_out_arg();
	    outAny.type(StringSequenceHelper.type());
	    request.set_return_type(StringSequenceHelper.type());
	    request.invoke();
	    ret = StringSequenceHelper.extract(request.return_value());
	    inOut = StringSequenceHelper.extract(inOutAny);
	    out = StringSequenceHelper.extract(outAny);
	    TEST(ret.length == 5);
	    TEST(ret[0].equals("!!!"));
	    TEST(ret[1].equals("@@@"));
	    TEST(ret[2].equals("###"));
	    TEST(ret[3].equals("%"));
	    TEST(ret[4].equals("^^"));
	    TEST(inOut.length == 5);
	    TEST(inOut[0].equals("!!!"));
	    TEST(inOut[1].equals("@@@"));
	    TEST(inOut[2].equals("###"));
	    TEST(inOut[3].equals("%"));
	    TEST(inOut[4].equals("^^"));
	    TEST(out.length == 5);
	    TEST(out[0].equals("!!!"));
	    TEST(out[1].equals("@@@"));
	    TEST(out[2].equals("###"));
	    TEST(out[3].equals("%"));
	    TEST(out[4].equals("^^"));
	}

	{
	    Request request;

	    char ret;
	    char inOut;
	    char out;

	    request = ti._request("_set_attrChar");
	    request.add_in_arg().insert_char('a');
	    request.invoke();
	    request = ti._request("_get_attrChar");
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_char));
	    request.send_deferred();
	    try
	    {
		request.get_response();
	    }
	    catch(WrongTransaction ex)
	    {
		TEST(false);
	    }
	    ret = request.return_value().extract_char();
	    TEST(ret == 'a');

	    request = ti._request("opChar");
	    request.add_in_arg().insert_char('a');
	    Any inOutAny = request.add_inout_arg();
	    inOutAny.insert_char((char)1);
	    Any outAny = request.add_out_arg();
	    outAny.type(orb.get_primitive_tc(TCKind.tk_char));
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_char));
	    request.send_deferred();
	    try
	    {
		request.get_response();
	    }
	    catch(WrongTransaction ex)
	    {
		TEST(false);
	    }
	    inOut = inOutAny.extract_char();
	    out = outAny.extract_char();
	    ret = request.return_value().extract_char();
	    TEST(ret == 'b');
	    TEST(inOut == 'b');
	    TEST(out == 'b');
	}

	{
	    Request request;

	    String[][] ar =
	    {
		{ "aa", "bb", "cc" },
		{ "AA", "BB", "CC" }
	    };

	    String[][] ret = new String[2][3];
	    String[][] inOut = new String[2][3];
	    String[][] out = new String[2][3];

	    request = ti._request("_set_attrVariableArray");
	    VariableArrayHelper.insert(request.add_in_arg(), ar);
	    request.invoke();
	    request = ti._request("_get_attrVariableArray");
	    request.set_return_type(VariableArrayHelper.type());
	    request.send_deferred();
	    while(!request.poll_response())
		;
	    ret = VariableArrayHelper.extract(request.return_value());
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		{
		    TEST(ar[i][j].equals(ret[i][j]));
		}
	}

	{
	    float ret;
	    float inOut;
	    float out;

	    Request request1;
	    request1 = ti._request("_set_attrFloat");
	    request1.add_in_arg().insert_float(1);
	    request1.send_deferred();

	    Request request2;
	    request2 = ti._request("_get_attrFloat");
	    request2.set_return_type(orb.get_primitive_tc(TCKind.tk_float));
	    request2.send_deferred();

	    Request request3;
	    request3 = ti._request("_set_attrFloat");
	    request3.add_in_arg().insert_float(-1);
	    request3.send_deferred();

	    Request request4;
	    request4 = ti._request("_get_attrFloat");
	    request4.set_return_type(orb.get_primitive_tc(TCKind.tk_float));
	    request4.send_deferred();

	    Request request5;
	    request5 = ti._request("opFloat");
	    request5.add_in_arg().insert_float(10);
	    Any inOutAny = request5.add_inout_arg();
	    inOutAny.insert_float(20);
	    Any outAny = request5.add_out_arg();
	    outAny.insert_float(0);
	    request5.set_return_type(orb.get_primitive_tc(TCKind.tk_float));
	    request5.send_deferred();

	    try
	    {
		request5.get_response();
	    }
	    catch(WrongTransaction ex)
	    {
		TEST(false);
	    }
	    inOut = inOutAny.extract_float();
	    out = outAny.extract_float();
	    ret = request5.return_value().extract_float();
	    TEST(ret == 30);
	    TEST(inOut == 30);
	    TEST(out == 30);

	    try
	    {
		request2.get_response();
	    }
	    catch(WrongTransaction ex)
	    {
		TEST(false);
	    }
	    ret = request2.return_value().extract_float();
	    TEST(ret == 1);

	    try
	    {
		request4.get_response();
	    }
	    catch(WrongTransaction ex)
	    {
		TEST(false);
	    }
	    ret = request4.return_value().extract_float();
	    TEST(ret == -1);

	    try
	    {
		request1.get_response();
		request3.get_response();
	    }
	    catch(WrongTransaction ex)
	    {
		TEST(false);
	    }
	}
    }
}
