// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;

class TestDIIContext extends TestBase
{
    TestDIIContext(ORB orb, org.omg.CORBA.Object ti)
    {
	{
	    Context ctx;
	    ctx = orb.get_default_context();

	    Request request;

	    request = ti._request("opContext");
	    request.contexts().add("A*");
	    request.contexts().add("C*");
	    request.contexts().add("X");
	    request.contexts().add("Z");
	    request.ctx(ctx);
	    request.add_in_arg().insert_string("*");
	    request.set_return_type(StringSequenceHelper.type());
            try
            {
                request.invoke();
                Exception ex = request.env().exception();
                BAD_CONTEXT bex;
                try
                {
                    bex = (BAD_CONTEXT)ex;
                    TEST(bex != null);
                }
                catch(ClassCastException cex)
                {
                    TEST(false);
                }
            }
            catch(BAD_CONTEXT ex)
            {
                // Expected (if ooc.orb.raise_dii_exceptions = true)
            }
	}

	{
	    Context ctx;
	    ctx = orb.get_default_context();

	    Any any = orb.create_any();
	    int i;

	    any.insert_string("A1");
	    ctx.set_one_value("A", any);

	    any.insert_string("A2");
	    ctx.set_one_value("AAA", any);

	    any.insert_string("B1");
	    ctx.set_one_value("B", any);

	    any.insert_string("B2");
	    ctx.set_one_value("BBB", any);

	    any.insert_string("X1");
	    ctx.set_one_value("X", any);

	    any.insert_string("X2");
	    ctx.set_one_value("XXX", any);

	    any.insert_string("Y1");
	    ctx.set_one_value("Y", any);

	    any.insert_string("Y2");
	    ctx.set_one_value("YYY", any);

	    Request request;
	    String[] seq;

	    request = ti._request("opContext");
	    request.contexts().add("A*");
	    request.contexts().add("C*");
	    request.contexts().add("X");
	    request.contexts().add("Z");
	    request.ctx(ctx);
	    request.set_return_type(StringSequenceHelper.type());
	    request.add_in_arg().insert_string("*");
	    request.invoke();
	    seq = StringSequenceHelper.extract(request.return_value());

	    TEST(seq.length == 3 * 2);
	    i = 0;
	    TEST(seq[i++].equals("A") &&
		 seq[i++].equals("A1"));
	    TEST(seq[i++].equals("AAA") &&
		 seq[i++].equals("A2"));
	    TEST(seq[i++].equals("X") &&
		 seq[i++].equals("X1"));

	    request = ti._request("opContext");
	    request.contexts().add("A*");
	    request.contexts().add("C*");
	    request.contexts().add("X");
	    request.contexts().add("Z*");
	    request.ctx(ctx);
	    request.set_return_type(StringSequenceHelper.type());
	    request.add_in_arg().insert_string("A*");
	    request.invoke();
	    seq = StringSequenceHelper.extract(request.return_value());

	    TEST(seq.length == 2 * 2);
	    i = 0;
	    TEST(seq[i++].equals("A") &&
		 seq[i++].equals("A1"));
	    TEST(seq[i++].equals("AAA") &&
		 seq[i++].equals("A2"));

	    request = ti._request("opContext");
	    request.contexts().add("A*");
	    request.contexts().add("C*");
	    request.contexts().add("X");
	    request.contexts().add("Z");
	    request.ctx(ctx);
	    request.set_return_type(StringSequenceHelper.type());
	    request.add_in_arg().insert_string("AA*");
	    request.invoke();
	    seq = StringSequenceHelper.extract(request.return_value());

	    TEST(seq.length == 1 * 2);
	    i = 0;
	    TEST(seq[i++].equals("AAA") &&
		 seq[i++].equals("A2"));


	    request = ti._request("opContext");
	    request.contexts().add("A*");
	    request.contexts().add("C*");
	    request.contexts().add("X");
	    request.contexts().add("Z");
	    request.ctx(ctx);
	    request.set_return_type(StringSequenceHelper.type());
	    request.add_in_arg().insert_string("A");
	    request.invoke();
	    seq = StringSequenceHelper.extract(request.return_value());

	    TEST(seq.length == 1 * 2);
	    i = 0;
	    TEST(seq[i++].equals("A") &&
		 seq[i++].equals("A1"));
	}
    }
}
