// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;
import test.TestInterfaceExPackage.*;

class TestDIIException extends TestBase
{
    TestDIIException(org.omg.CORBA.Object ti)
    {
	ORB orb = ORB.init();

	Request request;

	{
	    request = ti._request("opVoidEx");
	    request.invoke();
	    Exception ex = request.env().exception();
	    UNKNOWN dummy = (UNKNOWN)ex;

	    request = ti._request("opVoidEx");
	    request.exceptions().add(ExVoidHelper.type());
	    request.invoke();
	    ex = request.env().exception();
	    UnknownUserException uex;
	    uex = (UnknownUserException)ex;
	    ExVoid iex;
	    iex = ExVoidHelper.extract(uex.except);
	}

	{
	    request = ti._request("opShortEx");
	    request.exceptions().add(ExShortHelper.type());
	    request.add_in_arg().insert_short((short)10);
	    Any inOutAny = request.add_inout_arg();
	    inOutAny.insert_short((short)20);
	    Any outAny = request.add_out_arg();
	    outAny.insert_short((short)0);
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_short));
	    request.invoke();
	    Exception ex = request.env().exception();
	    UnknownUserException uex;
	    uex = (UnknownUserException)ex;
	    ExShort iex;
	    iex = ExShortHelper.extract(uex.except);
	    TEST(iex.value == 30);
	}

	{
	    request = ti._request("opDoubleEx");
	    request.exceptions().add(ExDoubleHelper.type());
	    request.add_in_arg().insert_double(10);
	    Any inOutAny = request.add_inout_arg();
	    inOutAny.insert_double(20);
	    Any outAny = request.add_out_arg();
	    outAny.insert_double(0);
	    request.set_return_type(orb.get_primitive_tc(TCKind.tk_double));
	    request.invoke();
	    Exception ex = request.env().exception();
	    UnknownUserException uex;
	    uex = (UnknownUserException)ex;
	    ExDouble iex;
	    iex = ExDoubleHelper.extract(uex.except);
	    TEST(iex.value == 30);
	}

	{
	    String[] in = new String[3];
	    in[0] = "!!!";
	    in[1] = "@@@";
	    in[2] = "###";
	    String[] inOut = new String[2];
	    inOut[0] = "%";
	    inOut[1] = "^^";
	    request = ti._request("opStringSequenceEx");
	    request.exceptions().add(ExStringSequenceHelper.type());
	    StringSequenceHelper.insert(request.add_in_arg(), in);
	    Any inOutAny = request.add_inout_arg();
	    StringSequenceHelper.insert(inOutAny, inOut);
	    Any outAny = request.add_out_arg();
	    StringSequenceHelper.insert(outAny, new String[0]);
	    request.set_return_type(ExStringSequenceHelper.type());
	    request.invoke();
	    Exception ex = request.env().exception();
	    UnknownUserException uex;
	    uex = (UnknownUserException)ex;
	    ExStringSequence iex;
	    iex = ExStringSequenceHelper.extract(uex.except);
	    TEST(iex.value.length == 5);
	    TEST(iex.value[0].equals("!!!"));
	    TEST(iex.value[1].equals("@@@"));
	    TEST(iex.value[2].equals("###"));
	    TEST(iex.value[3].equals("%"));
	    TEST(iex.value[4].equals("^^"));
	}
    }
}
