// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;

class TestDynAny extends TestBase
{
    org.omg.CORBA.ORB orb_;
    static final int ARRAY_SIZE = 10;
    static final int BASIC_STRUCT_MEMBER_COUNT = 13;
    static final int COMPLEX_STRUCT_MEMBER_COUNT = 3;
    static final int UNION_MEMBER_COUNT = 17;

    TestDynAny()
    {
        orb_ = ORB.init();

        testNullVoid();
        testColor();
        testArrayShort();
        testSequenceShort();
        testBasicStruct();
        testComplexStruct();
        testUnion();
        testInterface();
    }

    void
    testNullVoid()
    {
        try
        {
            org.omg.CORBA.DynAny dynAny;
            org.omg.CORBA.TypeCode tc, tc2;

            tc = orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_null);
            dynAny = orb_.create_basic_dyn_any(tc);
            tc2 = dynAny.type();
            TEST(tc.equal(tc2));
            testDynAny(dynAny, 1);

            tc = orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_void);
            dynAny = orb_.create_basic_dyn_any(tc);
            tc2 = dynAny.type();
            TEST(tc.equal(tc2));
            testDynAny(dynAny, 1);
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }
    }

    void
    testColor()
    {
        try
        {
            org.omg.CORBA.TypeCode tc =
                test.TestDynAnyTypes.ColorHelper.type();

            org.omg.CORBA.DynEnum dynEnum;
            dynEnum = orb_.create_dyn_enum(tc);

            org.omg.CORBA.TypeCode tc2 = dynEnum.type();
            TEST(tc.equal(tc2));

            dynEnum.value_as_string("green");
            String stringValue = dynEnum.value_as_string();
            TEST(stringValue.equals("green"));

            dynEnum.value_as_ulong(3);
            int ulongValue = dynEnum.value_as_ulong();
            TEST(ulongValue == 3);

            testDynAny(dynEnum, 1);
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }
    }

    void
    testArrayShort()
    {
        try
        {
            org.omg.CORBA.TypeCode tc =
                test.TestDynAnyTypes.ArrayShortHelper.type();

            org.omg.CORBA.DynArray dynArray;
            dynArray = orb_.create_dyn_array(tc);

            org.omg.CORBA.TypeCode tc2 = dynArray.type();
            TEST(tc.equal(tc2));

            initArrayShort(dynArray);

            org.omg.CORBA.Any[] anySeqVoid = new org.omg.CORBA.Any[0];
            try
            {
                dynArray.set_elements(anySeqVoid);
                TEST(false); // should not succeed
            }
            catch(org.omg.CORBA.DynAnyPackage.InvalidSeq ex)
            {
                // OK
            }

            org.omg.CORBA.Any[] elements = dynArray.get_elements();
            TEST(elements.length == ARRAY_SIZE);

            dynArray.set_elements(elements);

            testDynAny(dynArray, ARRAY_SIZE);
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidSeq ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidValue ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }
    }

    void
    testSequenceShort()
    {
        try
        {
            org.omg.CORBA.TypeCode tc =
                test.TestDynAnyTypes.SequenceShortHelper.type();

            org.omg.CORBA.DynSequence dynSeq;
            dynSeq = orb_.create_dyn_sequence(tc);

            org.omg.CORBA.TypeCode tc2 = dynSeq.type();
            TEST(tc.equal(tc2));

            initSequenceShort(dynSeq);

            int length = dynSeq.length();
            TEST(length == ARRAY_SIZE);

            org.omg.CORBA.Any[] anySeqVoid = new org.omg.CORBA.Any[0];
            try
            {
                dynSeq.set_elements(anySeqVoid);
                TEST(false); // should not succeed
            }
            catch(org.omg.CORBA.DynAnyPackage.InvalidSeq ex)
            {
                // OK
            }

            org.omg.CORBA.Any[] elements = dynSeq.get_elements();
            TEST(elements.length == ARRAY_SIZE);

            dynSeq.set_elements(elements);

            testDynAny(dynSeq, ARRAY_SIZE);
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidSeq ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidValue ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }
    }

    void
    testBasicStruct()
    {
        try
        {
            org.omg.CORBA.TypeCode tc =
                test.TestDynAnyTypes.BasicStructHelper.type();

            org.omg.CORBA.DynStruct dynStruct;
            dynStruct = orb_.create_dyn_struct(tc);

            org.omg.CORBA.TypeCode tc2 = dynStruct.type();
            TEST(tc.equal(tc2));

            initBasicStruct(dynStruct);

            org.omg.CORBA.NameValuePair[] members = dynStruct.get_members();
            TEST(members.length == BASIC_STRUCT_MEMBER_COUNT);

            dynStruct.set_members(members);

            testDynAny(dynStruct, BASIC_STRUCT_MEMBER_COUNT);
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidSeq ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidValue ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }
    }

    void
    testComplexStruct()
    {
        try
        {
            org.omg.CORBA.TypeCode tc =
                test.TestDynAnyTypes.ComplexStructHelper.type();

            org.omg.CORBA.DynStruct dynStruct;
            dynStruct = orb_.create_dyn_struct(tc);

            org.omg.CORBA.TypeCode tc2 = dynStruct.type();
            TEST(tc.equal(tc2));

            initComplexStruct(dynStruct);

            org.omg.CORBA.NameValuePair[] members = dynStruct.get_members();
            TEST(members.length == COMPLEX_STRUCT_MEMBER_COUNT);

            testDynAny(dynStruct, COMPLEX_STRUCT_MEMBER_COUNT);
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidValue ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }
    }

    void
    testUnion()
    {
        try
        {
            org.omg.CORBA.TypeCode tc =
                test.TestDynAnyTypes.Union_UShortHelper.type();

            org.omg.CORBA.DynUnion dynUnion;
            dynUnion = orb_.create_dyn_union(tc);

            org.omg.CORBA.TypeCode tc2 = dynUnion.type();
            TEST(tc.equal(tc2));

            dynUnion.insert_short((short)0);
            dynUnion.insert_short((short)1);

            dynUnion.rewind();

            dynUnion.insert_short((short)1);
            dynUnion.insert_ushort((short)1);

            dynUnion.rewind();

            dynUnion.insert_short((short)2);
            dynUnion.insert_long(1);

            dynUnion.rewind();

            dynUnion.insert_short((short)3);
            dynUnion.insert_ulong(1);

            dynUnion.rewind();

            dynUnion.insert_short((short)4);
            dynUnion.insert_float((float)1);

            dynUnion.rewind();

            dynUnion.insert_short((short)5);
            dynUnion.insert_double(1);

            dynUnion.rewind();

            dynUnion.insert_short((short)6);
            dynUnion.insert_boolean(true);

            dynUnion.rewind();

            dynUnion.insert_short((short)7);
            dynUnion.insert_octet((byte)1);

            dynUnion.rewind();

            dynUnion.insert_short((short)8);
            dynUnion.insert_char('c');

            dynUnion.rewind();

            dynUnion.insert_short((short)9);
            dynUnion.insert_string("Hello");

            dynUnion.rewind();

            org.omg.CORBA.TypeCode type = orb_.get_primitive_tc(
                org.omg.CORBA.TCKind.tk_short);
            dynUnion.insert_short((short)10);
            dynUnion.insert_typecode(type);

            dynUnion.rewind();

            dynUnion.insert_short((short)11);
            org.omg.CORBA.Any anyVal = orb_.create_any();
            anyVal.insert_string("This is a string into an Any");
            dynUnion.insert_any(anyVal);

            dynUnion.rewind();

            dynUnion.insert_short((short)12);
            org.omg.CORBA.DynAny current = dynUnion.current_component();
            org.omg.CORBA.DynEnum dynEnum =
                org.omg.CORBA.DynEnumHelper.narrow(current);
            dynEnum.value_as_string("white");

            dynUnion.rewind();

            dynUnion.insert_short((short)13);
            current = dynUnion.current_component();
            org.omg.CORBA.DynArray dynArray =
                org.omg.CORBA.DynArrayHelper.narrow(current);
            initArrayShort(dynArray);

            dynUnion.rewind();

            dynUnion.insert_short((short)14);
            current = dynUnion.current_component();
            org.omg.CORBA.DynSequence dynSequence =
                org.omg.CORBA.DynSequenceHelper.narrow(current);
            initSequenceShort(dynSequence);

            dynUnion.rewind();

            dynUnion.insert_short((short)15);
            current = dynUnion.current_component();
            org.omg.CORBA.DynStruct dynStruct =
                org.omg.CORBA.DynStructHelper.narrow(current);
            initBasicStruct(dynStruct);

            dynUnion.rewind();

            dynUnion.insert_short((short)100);
            current = dynUnion.current_component();
            dynStruct = org.omg.CORBA.DynStructHelper.narrow(current);
            initComplexStruct(dynStruct);

            dynUnion.rewind();

            dynUnion.member_name("m_short");
            org.omg.CORBA.DynAny member = dynUnion.member();
            member.insert_short((short)100);

            dynUnion.member_name("m_ushort");
            member = dynUnion.member();
            member.insert_ushort((short)100);

            dynUnion.member_name("m_long");
            member = dynUnion.member();
            member.insert_long(100);

            dynUnion.member_name("m_ulong");
            member = dynUnion.member();
            member.insert_ulong(100);

            dynUnion.member_name("m_float");
            member = dynUnion.member();
            member.insert_float((float)100);

            dynUnion.member_name("m_double");
            member = dynUnion.member();
            member.insert_double(100);

            dynUnion.member_name("m_boolean");
            member = dynUnion.member();
            member.insert_boolean(false);

            dynUnion.member_name("m_octet");
            member = dynUnion.member();
            member.insert_octet((byte)100);

            dynUnion.member_name("m_char");
            member = dynUnion.member();
            member.insert_char((char)100);

            dynUnion.member_name("m_string");
            member = dynUnion.member();
            member.insert_string("Hello");

            dynUnion.member_name("m_typecode");
            member = dynUnion.member();
            type = orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_TypeCode);
            member.insert_typecode(type);

            dynUnion.member_name("m_any");
            member = dynUnion.member();
            member.insert_any(anyVal);

            dynUnion.member_name("m_color");
            member = dynUnion.member();
            dynEnum = org.omg.CORBA.DynEnumHelper.narrow(member);
            dynEnum.value_as_string("red");

            dynUnion.member_name("m_array");
            member = dynUnion.member();
            dynArray = org.omg.CORBA.DynArrayHelper.narrow(member);
            initArrayShort(dynArray);

            dynUnion.member_name("m_sequence");
            member = dynUnion.member();
            dynSequence = org.omg.CORBA.DynSequenceHelper.narrow(member);
            initSequenceShort(dynSequence);

            dynUnion.member_name("m_basic_struct");
            member = dynUnion.member();
            initBasicStruct(member);

            dynUnion.member_name("m_complex_struct");
            member = dynUnion.member();
            initComplexStruct(member);

            dynUnion.set_as_default(true);
            member = dynUnion.member();
            initComplexStruct(member);

            testDynAny(dynUnion, 2);
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidValue ex)
        {
            throw new TestException();
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }
    }

    void
    testInterface()
    {
        try
        {
            org.omg.CORBA.TypeCode tc = org.omg.CORBA.InterfaceDefPackage.
                FullInterfaceDescriptionHelper.type();

            org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription desc;
            desc = new org.omg.CORBA.InterfaceDefPackage.
                FullInterfaceDescription();
            desc.name = "OneInterface";
            desc.id = "IDL:OneModule/OneInterface:1.0";
            desc.defined_in = "IDL:OneModule:1.0";
            desc.version = "1.0";
            desc.operations = new org.omg.CORBA.OperationDescription[0];
            desc.attributes = new org.omg.CORBA.AttributeDescription[0];
            desc.base_interfaces = new String[0];
            desc.type = orb_.create_interface_tc(
                "IDL:OneModule/OneInterface:1.0","OneInterface");

            org.omg.CORBA.Any any = orb_.create_any();
            org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescriptionHelper.
                insert(any, desc);

            org.omg.CORBA.DynAny dynAny = orb_.create_dyn_any(any);

            org.omg.CORBA.TypeCode tc2 = dynAny.type();
            TEST(tc.equal(tc2));

            testDynAny(dynAny, tc.member_count());
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
        {
            throw new TestException();
        }
    }

    void
    testDynAny(org.omg.CORBA.DynAny dynAny, int numComponents)
    {
        try
        {
            org.omg.CORBA.DynAny copy = dynAny.copy();
            org.omg.CORBA.TypeCode tc = copy.type();

            org.omg.CORBA.TypeCode tc2 = dynAny.type();
            TEST(tc.equal(tc2));

            org.omg.CORBA.Any any = copy.to_any();

            copy.assign(dynAny);

            org.omg.CORBA.DynAny dynVoid = createVoidDynAny();
            try
            {
                copy.assign(dynVoid);

                // the above operation should only succeed if
                // the dynAny's type is tk_void
                TEST(tc.kind() == org.omg.CORBA.TCKind.tk_void);
            }
            catch(org.omg.CORBA.DynAnyPackage.Invalid ex)
            {
                // OK
            }

            copy.from_any(any);

            org.omg.CORBA.Any anyVoid = createVoidAny();
            try
            {
                copy.from_any(anyVoid);

                // the above operation should only succeed if
                // the dynAny's type is tk_void
                TEST(tc.kind() == org.omg.CORBA.TCKind.tk_void);
            }
            catch(org.omg.CORBA.DynAnyPackage.Invalid ex)
            {
                // OK
            }

            int count = 0;
            do
            {
                count++;
            } while(copy.next());

            TEST(count == numComponents);

            TEST(copy.seek(-1) == false);

            for(int i = 0 ; i < count ; i++)
                TEST(copy.seek(i) == true);

            TEST(copy.seek(count) == false);

            copy.destroy();
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid ex)
        {
            throw new TestException();
        }
    }

    org.omg.CORBA.DynAny
    createVoidDynAny()
    {
        org.omg.CORBA.DynAny result = null;

        try
        {
            org.omg.CORBA.TypeCode tc = orb_.get_primitive_tc(
                org.omg.CORBA.TCKind.tk_void);
            result = orb_.create_basic_dyn_any(tc);
        }
        catch(org.omg.CORBA.ORBPackage.InconsistentTypeCode ex)
        {
            throw new TestException();
        }

        return result;
    }

    org.omg.CORBA.Any
    createVoidAny()
    {
        org.omg.CORBA.Any result = orb_.create_any();
        org.omg.CORBA.TypeCode tc = orb_.get_primitive_tc(
            org.omg.CORBA.TCKind.tk_void);
        result.type(tc);
        return result;
    }

    void
    initArrayShort(org.omg.CORBA.DynArray dynArray)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        dynArray.rewind();
        for(int i = 0 ; i < ARRAY_SIZE ; i++)
            dynArray.insert_short((short)i);
    }

    void
    initSequenceShort(org.omg.CORBA.DynSequence dynSequence)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        dynSequence.length(ARRAY_SIZE);
        dynSequence.rewind();

        for(int i = 0 ; i < ARRAY_SIZE ; i++)
            dynSequence.insert_short((short)i);
    }

    void
    initBasicStruct(org.omg.CORBA.DynAny dynAny)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        dynAny.rewind();

        dynAny.insert_short((short)-100);
        dynAny.insert_ushort((short)100);
        dynAny.insert_long(-9999);
        dynAny.insert_ulong(9999);
        dynAny.insert_float((float)3.14159);
        dynAny.insert_double(1.2345e-5);
        dynAny.insert_boolean(true);
        dynAny.insert_octet((byte)127);
        dynAny.insert_char('c');
        dynAny.insert_string("This is a string");
        org.omg.CORBA.TypeCode voidType = orb_.get_primitive_tc(
            org.omg.CORBA.TCKind.tk_void);
        dynAny.insert_typecode(voidType);
        org.omg.CORBA.Any anyVal = orb_.create_any();
        anyVal.insert_string("This is a string into an Any");
        dynAny.insert_any(anyVal);

        org.omg.CORBA.DynAny current = dynAny.current_component();
        org.omg.CORBA.DynEnum dynEnum =
            org.omg.CORBA.DynEnumHelper.narrow(current);
        dynEnum.value_as_string("blue");
    }

    void
    initComplexStruct(org.omg.CORBA.DynAny dynAny)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.DynAny current;

        dynAny.rewind();

        current = dynAny.current_component();
        initBasicStruct(current);
        dynAny.next();

        current = dynAny.current_component();
        org.omg.CORBA.DynArray dynArray =
            org.omg.CORBA.DynArrayHelper.narrow(current);
        initArrayShort(dynArray);
        dynAny.next();

        current = dynAny.current_component();
        org.omg.CORBA.DynSequence dynSequence =
            org.omg.CORBA.DynSequenceHelper.narrow(current);
        initSequenceShort(dynSequence);
        dynAny.next();
    }
}
