// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;
import test.TestInterfaceExPackage.*;

class TestInterfaceExDSI_impl extends DynamicImplementation
{
    private ORB orb_;
    private test.TestInterfaceTimeout ti_;

    private Any aTestInterface;
    private Any aVariableUnion;

    TestInterfaceExDSI_impl(ORB orb, test.TestInterfaceTimeout ti)
    {
	orb_ = orb;
	ti_ = ti;
    }

    static final String[] ids_ =
    {
        "IDL:TestInterfaceEx:1.0",
        "IDL:TestInterface:1.0"
    };

    public String[]
    _ids()
    {
        return ids_;
    }

    public void
    invoke(ServerRequest request)
    {
	String name = request.op_name();

	boolean ex;
	if(name.length() > 2 && name.endsWith("Ex"))
	{
	    name = name.substring(0, name.length() - 2);
	    ex = true;
	}
	else
	    ex = false;
	
	if(name.equals("opVoid"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExVoidHelper.insert(any, new ExVoid());
		request.except(any);
	    }
	    
	    return;
	}

	if(name.equals("_get_attrShort"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    short ret = ti_.attrShort();

	    Any any = orb_.create_any();
	    any.insert_short(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrShort"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_short));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    short arg = any.extract_short();

	    ti_.attrShort(arg);
	    
	    return;
	}

	if(name.equals("opShort"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_short));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_short));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    short arg0 = any0.extract_short();
	    ShortHolder arg1 = new ShortHolder();
	    arg1.value = any1.extract_short();
	    ShortHolder arg2 = new ShortHolder();

	    short ret = ti_.opShort(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExShortHelper.insert(any, new ExShort(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_short(ret);
		request.result(any);
		any1.insert_short(arg1.value);
		any2.insert_short(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrLong"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    int ret = ti_.attrLong();

	    Any any = orb_.create_any();
	    any.insert_long(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrLong"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_long));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    int arg = any.extract_long();

	    ti_.attrLong(arg);
	    
	    return;
	}

	if(name.equals("opLong"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_long));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_long));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    int arg0 = any0.extract_long();
	    IntHolder arg1 = new IntHolder();
	    arg1.value = any1.extract_long();
	    IntHolder arg2 = new IntHolder();

	    int ret = ti_.opLong(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExLongHelper.insert(any, new ExLong(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_long(ret);
		request.result(any);
		any1.insert_long(arg1.value);
		any2.insert_long(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrUShort"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    short ret = ti_.attrUShort();

	    Any any = orb_.create_any();
	    any.insert_ushort(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrUShort"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_ushort));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    short arg = any.extract_ushort();

	    ti_.attrUShort(arg);
	    
	    return;
	}

	if(name.equals("opUShort"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_ushort));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_ushort));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    short arg0 = any0.extract_ushort();
	    ShortHolder arg1 = new ShortHolder();
	    arg1.value = any1.extract_ushort();
	    ShortHolder arg2 = new ShortHolder();

	    short ret = ti_.opUShort(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExUShortHelper.insert(any, new ExUShort(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_ushort(ret);
		request.result(any);
		any1.insert_ushort(arg1.value);
		any2.insert_ushort(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrULong"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    int ret = ti_.attrULong();

	    Any any = orb_.create_any();
	    any.insert_ulong(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrULong"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_ulong));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    int arg = any.extract_ulong();

	    ti_.attrULong(arg);
	    
	    return;
	}

	if(name.equals("opULong"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_ulong));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_ulong));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    int arg0 = any0.extract_ulong();
	    IntHolder arg1 = new IntHolder();
	    arg1.value = any1.extract_ulong();
	    IntHolder arg2 = new IntHolder();

	    int ret = ti_.opULong(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExULongHelper.insert(any, new ExULong(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_ulong(ret);
		request.result(any);
		any1.insert_ulong(arg1.value);
		any2.insert_ulong(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrFloat"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    float ret = ti_.attrFloat();

	    Any any = orb_.create_any();
	    any.insert_float(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrFloat"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_float));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    float arg = any.extract_float();

	    ti_.attrFloat(arg);
	    
	    return;
	}

	if(name.equals("opFloat"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_float));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_float));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    float arg0 = any0.extract_float();
	    FloatHolder arg1 = new FloatHolder();
	    arg1.value = any1.extract_float();
	    FloatHolder arg2 = new FloatHolder();

	    float ret = ti_.opFloat(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExFloatHelper.insert(any, new ExFloat(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_float(ret);
		request.result(any);
		any1.insert_float(arg1.value);
		any2.insert_float(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrDouble"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    double ret = ti_.attrDouble();

	    Any any = orb_.create_any();
	    any.insert_double(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrDouble"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_double));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    double arg = any.extract_double();

	    ti_.attrDouble(arg);
	    
	    return;
	}

	if(name.equals("opDouble"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_double));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_double));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    double arg0 = any0.extract_double();
	    DoubleHolder arg1 = new DoubleHolder();
	    arg1.value = any1.extract_double();
	    DoubleHolder arg2 = new DoubleHolder();

	    double ret = ti_.opDouble(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExDoubleHelper.insert(any, new ExDouble(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_double(ret);
		request.result(any);
		any1.insert_double(arg1.value);
		any2.insert_double(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrBoolean"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    boolean ret = ti_.attrBoolean();

	    Any any = orb_.create_any();
	    any.insert_boolean(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrBoolean"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_boolean));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    boolean arg = any.extract_boolean();

	    ti_.attrBoolean(arg);
	    
	    return;
	}

	if(name.equals("opBoolean"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_boolean));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_boolean));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    boolean arg0 = any0.extract_boolean();
	    BooleanHolder arg1 = new BooleanHolder();
	    arg1.value = any1.extract_boolean();
	    BooleanHolder arg2 = new BooleanHolder();

	    boolean ret = ti_.opBoolean(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExBooleanHelper.insert(any, new ExBoolean(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_boolean(ret);
		request.result(any);
		any1.insert_boolean(arg1.value);
		any2.insert_boolean(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrChar"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    char ret = ti_.attrChar();

	    Any any = orb_.create_any();
	    any.insert_char(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrChar"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_char));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    char arg = any.extract_char();

	    ti_.attrChar(arg);
	    
	    return;
	}

	if(name.equals("opChar"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_char));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_char));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    char arg0 = any0.extract_char();
	    CharHolder arg1 = new CharHolder();
	    arg1.value = any1.extract_char();
	    CharHolder arg2 = new CharHolder();

	    char ret = ti_.opChar(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExCharHelper.insert(any, new ExChar(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_char(ret);
		request.result(any);
		any1.insert_char(arg1.value);
		any2.insert_char(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrOctet"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    byte ret = ti_.attrOctet();

	    Any any = orb_.create_any();
	    any.insert_octet(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrOctet"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_octet));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    byte arg = any.extract_octet();

	    ti_.attrOctet(arg);
	    
	    return;
	}

	if(name.equals("opOctet"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_octet));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_octet));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    byte arg0 = any0.extract_octet();
	    ByteHolder arg1 = new ByteHolder();
	    arg1.value = any1.extract_octet();
	    ByteHolder arg2 = new ByteHolder();

	    byte ret = ti_.opOctet(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExOctetHelper.insert(any, new ExOctet(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_octet(ret);
		request.result(any);
		any1.insert_octet(arg1.value);
		any2.insert_octet(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrString"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    String ret = ti_.attrString();

	    Any any = orb_.create_any();
	    any.insert_string(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrString"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_string));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    String arg = any.extract_string();

	    ti_.attrString(arg);
	    
	    return;
	}

	if(name.equals("opString"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_string));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_string));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    String arg0 = any0.extract_string();
	    StringHolder arg1 = new StringHolder();
	    arg1.value = any1.extract_string();
	    StringHolder arg2 = new StringHolder();

	    String ret = ti_.opString(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExStringHelper.insert(any, new ExString(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_string(ret);
		request.result(any);
		any1.insert_string(arg1.value);
		any2.insert_string(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrAny"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    Any ret = ti_.attrAny();

	    Any any = orb_.create_any();
	    any.insert_any(ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrAny"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.get_primitive_tc(TCKind.tk_any));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    Any arg = any.extract_any();

	    ti_.attrAny(arg);
	    
	    return;
	}

	if(name.equals("opAny"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(orb_.get_primitive_tc(TCKind.tk_any));
	    any1.type(orb_.get_primitive_tc(TCKind.tk_any));
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    Any arg0 = any0.extract_any();
	    AnyHolder arg1 = new AnyHolder();
	    arg1.value = any1.extract_any();
	    AnyHolder arg2 = new AnyHolder();

	    Any ret = ti_.opAny(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExAnyHelper.insert(any, new ExAny(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		any.insert_any(ret);
		request.result(any);
		any1.insert_any(arg1.value);
		any2.insert_any(arg2.value);
	    }
	
	    return;
	}

	if(name.equals("_get_attrTestEnum"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    test.TestInterfacePackage.TestEnum ret = ti_.attrTestEnum();

	    Any any = orb_.create_any();
	    test.TestInterfacePackage.TestEnumHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrTestEnum"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(test.TestInterfacePackage.TestEnumHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    test.TestInterfacePackage.TestEnum arg =
		test.TestInterfacePackage.TestEnumHelper.extract(any);

	    ti_.attrTestEnum(arg);
	    
	    return;
	}

	if(name.equals("opTestEnum"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(test.TestInterfacePackage.TestEnumHelper.type());
	    any1.type(test.TestInterfacePackage.TestEnumHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    test.TestInterfacePackage.TestEnum arg0 =
		test.TestInterfacePackage.TestEnumHelper.extract(any0);
	    test.TestInterfacePackage.TestEnumHolder arg1 =
		new test.TestInterfacePackage.TestEnumHolder();
	    arg1._read(any1.create_input_stream());
	    test.TestInterfacePackage.TestEnumHolder arg2 =
		new test.TestInterfacePackage.TestEnumHolder();

	    test.TestInterfacePackage.TestEnum ret =
		ti_.opTestEnum(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExTestEnumHelper.insert(any, new ExTestEnum(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		test.TestInterfacePackage.TestEnumHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrTestInterface"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    TestInterface ret = ti_.attrTestInterface();

	    Any any = orb_.create_any();
	    TestInterfaceHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrTestInterface"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(TestInterfaceHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    TestInterface arg =
		TestInterfaceHelper.extract(any);

	    ti_.attrTestInterface(arg);
	    
	    return;
	}

	if(name.equals("opTestInterface"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(TestInterfaceHelper.type());
	    any1.type(TestInterfaceHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    TestInterface arg0 =
		TestInterfaceHelper.extract(any0);
	    TestInterfaceHolder arg1 =
		new TestInterfaceHolder();
	    arg1._read(any1.create_input_stream());
	    TestInterfaceHolder arg2 =
		new TestInterfaceHolder();

	    TestInterface ret =
		ti_.opTestInterface(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExTestInterfaceHelper.insert(any, new ExTestInterface(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		TestInterfaceHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrFixedStruct"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    FixedStruct ret = ti_.attrFixedStruct();

	    Any any = orb_.create_any();
	    FixedStructHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrFixedStruct"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(FixedStructHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    FixedStruct arg =
		FixedStructHelper.extract(any);

	    ti_.attrFixedStruct(arg);
	    
	    return;
	}

	if(name.equals("opFixedStruct"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(FixedStructHelper.type());
	    any1.type(FixedStructHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    FixedStruct arg0 =
		FixedStructHelper.extract(any0);
	    FixedStructHolder arg1 =
		new FixedStructHolder();
	    arg1._read(any1.create_input_stream());
	    FixedStructHolder arg2 =
		new FixedStructHolder();

	    FixedStruct ret =
		ti_.opFixedStruct(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExFixedStructHelper.insert(any, new ExFixedStruct(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		FixedStructHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrVariableStruct"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    VariableStruct ret = ti_.attrVariableStruct();

	    Any any = orb_.create_any();
	    VariableStructHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrVariableStruct"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(VariableStructHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    VariableStruct arg =
		VariableStructHelper.extract(any);

	    ti_.attrVariableStruct(arg);
	    
	    return;
	}

	if(name.equals("opVariableStruct"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(VariableStructHelper.type());
	    any1.type(VariableStructHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    VariableStruct arg0 =
		VariableStructHelper.extract(any0);
	    VariableStructHolder arg1 =
		new VariableStructHolder();
	    arg1._read(any1.create_input_stream());
	    VariableStructHolder arg2 =
		new VariableStructHolder();

	    VariableStruct ret =
		ti_.opVariableStruct(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExVariableStructHelper.insert(any, new ExVariableStruct(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		VariableStructHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrFixedUnion"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    FixedUnion ret = ti_.attrFixedUnion();

	    Any any = orb_.create_any();
	    FixedUnionHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrFixedUnion"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(FixedUnionHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    FixedUnion arg =
		FixedUnionHelper.extract(any);

	    ti_.attrFixedUnion(arg);
	    
	    return;
	}

	if(name.equals("opFixedUnion"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(FixedUnionHelper.type());
	    any1.type(FixedUnionHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    FixedUnion arg0 =
		FixedUnionHelper.extract(any0);
	    FixedUnionHolder arg1 =
		new FixedUnionHolder();
	    arg1._read(any1.create_input_stream());
	    FixedUnionHolder arg2 =
		new FixedUnionHolder();

	    FixedUnion ret =
		ti_.opFixedUnion(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExFixedUnionHelper.insert(any, new ExFixedUnion(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		FixedUnionHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrVariableUnion"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    VariableUnion ret = ti_.attrVariableUnion();

	    Any any = orb_.create_any();
	    VariableUnionHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrVariableUnion"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(VariableUnionHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    VariableUnion arg =
		VariableUnionHelper.extract(any);

	    ti_.attrVariableUnion(arg);
	    
	    return;
	}

	if(name.equals("opVariableUnion"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(VariableUnionHelper.type());
	    any1.type(VariableUnionHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    VariableUnion arg0 =
		VariableUnionHelper.extract(any0);
	    VariableUnionHolder arg1 =
		new VariableUnionHolder();
	    arg1._read(any1.create_input_stream());
	    VariableUnionHolder arg2 =
		new VariableUnionHolder();

	    VariableUnion ret =
		ti_.opVariableUnion(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExVariableUnionHelper.insert(any, new ExVariableUnion(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		VariableUnionHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrStringSequence"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    String[] ret = ti_.attrStringSequence();

	    Any any = orb_.create_any();
	    StringSequenceHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrStringSequence"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(StringSequenceHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    String[] arg =
		StringSequenceHelper.extract(any);

	    ti_.attrStringSequence(arg);
	    
	    return;
	}

	if(name.equals("opStringSequence"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(StringSequenceHelper.type());
	    any1.type(StringSequenceHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    String[] arg0 =
		StringSequenceHelper.extract(any0);
	    StringSequenceHolder arg1 =
		new StringSequenceHolder();
	    arg1._read(any1.create_input_stream());
	    StringSequenceHolder arg2 =
		new StringSequenceHolder();

	    String[] ret =
		ti_.opStringSequence(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExStringSequenceHelper.insert(any, new ExStringSequence(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		StringSequenceHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrFixedArray"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    short[][][] ret = ti_.attrFixedArray();

	    Any any = orb_.create_any();
	    FixedArrayHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrFixedArray"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(FixedArrayHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    short[][][] arg =
		FixedArrayHelper.extract(any);

	    ti_.attrFixedArray(arg);
	    
	    return;
	}

	if(name.equals("opFixedArray"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(FixedArrayHelper.type());
	    any1.type(FixedArrayHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    short[][][] arg0 =
		FixedArrayHelper.extract(any0);
	    FixedArrayHolder arg1 =
		new FixedArrayHolder();
	    arg1._read(any1.create_input_stream());
	    FixedArrayHolder arg2 =
		new FixedArrayHolder();

	    short[][][] ret =
		ti_.opFixedArray(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExFixedArrayHelper.insert(any, new ExFixedArray(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		FixedArrayHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrVariableArray"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    String[][] ret = ti_.attrVariableArray();

	    Any any = orb_.create_any();
	    VariableArrayHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrVariableArray"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(VariableArrayHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    String[][] arg =
		VariableArrayHelper.extract(any);

	    ti_.attrVariableArray(arg);
	    
	    return;
	}

	if(name.equals("opVariableArray"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(VariableArrayHelper.type());
	    any1.type(VariableArrayHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    String[][] arg0 =
		VariableArrayHelper.extract(any0);
	    VariableArrayHolder arg1 =
		new VariableArrayHolder();
	    arg1._read(any1.create_input_stream());
	    VariableArrayHolder arg2 =
		new VariableArrayHolder();

	    String[][] ret =
		ti_.opVariableArray(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExVariableArrayHelper.insert(any, new ExVariableArray(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		VariableArrayHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrFixedArraySequence"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    short[][][][] ret = ti_.attrFixedArraySequence();

	    Any any = orb_.create_any();
	    FixedArraySequenceHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrFixedArraySequence"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(FixedArraySequenceHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    short[][][][] arg =
		FixedArraySequenceHelper.extract(any);

	    ti_.attrFixedArraySequence(arg);
	    
	    return;
	}

	if(name.equals("opFixedArraySequence"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(FixedArraySequenceHelper.type());
	    any1.type(FixedArraySequenceHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    short[][][][] arg0 =
		FixedArraySequenceHelper.extract(any0);
	    FixedArraySequenceHolder arg1 =
		new FixedArraySequenceHolder();
	    arg1._read(any1.create_input_stream());
	    FixedArraySequenceHolder arg2 =
		new FixedArraySequenceHolder();

	    short[][][][] ret =
		ti_.opFixedArraySequence(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExFixedArraySequenceHelper.insert(
		    any, new ExFixedArraySequence(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		FixedArraySequenceHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("_get_attrVariableArraySequence"))
	{
	    NVList list = orb_.create_list(0);
	    request.params(list);

	    String[][][] ret = ti_.attrVariableArraySequence();

	    Any any = orb_.create_any();
	    VariableArraySequenceHelper.insert(any, ret);
	    request.result(any);
	    
	    return;
	}

	if(name.equals("_set_attrVariableArraySequence"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(VariableArraySequenceHelper.type());
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    String[][][] arg =
		VariableArraySequenceHelper.extract(any);

	    ti_.attrVariableArraySequence(arg);
	    
	    return;
	}

	if(name.equals("opVariableArraySequence"))
	{
	    NVList list = orb_.create_list(0);
	    Any any0 = orb_.create_any();
	    Any any1 = orb_.create_any();
	    Any any2 = orb_.create_any();
	    any0.type(VariableArraySequenceHelper.type());
	    any1.type(VariableArraySequenceHelper.type());
	    list.add_value("", any0, org.omg.CORBA.ARG_IN.value);
	    list.add_value("", any1, org.omg.CORBA.ARG_INOUT.value);
	    list.add_value("", any2, org.omg.CORBA.ARG_OUT.value);
	    request.params(list);
	    String[][][] arg0 =
		VariableArraySequenceHelper.extract(any0);
	    VariableArraySequenceHolder arg1 =
		new VariableArraySequenceHolder();
	    arg1._read(any1.create_input_stream());
	    VariableArraySequenceHolder arg2 =
		new VariableArraySequenceHolder();

	    String[][][] ret =
		ti_.opVariableArraySequence(arg0, arg1, arg2);

	    if(ex)
	    {
		Any any = orb_.create_any();
		ExVariableArraySequenceHelper.insert(
		    any, new ExVariableArraySequence(ret));
		request.except(any);
	    }
	    else
	    {
		Any any = orb_.create_any();
		VariableArraySequenceHelper.insert(any, ret);
		request.result(any);
		any1.insert_Streamable(arg1);
		any2.insert_Streamable(arg2);
	    }
	
	    return;
	}

	if(name.equals("opContext"))
	{
	    NVList list = orb_.create_list(0);
	    Any any = orb_.create_any();
	    any.type(orb_.create_string_tc(0));
	    list.add_value("", any, org.omg.CORBA.ARG_IN.value);
	    request.params(list);
	    org.omg.CORBA.Context context = request.ctx();
	    String arg = any.extract_string();

	    String[] ret = ti_.opContext(arg, context);

	    if(ex)
	    {
		Any anyEx = orb_.create_any();
		ExStringSequenceHelper.insert(anyEx,
					      new ExStringSequence(ret));
		request.except(anyEx);
	    }
	    else
	    {
		Any anyRet = orb_.create_any();
		StringSequenceHelper.insert(anyRet, ret);
		request.result(anyRet);
	    }
	
	    return;
	}

	if(name.equals("op_UNKNOWN_"))
	{
	    throw new UNKNOWN(1, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_BAD_PARAM_"))
	{
	    throw new BAD_PARAM(2, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_NO_MEMORY_"))
	{
	    throw new NO_MEMORY(3, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_IMP_LIMIT_"))
	{
	    throw new IMP_LIMIT(4, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_COMM_FAILURE_"))
	{
	    throw new COMM_FAILURE(5, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_INV_OBJREF_"))
	{
	    throw new INV_OBJREF(6, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_NO_PERMISSION_"))
	{
	    throw new NO_PERMISSION(7, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_INTERNAL_"))
	{
	    throw new INTERNAL(8, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_MARSHAL_"))
	{
	    throw new MARSHAL(9, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_INITIALIZE_"))
	{
	    throw new INITIALIZE(10, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_NO_IMPLEMENT_"))
	{
	    throw new NO_IMPLEMENT(11, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_BAD_TYPECODE_"))
	{
	    throw new BAD_TYPECODE(12, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_BAD_OPERATION_"))
	{
	    throw new BAD_OPERATION(13, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_NO_RESOURCES_"))
	{
	    throw new NO_RESOURCES(14, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_NO_RESPONSE_"))
	{
	    throw new NO_RESPONSE(15, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_PERSIST_STORE_"))
	{
	    throw new PERSIST_STORE(16, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_BAD_INV_ORDER_"))
	{
	    throw new BAD_INV_ORDER(17, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_TRANSIENT_"))
	{
	    throw new TRANSIENT(18, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_FREE_MEM_"))
	{
	    throw new FREE_MEM(19, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_INV_IDENT_"))
	{
	    throw new INV_IDENT(20, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_INV_FLAG_"))
	{
	    throw new INV_FLAG(21, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_INTF_REPOS_"))
	{
	    throw new INTF_REPOS(22, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_BAD_CONTEXT_"))
	{
	    throw new BAD_CONTEXT(23, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_OBJ_ADAPTER_"))
	{
	    throw new OBJ_ADAPTER(24, CompletionStatus.COMPLETED_MAYBE);
	}

	if(name.equals("op_DATA_CONVERSION_"))
	{
	    throw new DATA_CONVERSION(25, CompletionStatus.COMPLETED_YES);
	}

	if(name.equals("op_OBJECT_NOT_EXIST_"))
	{
	    throw new OBJECT_NOT_EXIST(26, CompletionStatus.COMPLETED_NO);
	}

	if(name.equals("op_TRANSACTION_REQUIRED_"))
	{
	    throw new TRANSACTION_REQUIRED(27, CompletionStatus.COMPLETED_NO);
	}
        
	if(name.equals("op_TRANSACTION_ROLLEDBACK_"))
	{
	    throw new TRANSACTION_ROLLEDBACK(28,
					     CompletionStatus.COMPLETED_NO);
	}
        
	if(name.equals("op_INVALID_TRANSACTION_"))
	{
	    throw new INVALID_TRANSACTION(29, CompletionStatus.COMPLETED_NO);
	}
        
	if(name.equals("op_INV_POLICY_"))
	{
	    throw new INV_POLICY(30, CompletionStatus.COMPLETED_NO);
	}

	System.err.println("DSI implementation: unknown operation: " + name);

	throw new BAD_OPERATION();
    }
}


