// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;
import test.TestInterfaceExPackage.*;

final class TestInterfaceTimeout_impl extends _TestInterfaceTimeoutImplBase
				      implements TestInterfaceTimeoutOperations
{
    private BOA boa_;

    private short aShort;
    private short aUShort;
    private int aLong;
    private int aULong;
    private float aFloat;
    private double aDouble;
    private boolean aBoolean;
    private char aChar;
    private byte aOctet;
    private String aString;
    private Any aAny;
    private test.TestInterfacePackage.TestEnum aTestEnum;
    private TestInterface aTestInterface;
    private FixedStruct aFixedStruct;
    private VariableStruct aVariableStruct;
    private FixedUnion aFixedUnion;
    private VariableUnion aVariableUnion;
    private String[] aStringSequence;
    private short[][][] aFixedArray;
    private String[][] aVariableArray;
    private short[][][][] aFixedArraySequence;
    private String[][][] aVariableArraySequence;

    public
    TestInterfaceTimeout_impl(BOA boa)
    {
	boa_ = boa;
    }

    public void
    opVoid()
    {
    }

    public void
    opVoidEx()
        throws ExVoid
    {
	throw new ExVoid();
    }

    public String[]
    opContext(String pattern, Context ctx)
    {
	NVList values = ctx.get_values("", 0, pattern);
	
	int len = values.count();
	String[] result = new String[len * 2];
	for(int i = 0 ; i < len ; i++)
	{
	    try
	    {
		String s = values.item(i).value().extract_string();
		result[i * 2] = values.item(i).name();
		result[i * 2 + 1] = s;
	    }
	    catch(org.omg.CORBA.Bounds ex)
	    {
	    }
	}
	
	return result;
    }

    public short
    attrShort()
    {
	return aShort;
    }

    public void
    attrShort(short value)
    {
	aShort = value;
    }

    public short
    opShort(short a0,
            ShortHolder a1,
            ShortHolder a2)
    {
	aShort = (short)(a0 + a1.value);
	a1.value = a2.value = aShort;
	return aShort;
    }

    public short
    opShortEx(short a0,
	      ShortHolder a1,
	      ShortHolder a2)
        throws ExShort
    {
	aShort = (short)(a0 + a1.value);
	throw new ExShort(aShort);
    }

    public int
    attrLong()
    {
	return aLong;
    }

    public void
    attrLong(int value)
    {
	aLong = value;
    }

    public int
    opLong(int a0,
	   IntHolder a1,
	   IntHolder a2)
    {
	aLong = a0 + a1.value;
	a1.value = a2.value = aLong;
	return aLong;
    }

    public int
    opLongEx(int a0,
	     IntHolder a1,
	     IntHolder a2)
        throws ExLong
    {
	aLong = a0 + a1.value;
	throw new ExLong(aLong);
    }

    public short
    attrUShort()
    {
	return aUShort;
    }

    public void
    attrUShort(short value)
    {
	aUShort = value;
    }

    public short
    opUShort(short a0,
	     ShortHolder a1,
	     ShortHolder a2)
    {
	aUShort = (short)(a0 + a1.value);
	a1.value = a2.value = aUShort;
	return aUShort;
    }

    public short
    opUShortEx(short a0,
	       ShortHolder a1,
	       ShortHolder a2)
        throws ExUShort
    {
	aUShort = (short)(a0 + a1.value);
	throw new ExUShort(aUShort);
    }

    public int
    attrULong()
    {
	return aULong;
    }

    public void
    attrULong(int value)
    {
	aULong = value;
    }

    public int
    opULong(int a0,
	    IntHolder a1,
	    IntHolder a2)
    {
	aULong = a0 + a1.value;
	a1.value = a2.value = aULong;
	return aULong;
    }

    public int
    opULongEx(int a0,
	      IntHolder a1,
	      IntHolder a2)
        throws ExULong
    {
	aULong = a0 + a1.value;
	throw new ExULong(aULong);
    }

    public float
    attrFloat()
    {
	return aFloat;
    }

    public void
    attrFloat(float value)
    {
	aFloat = value;
    }

    public float
    opFloat(float a0,
            FloatHolder a1,
            FloatHolder a2)
    {
	aFloat = a0 + a1.value;
	a1.value = a2.value = aFloat;
	return aFloat;
    }

    public float
    opFloatEx(float a0,
	      FloatHolder a1,
	      FloatHolder a2)
        throws ExFloat
    {
	aFloat = a0 + a1.value;
	throw new ExFloat(aFloat);
    }

    public double
    attrDouble()
    {
	return aDouble;
    }

    public void
    attrDouble(double value)
    {
	aDouble = value;
    }

    public double
    opDouble(double a0,
	     DoubleHolder a1,
	     DoubleHolder a2)
    {
	aDouble = a0 + a1.value;
	a1.value = a2.value = aDouble;
	return aDouble;
    }

    public double
    opDoubleEx(double a0,
	       DoubleHolder a1,
	       DoubleHolder a2)
        throws ExDouble
    {
	aDouble = a0 + a1.value;
	throw new ExDouble(aDouble);
    }

    public boolean
    attrBoolean()
    {
	return aBoolean;
    }

    public void
    attrBoolean(boolean value)
    {
	aBoolean = value;
    }

    public boolean
    opBoolean(boolean a0,
              BooleanHolder a1,
              BooleanHolder a2)
    {
	aBoolean = a0 && a1.value;
	a1.value = a2.value = aBoolean;
	return aBoolean;
    }

    public boolean
    opBooleanEx(boolean a0,
		BooleanHolder a1,
		BooleanHolder a2)
	throws ExBoolean
    {
	aBoolean = a0 && a1.value;
	throw new ExBoolean(aBoolean);
    }

    public char
    attrChar()
    {
	return aChar;
    }

    public void
    attrChar(char value)
    {
	aChar = value;
    }

    public char
    opChar(char a0,
	   CharHolder a1,
	   CharHolder a2)
    {
	aChar = (char)(a0 + a1.value);
	a1.value = a2.value = aChar;
	return aChar;
    }

    public char
    opCharEx(char a0,
	     CharHolder a1,
	     CharHolder a2)
	throws ExChar
    {
	aChar = (char)(a0 + a1.value);
	throw new ExChar(aChar);
    }

    public byte
    attrOctet()
    {
	return aOctet;
    }

    public void
    attrOctet(byte value)
    {
	aOctet = value;
    }

    public byte
    opOctet(byte a0,
	    ByteHolder a1,
	    ByteHolder a2)
    {
	aOctet = (byte)(a0 + a1.value);
	a1.value = a2.value = aOctet;
	return aOctet;
    }

    public byte
    opOctetEx(byte a0,
	      ByteHolder a1,
	      ByteHolder a2)
	throws ExOctet
    {
	aOctet = (byte)(a0 + a1.value);
	throw new ExOctet(aOctet);
    }

    public String
    attrString()
    {
	return aString;
    }

    public void
    attrString(String value)
    {
	aString = value;
    }

    public String
    opString(String a0,
	     StringHolder a1,
	     StringHolder a2)
    {
	aString = a0 + a1.value;
	a1.value = a2.value = aString;
	return aString;
    }

    public String
    opStringEx(String a0,
	       StringHolder a1,
	       StringHolder a2)
	throws ExString
    {
	aString = a0 + a1.value;
	throw new ExString(aString);
    }

    public Any
    attrAny()
    {
	return aAny;
    }

    public void
    attrAny(Any value)
    {
	aAny = value;
    }

    public Any
    opAny(Any a0,
	  AnyHolder a1,
	  AnyHolder a2)
    {
	aAny = a0;
	a1.value = a2.value = aAny;
	return aAny;
    }

    public Any
    opAnyEx(Any a0,
	    AnyHolder a1,
	    AnyHolder a2)
	throws ExAny
    {
	aAny = a0;
	throw new ExAny(aAny);
    }

    public test.TestInterfacePackage.TestEnum
    attrTestEnum()
    {
	return aTestEnum;
    }

    public void
    attrTestEnum(test.TestInterfacePackage.TestEnum value)
    {
	aTestEnum = value;
    }

    public test.TestInterfacePackage.TestEnum
    opTestEnum(test.TestInterfacePackage.TestEnum a0,
	       test.TestInterfacePackage.TestEnumHolder a1,
	       test.TestInterfacePackage.TestEnumHolder a2)
    {
	aTestEnum = a0;
	a1.value = a2.value = aTestEnum;
	return aTestEnum;
    }

    public test.TestInterfacePackage.TestEnum
    opTestEnumEx(test.TestInterfacePackage.TestEnum a0,
		 test.TestInterfacePackage.TestEnumHolder a1,
		 test.TestInterfacePackage.TestEnumHolder a2)
	throws ExTestEnum
    {
	aTestEnum = a0;
	throw new ExTestEnum(aTestEnum);
    }

    public TestInterface
    attrTestInterface()
    {
	return aTestInterface;
    }

    public void
    attrTestInterface(TestInterface value)
    {
	aTestInterface = value;
    }

    public TestInterface
    opTestInterface(TestInterface a0,
		    TestInterfaceHolder a1,
		    TestInterfaceHolder a2)
    {
	aTestInterface = a0;
	a1.value = a2.value = aTestInterface;
	return aTestInterface;
    }

    public TestInterface
    opTestInterfaceEx(TestInterface a0,
		      TestInterfaceHolder a1,
		      TestInterfaceHolder a2)
	throws ExTestInterface
    {
	aTestInterface = a0;
	throw new ExTestInterface(aTestInterface);
    }

    public FixedStruct
    attrFixedStruct()
    {
	return aFixedStruct;
    }

    public void
    attrFixedStruct(FixedStruct value)
    {
	aFixedStruct = value;
    }

    public FixedStruct
    opFixedStruct(FixedStruct a0,
		  FixedStructHolder a1,
		  FixedStructHolder a2)
    {
	aFixedStruct = a0;
	a1.value = a2.value = aFixedStruct;
	return aFixedStruct;
    }

    public FixedStruct
    opFixedStructEx(FixedStruct a0,
		    FixedStructHolder a1,
		    FixedStructHolder a2)
	throws ExFixedStruct
    {
	aFixedStruct = a0;
	throw new ExFixedStruct(aFixedStruct);
    }

    public VariableStruct
    attrVariableStruct()
    {
	return aVariableStruct;
    }

    public void
    attrVariableStruct(VariableStruct value)
    {
	aVariableStruct = value;
    }

    public VariableStruct
    opVariableStruct(VariableStruct a0,
		     VariableStructHolder a1,
		     VariableStructHolder a2)
    {
	aVariableStruct = a0;
	a1.value = a2.value = aVariableStruct;
	return aVariableStruct;
    }

    public VariableStruct
    opVariableStructEx(VariableStruct a0,
		       VariableStructHolder a1,
		       VariableStructHolder a2)
	throws ExVariableStruct
    {
	aVariableStruct = a0;
	throw new ExVariableStruct(aVariableStruct);
    }

    public FixedUnion
    attrFixedUnion()
    {
	return aFixedUnion;
    }

    public void
    attrFixedUnion(FixedUnion value)
    {
	aFixedUnion = value;
    }

    public FixedUnion
    opFixedUnion(FixedUnion a0,
		 FixedUnionHolder a1,
		 FixedUnionHolder a2)
    {
	aFixedUnion = a0;
	a1.value = a2.value = aFixedUnion;
	return aFixedUnion;
    }

    public FixedUnion
    opFixedUnionEx(FixedUnion a0,
		   FixedUnionHolder a1,
		   FixedUnionHolder a2)
	throws ExFixedUnion
    {
	aFixedUnion = a0;
	throw new ExFixedUnion(aFixedUnion);
    }

    public VariableUnion
    attrVariableUnion()
    {
	return aVariableUnion;
    }

    public void
    attrVariableUnion(VariableUnion value)
    {
	aVariableUnion = value;
    }

    public VariableUnion
    opVariableUnion(VariableUnion a0,
		    VariableUnionHolder a1,
		    VariableUnionHolder a2)
    {
	aVariableUnion = a0;
	a1.value = a2.value = aVariableUnion;
	return aVariableUnion;
    }

    public VariableUnion
    opVariableUnionEx(VariableUnion a0,
		      VariableUnionHolder a1,
		      VariableUnionHolder a2)
	throws ExVariableUnion
    {
	aVariableUnion = a0;
	throw new ExVariableUnion(aVariableUnion);
    }


    public String[]
    attrStringSequence()
    {
	return aStringSequence;
    }

    public void
    attrStringSequence(String[] value)
    {
	aStringSequence = value;
    }

    public String[]
    opStringSequence(String[] a0,
                     StringSequenceHolder a1,
                     StringSequenceHolder a2)
    {
	aStringSequence = new String[a0.length + a1.value.length];
	int idx = 0;
	for(int i = 0 ; i < a0.length ; i++)
	    aStringSequence[idx++] = a0[i];
	for(int i = 0 ; i < a1.value.length ; i++)
	    aStringSequence[idx++] = a1.value[i];
	a1.value = a2.value = aStringSequence;
	return aStringSequence;
    }

    public String[]
    opStringSequenceEx(String[] a0,
		       StringSequenceHolder a1,
		       StringSequenceHolder a2)
	throws ExStringSequence
    {
	aStringSequence = new String[a0.length + a1.value.length];
	int idx = 0;
	for(int i = 0 ; i < a0.length ; i++)
	    aStringSequence[idx++] = a0[i];
	for(int i = 0 ; i < a1.value.length ; i++)
	    aStringSequence[idx++] = a1.value[i];
	throw new ExStringSequence(aStringSequence);
    }

    public short[][][]
    attrFixedArray()
    {
	return aFixedArray;
    }

    public void
    attrFixedArray(short[][][] value)
    {
	aFixedArray = value;
    }

    public short[][][]
    opFixedArray(short[][][] a0,
		 FixedArrayHolder a1,
		 FixedArrayHolder a2)
    {
	aFixedArray = a0;
	a1.value = a2.value = aFixedArray;
	return aFixedArray;
    }

    public short[][][]
    opFixedArrayEx(short[][][] a0,
		   FixedArrayHolder a1,
		   FixedArrayHolder a2)
	throws ExFixedArray
    {
	aFixedArray = a0;
	throw new ExFixedArray(aFixedArray);
    }

    public String[][]
    attrVariableArray()
    {
	return aVariableArray;
    }

    public void
    attrVariableArray(String[][] value)
    {
	aVariableArray = value;
    }

    public String[][]
    opVariableArray(String[][] a0,
		    VariableArrayHolder a1,
		    VariableArrayHolder a2)
    {
	aVariableArray = a0;
	a1.value = a2.value = aVariableArray;
	return aVariableArray;
    }

    public String[][]
    opVariableArrayEx(String[][] a0,
		      VariableArrayHolder a1,
		      VariableArrayHolder a2)
	throws ExVariableArray
    {
	aVariableArray = a0;
	throw new ExVariableArray(aVariableArray);
    }

    public short[][][][]
    attrFixedArraySequence()
    {
	return aFixedArraySequence;
    }

    public void
    attrFixedArraySequence(short[][][][] value)
    {
	aFixedArraySequence = value;
    }

    public short[][][][]
    opFixedArraySequence(short[][][][] a0,
			 FixedArraySequenceHolder a1,
			 FixedArraySequenceHolder a2)
    {
	aFixedArraySequence = new short[a0.length + a1.value.length][][][];
	int idx = 0;
	for(int i = 0 ; i < a0.length ; i++)
	    aFixedArraySequence[idx++] = a0[i];
	for(int i = 0 ; i < a1.value.length ; i++)
	    aFixedArraySequence[idx++] = a1.value[i];
	a1.value = a2.value = aFixedArraySequence;
	return aFixedArraySequence;
    }

    public short[][][][]
    opFixedArraySequenceEx(short[][][][] a0,
			   FixedArraySequenceHolder a1,
			   FixedArraySequenceHolder a2)
	throws ExFixedArraySequence
    {
	aFixedArraySequence = new short[a0.length + a1.value.length][][][];
	int idx = 0;
	for(int i = 0 ; i < a0.length ; i++)
	    aFixedArraySequence[idx++] = a0[i];
	for(int i = 0 ; i < a1.value.length ; i++)
	    aFixedArraySequence[idx++] = a1.value[i];
	throw new ExFixedArraySequence(aFixedArraySequence);
    }

    public String[][][]
    attrVariableArraySequence()
    {
	return aVariableArraySequence;
    }

    public void
    attrVariableArraySequence(String[][][] value)
    {
	aVariableArraySequence = value;
    }

    public String[][][]
    opVariableArraySequence(String[][][] a0,
			    VariableArraySequenceHolder a1,
			    VariableArraySequenceHolder a2)
    {
	aVariableArraySequence = new String[a0.length + a1.value.length][][];

	int idx = 0;
	for(int i = 0 ; i < a0.length ; i++)
	    aVariableArraySequence[idx++] = a0[i];
	for(int i = 0 ; i < a1.value.length ; i++)
	    aVariableArraySequence[idx++] = a1.value[i];
	a1.value = a2.value = aVariableArraySequence;
	return aVariableArraySequence;
    }

    public String[][][]
    opVariableArraySequenceEx(String[][][] a0,
			      VariableArraySequenceHolder a1,
			      VariableArraySequenceHolder a2)
	throws ExVariableArraySequence
    {
	aVariableArraySequence = new String[a0.length + a1.value.length][][];
	int idx = 0;
	for(int i = 0 ; i < a0.length ; i++)
	    aVariableArraySequence[idx++] = a0[i];
	for(int i = 0 ; i < a1.value.length ; i++)
	    aVariableArraySequence[idx++] = a1.value[i];
	throw new ExVariableArraySequence(aVariableArraySequence);
    }

    public void
    deactivate()
    {
	boa_.deactivate_impl(null);
    }

    public void
    op_UNKNOWN_Ex()
    {
	throw new UNKNOWN(1, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_BAD_PARAM_Ex()
    {
	throw new BAD_PARAM(2, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_NO_MEMORY_Ex()
    {
	throw new NO_MEMORY(3, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_IMP_LIMIT_Ex()
    {
	throw new IMP_LIMIT(4, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_COMM_FAILURE_Ex()
    {
	throw new COMM_FAILURE(5, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_INV_OBJREF_Ex()
    {
	throw new INV_OBJREF(6, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_NO_PERMISSION_Ex()
    {
	throw new NO_PERMISSION(7, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_INTERNAL_Ex()
    {
	throw new INTERNAL(8, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_MARSHAL_Ex()
    {
	throw new MARSHAL(9, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_INITIALIZE_Ex()
    {
	throw new INITIALIZE(10, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_NO_IMPLEMENT_Ex()
    {
	throw new NO_IMPLEMENT(11, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_BAD_TYPECODE_Ex()
    {
	throw new BAD_TYPECODE(12, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_BAD_OPERATION_Ex()
    {
	throw new BAD_OPERATION(13, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_NO_RESOURCES_Ex()
    {
	throw new NO_RESOURCES(14, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_NO_RESPONSE_Ex()
    {
	throw new NO_RESPONSE(15, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_PERSIST_STORE_Ex()
    {
	throw new PERSIST_STORE(16, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_BAD_INV_ORDER_Ex()
    {
	throw new BAD_INV_ORDER(17, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_TRANSIENT_Ex()
    {
	throw new TRANSIENT(18, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_FREE_MEM_Ex()
    {
	throw new FREE_MEM(19, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_INV_IDENT_Ex()
    {
	throw new INV_IDENT(20, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_INV_FLAG_Ex()
    {
	throw new INV_FLAG(21, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_INTF_REPOS_Ex()
    {
	throw new INTF_REPOS(22, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_BAD_CONTEXT_Ex()
    {
	throw new BAD_CONTEXT(23, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_OBJ_ADAPTER_Ex()
    {
	throw new OBJ_ADAPTER(24, CompletionStatus.COMPLETED_MAYBE);
    }

    public void
    op_DATA_CONVERSION_Ex()
    {
	throw new DATA_CONVERSION(25, CompletionStatus.COMPLETED_YES);
    }

    public void
    op_OBJECT_NOT_EXIST_Ex()
    {
	throw new OBJECT_NOT_EXIST(26, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_TRANSACTION_REQUIRED_Ex()
    {
	throw new TRANSACTION_REQUIRED(27, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_TRANSACTION_ROLLEDBACK_Ex()
    {
	throw new TRANSACTION_ROLLEDBACK(28, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_INVALID_TRANSACTION_Ex()
    {
	throw new INVALID_TRANSACTION(29, CompletionStatus.COMPLETED_NO);
    }

    public void
    op_INV_POLICY_Ex()
    {
	throw new INV_POLICY(30, CompletionStatus.COMPLETED_NO);
    }

    public void
    sleepOneway(int sec)
    {
	try
	{
	    Thread.currentThread().sleep(sec * 1000);
	}
	catch(java.lang.InterruptedException ex)
	{
	}
    }

    public void
    sleepTwoway(int sec)
    {
	try
	{
	    Thread.currentThread().sleep(sec * 1000);
	}
	catch(java.lang.InterruptedException ex)
	{
	}
    }
}
