// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;

class TestStub extends TestBase
{
    TestStub(TestInterface ti)
    {
	int i, j, k ,l;

	ORB orb = ORB.init();

	{
	    ti.opVoid();
	}

	{
	    short ret;
	    ti.attrShort((short)-32768);
	    ret = ti.attrShort();
	    TEST(ret == -32768);
	    
	    ti.attrShort((short)32767);
	    ret = ti.attrShort();
	    TEST(ret == 32767);
	    
	    ShortHolder inOut = new ShortHolder((short)20);
	    ShortHolder out = new ShortHolder();
	    ret = ti.opShort((short)10, inOut, out);
	    TEST(ret == 30);
	    TEST(inOut.value == 30);
	    TEST(out.value == 30);
	}

	{
	    int ret;
	    ti.attrLong(-2147483647 - 1);
	    ret = ti.attrLong();
	    TEST(ret == -2147483647 - 1);

	    ti.attrLong(2147483647);
	    ret = ti.attrLong();
	    TEST(ret == 2147483647);

	    IntHolder inOut = new IntHolder(20);
	    IntHolder out = new IntHolder();
	    ret = ti.opLong(10, inOut, out);
	    TEST(ret == 30);
	    TEST(inOut.value == 30);
	    TEST(out.value == 30);
	}

	{
	    short ret;
	    ti.attrUShort((short)65535);
	    ret = ti.attrUShort();
	    TEST(ret == (short)65535);

	    ShortHolder inOut = new ShortHolder((short)20);
	    ShortHolder out = new ShortHolder();
	    ret = ti.opUShort((short)10, inOut, out);
	    TEST(ret == 30);
	    TEST(inOut.value == 30);
	    TEST(out.value == 30);
	}

	{
	    int ret;
	    ti.attrULong(2147483647);
	    ret = ti.attrULong();
	    TEST(ret == 2147483647);

	    IntHolder inOut = new IntHolder(20);
	    IntHolder out = new IntHolder();
	    ret = ti.opULong(10, inOut, out);
	    TEST(ret == 30);
	    TEST(inOut.value == 30);
	    TEST(out.value == 30);
	}

	{
	    float ret;
	    ti.attrFloat(3.40282347E+38F);
	    ret = ti.attrFloat();
	    TEST(ret == 3.40282347E+38F);
 
	    ti.attrFloat(1.17549435E-38F);
	    ret = ti.attrFloat();
	    TEST(ret == 1.17549435E-38F);
 
	    FloatHolder inOut = new FloatHolder(20);
	    FloatHolder out = new FloatHolder();
	    ret = ti.opFloat(10, inOut, out);
	    TEST(ret == 30);
	    TEST(inOut.value == 30);
	    TEST(out.value == 30);
	}

	{
	    double ret;
	    ti.attrDouble(1.7976931348623157E+308);
	    ret = ti.attrDouble();
	    TEST(ret == 1.7976931348623157E+308);
 
	    ti.attrDouble(2.2250738585072014E-308);
	    ret = ti.attrDouble();
	    TEST(ret == 2.2250738585072014E-308);
 
	    DoubleHolder inOut = new DoubleHolder(20);
	    DoubleHolder out = new DoubleHolder();
	    ret = ti.opDouble(10, inOut, out);
	    TEST(ret == 30);
	    TEST(inOut.value == 30);
	    TEST(out.value == 30);
	}

	{
	    boolean ret;
	    ti.attrBoolean(true);
	    ret = ti.attrBoolean();
	    TEST(ret == true);

	    ti.attrBoolean(false);
	    ret = ti.attrBoolean();
	    TEST(ret == false);

	    BooleanHolder inOut = new BooleanHolder(true);
	    BooleanHolder out = new BooleanHolder();
	    ret = ti.opBoolean(true, inOut, out);
	    TEST(ret == true);
	    TEST(inOut.value == true);
	    TEST(out.value == true);
 
	    inOut.value = true;
	    ret = ti.opBoolean(false, inOut, out);
	    TEST(ret == false);
	    TEST(inOut.value == false);
	    TEST(out.value == false);

	    inOut.value = false;
	    ret = ti.opBoolean(true, inOut, out);
	    TEST(ret == false);
	    TEST(inOut.value == false);
	    TEST(out.value == false);
	}

	{
	    char ret;
	    ti.attrChar('a');
	    ret = ti.attrChar();
	    TEST(ret == 'a');
	    ti.attrChar((char)224);
	    ret = ti.attrChar();
	    TEST(ret == (char)224);

	    CharHolder inOut = new CharHolder((char)1);
	    CharHolder out = new CharHolder();
	    ret = ti.opChar('a', inOut, out);
	    TEST(ret == 'b');
	    TEST(inOut.value == 'b');
	    TEST(out.value == 'b');
	}

	{
	    byte ret;
	    ti.attrOctet((byte)0xff);
	    ret = ti.attrOctet();
	    TEST(ret == (byte)0xff);

	    ti.attrOctet((byte)0);
	    ret = ti.attrOctet();
	    TEST(ret == (byte)0);

	    ByteHolder inOut = new ByteHolder((byte)20);
	    ByteHolder out = new ByteHolder();
	    ret = ti.opOctet((byte)10, inOut, out);
	    TEST(ret == 30);
	    TEST(inOut.value == 30);
	    TEST(out.value == 30);
	}

	{
	    String ret;
	    ti.attrString("Hello");
	    ret = ti.attrString();
	    TEST(ret.equals("Hello"));

	    StringHolder inOut = new StringHolder("world!");
	    StringHolder out = new StringHolder();
	    ret = ti.opString("Hello, ", inOut, out);
	    TEST(ret.equals("Hello, world!"));
	    TEST(out.value.equals("Hello, world!"));
	}

	{
	    Any any = orb.create_any();
	    Any ret = orb.create_any();

	    any.insert_string("abc");
	    ti.attrAny(any);
	    ret = ti.attrAny();
	    String s;
	    s = ret.extract_string();
	    TEST(s.equals("abc"));

	    any.insert_double(3.14);
	    ti.attrAny(any);
	    ret = ti.attrAny();
	    double d;
	    d = ret.extract_double();
	    TEST(d == 3.14);

	    VariableStruct vStruct = new VariableStruct();
	    vStruct.s = "xyz";
	    VariableStructHelper.insert(any, vStruct);
	    AnyHolder inOut = new AnyHolder(orb.create_any());
	    AnyHolder out = new AnyHolder();
	    ret = ti.opAny(any, inOut, out);
	    VariableStruct vStructRet;
	    VariableStruct vStructInOut;
	    VariableStruct vStructOut;
	    vStructRet = VariableStructHelper.extract(ret);
	    vStructInOut = VariableStructHelper.extract(inOut.value);
	    vStructOut = VariableStructHelper.extract(out.value);
	    TEST(vStructRet.s.equals("xyz"));
	    TEST(vStructInOut.s.equals("xyz"));
	    TEST(vStructOut.s.equals("xyz"));

	    TestUnion1 u = new TestUnion1();
	    u.l(123);
	    TestUnion1Helper.insert(any, u);
	    ti.attrAny(any);
	    ret = ti.attrAny();
	    TestUnion1 u2 = TestUnion1Helper.extract(ret);
	    TEST(u2.l() == 123);
	    TEST(u2.discriminator() == -1);
	    TEST(ret.type().equal(TestUnion1Helper.type()));
	    u.tc(-6, TestUnion1Helper.type());
	    TEST(u.discriminator() == -6);
	    TestUnion1Helper.insert(any, u);
	    ti.attrAny(any);
	    ret = ti.attrAny();
	    TestUnion1 u3 = TestUnion1Helper.extract(ret);
	    TEST(u3.discriminator() == -6);
	    TEST(u3.tc().equal(TestUnion1Helper.type()));

	    TestStruct3 rs = new TestStruct3();;
	    rs.l = 287;
	    rs.seq = new TestStruct3[3];
	    rs.seq[0] = new TestStruct3();
	    rs.seq[0].l = 888;
	    rs.seq[0].seq = new TestStruct3[0];
	    rs.seq[1] = new TestStruct3();
	    rs.seq[1].l = 999;
	    rs.seq[1].seq = new TestStruct3[0];
	    rs.seq[2] = new TestStruct3();
	    rs.seq[2].l = 111;
	    rs.seq[2].seq = new TestStruct3[1];
	    rs.seq[2].seq[0] = new TestStruct3();
	    rs.seq[2].seq[0].l = 222;
	    rs.seq[2].seq[0].seq = new TestStruct3[0];
	    TestStruct3Helper.insert(any, rs);
	    ti.attrAny(any);
	    ret = ti.attrAny();
	    TestStruct3 rs2 = TestStruct3Helper.extract(ret);
	    TEST(rs2.l == 287);
	    TEST(rs2.seq.length == 3);
	    TEST(rs2.seq[0].l == 888);
	    TEST(rs2.seq[1].l == 999);
	    TEST(rs2.seq[2].l == 111);
	    TEST(rs2.seq[2].seq.length == 1);
	    TEST(rs2.seq[2].seq[0].l == 222);
	}

	{
	    test.TestInterfacePackage.TestEnum ret;
	    ti.attrTestEnum(test.TestInterfacePackage.TestEnum.TestEnum2);
	    ret = ti.attrTestEnum();
	    TEST(ret == test.TestInterfacePackage.TestEnum.TestEnum2);

	    ti.attrTestEnum(test.TestInterfacePackage.TestEnum.TestEnum3);
	    ret = ti.attrTestEnum();
	    TEST(ret == test.TestInterfacePackage.TestEnum.TestEnum3);

	    test.TestInterfacePackage.TestEnumHolder inOut =
		new test.TestInterfacePackage.TestEnumHolder(
		    test.TestInterfacePackage.TestEnum.TestEnum2);
	    test.TestInterfacePackage.TestEnumHolder out =
		new test.TestInterfacePackage.TestEnumHolder();
	    ret = ti.opTestEnum(test.TestInterfacePackage.TestEnum.TestEnum3,
				inOut, out);
	    TEST(ret == test.TestInterfacePackage.TestEnum.TestEnum3);
	    TEST(inOut.value == test.TestInterfacePackage.TestEnum.TestEnum3);
	    TEST(out.value == test.TestInterfacePackage.TestEnum.TestEnum3);
	}

	{
	    TestInterface ret;
	    ti.attrTestInterface(ti);
	    ret = ti.attrTestInterface();
	    TEST(ret._is_equivalent(ti));

	    TestInterfaceHolder inOut =
		new TestInterfaceHolder((TestInterface)(ti._duplicate()));
	    TestInterfaceHolder out = new TestInterfaceHolder();
	    ret = ti.opTestInterface(ti, inOut, out);
	    TEST(ret._is_equivalent(ti));
	    TEST(inOut.value._is_equivalent(ti));
	    TEST(out.value._is_equivalent(ti));
	}

	{
	    FixedStruct st = new FixedStruct();
	    st.s = 100;
	    st.l = -100;

	    FixedStruct ret;
	    ti.attrFixedStruct(st);
	    ret = ti.attrFixedStruct();
	    TEST(ret.s == st.s);
	    TEST(ret.l == st.l);

	    FixedStructHolder inOut = new FixedStructHolder(new FixedStruct());
	    inOut.value.s = 10000;
	    inOut.value.l = 100000;
	    FixedStructHolder out = new FixedStructHolder();
	    ret = ti.opFixedStruct(st, inOut, out);
	    TEST(ret.s == st.s);
	    TEST(ret.l == st.l);
	    TEST(inOut.value.s == st.s);
	    TEST(out.value.l == st.l);
	    TEST(inOut.value.s == st.s);
	    TEST(out.value.l == st.l);
	}

	{
	    VariableStruct st =	new VariableStruct();
	    st.s = "$$$";

	    VariableStruct ret;
	    ti.attrVariableStruct(st);
	    ret = ti.attrVariableStruct();
	    TEST(ret.s.equals(st.s));

	    VariableStructHolder inOut =
		new VariableStructHolder(new VariableStruct());
	    inOut.value.s = "bla";
	    VariableStructHolder out = new VariableStructHolder();
	    ret = ti.opVariableStruct(st, inOut, out);
	    TEST(ret.s.equals(st.s));
	    TEST(inOut.value.s.equals(st.s));
	    TEST(out.value.s.equals(st.s));
	}

	{
	    FixedUnion un = new FixedUnion();
	    un.d(1.23);

	    FixedUnion ret;
	    ti.attrFixedUnion(un);
	    ret = ti.attrFixedUnion();
	    TEST(ret.discriminator() == 2);
	    TEST(ret.d() == 1.23);

	    un.b((short)999, true);
	    FixedUnionHolder inOut = new FixedUnionHolder(new FixedUnion());
	    FixedUnionHolder out = new FixedUnionHolder();
	    inOut.value.l(100);
	    ret = ti.opFixedUnion(un, inOut, out);
	    TEST(ret.discriminator() == 999);
	    TEST(ret.b() == true);
	    TEST(out.value.discriminator() == 999);
	    TEST(out.value.b() == true);
	    TEST(inOut.value.discriminator() == 999);
	    TEST(inOut.value.b() == true);

	    FixedStruct st = new FixedStruct();
	    st.s = 10101;
	    st.l = -10101;
	    un.st(st);
	    inOut.value.l(100);
	    ret = ti.opFixedUnion(un, inOut, out);
	    TEST(ret.discriminator() == 3);
	    TEST(ret.st().s == 10101);
	    TEST(ret.st().l == -10101);
	    TEST(out.value.discriminator() == 3);
	    TEST(out.value.st().s == 10101);
	    TEST(out.value.st().l == -10101);
	    TEST(inOut.value.discriminator() == 3);
	    TEST(inOut.value.st().s == 10101);
	    TEST(inOut.value.st().l == -10101);
	}

	{
	    VariableUnion un = new VariableUnion();
	    VariableStruct st = new VariableStruct();
	    st.s = "$$$";
	    un.st(st);

	    VariableUnion ret;
	    ti.attrVariableUnion(un);
	    ret = ti.attrVariableUnion();
	    TEST(ret.st().s.equals("$$$"));

	    un.ti(ti);
	    VariableUnionHolder inOut =
		new VariableUnionHolder(new VariableUnion());
	    VariableUnionHolder out = new VariableUnionHolder();
	    inOut.value.st(st);
	    ret = ti.opVariableUnion(un, inOut, out);
	    TEST(ret.ti()._is_equivalent(ti));
	    TEST(inOut.value.ti()._is_equivalent(ti));
	    TEST(out.value.ti()._is_equivalent(ti));
	}

	{
	    String[] seq = new String[3];
	    seq[0] = "!!!";
	    seq[1] = "@@@";
	    seq[2] = "###";

	    String[] ret;
	    ti.attrStringSequence(seq);
	    ret = ti.attrStringSequence();
	    TEST(ret.length == 3);
	    TEST(ret[0].equals("!!!"));
	    TEST(ret[1].equals("@@@"));
	    TEST(ret[2].equals("###"));

	    StringSequenceHolder inOut =
		new StringSequenceHolder(new String[2]);
	    inOut.value[0] = "%";
	    inOut.value[1] = "^^";
	    StringSequenceHolder out = new StringSequenceHolder();
	    ret = ti.opStringSequence(seq, inOut, out);
	    TEST(ret.length == 5);
	    TEST(ret[0].equals("!!!"));
	    TEST(ret[1].equals("@@@"));
	    TEST(ret[2].equals("###"));
	    TEST(ret[3].equals("%"));
	    TEST(ret[4].equals("^^"));
	    TEST(inOut.value.length == 5);
	    TEST(inOut.value[0].equals("!!!"));
	    TEST(inOut.value[1].equals("@@@"));
	    TEST(inOut.value[2].equals("###"));
	    TEST(inOut.value[3].equals("%"));
	    TEST(inOut.value[4].equals("^^"));
	    TEST(out.value.length == 5);
	    TEST(out.value[0].equals("!!!"));
	    TEST(out.value[1].equals("@@@"));
	    TEST(out.value[2].equals("###"));
	    TEST(out.value[3].equals("%"));
	    TEST(out.value[4].equals("^^"));
	}

	{
	    short[][][] ar =
	    {
		{
		    { 1, 2, 3, 4 },
		    { 10, -10, 11, -11 },
		    { -999, 0, 888, 123 }
		},
		{
		    { 17, 27, 37, 47 },
		    { 710, -710, 711, -711 },
		    { -99, 0, 88, 13 }
		}
	    };

	    short[][][] ret;
	    ti.attrFixedArray(ar);
	    ret = ti.attrFixedArray();
	    for(i = 0; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
		    {
			TEST(ar[i][j][k] == ret[i][j][k]);
		    }

	    FixedArrayHolder inOut = new FixedArrayHolder(new short[2][3][4]);
	    FixedArrayHolder out = new FixedArrayHolder();
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
			inOut.value[i][j][k] = (short)(i + j + k);
	    ret = ti.opFixedArray(ar, inOut, out);
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
		    {
			TEST(ar[i][j][k] == ret[i][j][k]);
			TEST(ar[i][j][k] == inOut.value[i][j][k]);
			TEST(ar[i][j][k] == out.value[i][j][k]);
                }
	}

	{
	    String[][] ar =
	    {
		{ "aa", "bb", "cc" },
		{ "AA", "BB", "CC" }
	    };

	    String[][] ret;
	    ti.attrVariableArray(ar);
	    ret = ti.attrVariableArray();
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		{
		    TEST((ar[i][j].equals(ret[i][j])));
		}

	    VariableArrayHolder inOut = new VariableArrayHolder(
		new String[2][3]);
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    inOut.value[i][j] = "abc";
	    VariableArrayHolder out = new VariableArrayHolder();
	    ret = ti.opVariableArray(ar, inOut, out);
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		{
		    TEST(ar[i][j].equals(ret[i][j]));
		    TEST(ar[i][j].equals(inOut.value[i][j]));
		    TEST(ar[i][j].equals(out.value[i][j]));
		}
	}

	{
	    short[][][] ar0 =
	    {
		{
		    { 1, 2, 3, 4 },
		    { 10, -10, 11, -11 },
		    { -999, 0, 888, 123 }
		},
		{
		    { 17, 27, 37, 47 },
		    { 710, -710, 711, -711 },
		    { -99, 0, 88, 13 }
		}
	    };

	    short[][][] ar1 =
	    {
		{
		    { 2, 3, 4, 1 },
		    { 10, 11, 11, -10 },
		    { -0, 939, 123, 888 }
		},
		{
		    { 17, 37, 47, 27 },
		    { 710, -710, 711, -711 },
		    { -0, -99, 13, 8338 }
		}
	    };
 
	    short[][][] ar2 =
	    {
		{
		    { 1, 2, -3, -234 },
		    { 10, -11, 11, -10 },
		    { -999, 30, 1888, 123 }
		},
		{
		    { 27, 37, 117, 47 },
		    { 710, -7150, 711, -711 },
		    { -0, 13, 929, 88 }
		}
	    };

	    short[][][][] seq = new short[3][2][3][4];
	    seq[0] = ar0;
	    seq[1] = ar1;
	    seq[2] = ar2;

	    short[][][][] ret;

	    ti.attrFixedArraySequence(seq);
	    ret = ti.attrFixedArraySequence();

	    for(l = 0 ; l < 3 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			for(k = 0 ; k < 4 ; k++)
			{
			    TEST(seq[l][i][j][k] == ret[l][i][j][k]);
			}

	    FixedArraySequenceHolder inOut =
		new FixedArraySequenceHolder(new short[4][2][3][4]);
	    for(l = 0 ; l < 4 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			for(k = 0 ; k < 4 ; k++)
			    inOut.value[l][i][j][k] = (short)(i + j + k + l);

	    FixedArraySequenceHolder out = new FixedArraySequenceHolder();

	    ret = ti.opFixedArraySequence(seq, inOut, out);

	    TEST(ret.length == 7);
	    TEST(inOut.value.length == 7);
	    TEST(out.value.length == 7);

	    for(l = 0 ; l < 3 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			for(k = 0 ; k < 4 ; k++)
			{
			    TEST(seq[l][i][j][k] == ret[l][i][j][k]);
			    TEST(seq[l][i][j][k] == inOut.value[l][i][j][k]);
			    TEST(seq[l][i][j][k] == out.value[l][i][j][k]);
			}

	    for(l = 0 ; l < 4 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			for(k = 0 ; k < 4 ; k++)
			{
			    TEST(ret[3 + l][i][j][k] == i + j + k + l);
			    TEST(inOut.value[3 + l][i][j][k] == i + j + k + l);
			    TEST(out.value[3 + l][i][j][k] == i + j + k + l);
			}
	}

	{
	    String[][] ar0 =
	    {
		{ "aa", "bb", "cc" },
		{ "AA", "BB", "CC" }
	    };

	    String[][] ar1 =
	    {
		{ "a-a", "b-b", "c-c" },
		{ "A-A", "B-B", "C-C" }
	    };

	    String[][][] seq = new String[2][][];
	    seq[0] = ar0;
	    seq[1] = ar1;

	    String[][][] ret;

	    ti.attrVariableArraySequence(seq);
	    ret = ti.attrVariableArraySequence();

	    for(l = 0 ; l < 2 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
		    {
			TEST(seq[l][i][j].equals(ret[l][i][j]));
                }

	    VariableArraySequenceHolder inOut =
		new VariableArraySequenceHolder(new String[4][2][3]);
	    for(l = 0 ; l < 4 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			inOut.value[l][i][j] = "***";

	    VariableArraySequenceHolder out =
		new VariableArraySequenceHolder();

	    ret = ti.opVariableArraySequence(seq, inOut, out);

	    TEST(ret.length == 6);
	    TEST(inOut.value.length == 6);
	    TEST(out.value.length == 6);

	    for(l = 0 ; l < 2 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
		    {
			TEST(seq[l][i][j].equals(ret[l][i][j]));
			TEST(seq[l][i][j].equals(inOut.value[l][i][j]));
			TEST(seq[l][i][j].equals(out.value[l][i][j]));
		    }

	    for(l = 0 ; l < 4 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
		    {
			TEST(ret[2 + l][i][j].equals("***"));
			TEST(inOut.value[2 + l][i][j].equals("***"));
			TEST(out.value[2 + l][i][j].equals("***"));
		    }
	}
    }
}
