// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;

class TestStubContext extends TestBase
{
    TestStubContext(ORB orb, TestInterface ti)
    {
	Context ctx;
	Context ctx2;

	{
	    ctx = orb.get_default_context();

	    String[] seq;

	    try
	    {
		seq = ti.opContext("*", ctx);
		TEST(false);
	    }
	    catch(BAD_CONTEXT ex)
	    {
		// Expected
	    }
	}

	{
	    Any any = orb.create_any();
	    int i;
	    String[] seq;

	    ctx = orb.get_default_context();

	    any.insert_string("A1");
	    ctx.set_one_value("A", any);

	    any.insert_string("A2");
	    ctx.set_one_value("AAA", any);

	    any.insert_string("B1");
	    ctx.set_one_value("B", any);

	    any.insert_string("B2");
	    ctx.set_one_value("BBB", any);

	    any.insert_string("X1");
	    ctx.set_one_value("X", any);

	    any.insert_string("X2");
	    ctx.set_one_value("XXX", any);

	    any.insert_string("Y1");
	    ctx.set_one_value("Y", any);

	    any.insert_string("Y2");
	    ctx.set_one_value("YYY", any);

	    seq = ti.opContext("*", ctx);
	    TEST(seq.length == 3 * 2);
	    i = 0;
	    TEST(seq[i++].equals("A") &&
		 seq[i++].equals("A1"));
	    TEST(seq[i++].equals("AAA") &&
		 seq[i++].equals("A2"));
	    TEST(seq[i++].equals("X") &&
		 seq[i++].equals("X1"));

	    seq = ti.opContext("A*", ctx);
	    TEST(seq.length == 2 * 2);
	    i = 0;
	    TEST(seq[i++].equals("A") &&
		 seq[i++].equals("A1"));
	    TEST(seq[i++].equals("AAA") &&
		 seq[i++].equals("A2"));

	    seq = ti.opContext("AA*", ctx);
	    TEST(seq.length == 1 * 2);
	    i = 0;
	    TEST(seq[i++].equals("AAA") &&
		 seq[i++].equals("A2"));

	    seq = ti.opContext("A", ctx);
	    TEST(seq.length == 1 * 2);
	    i = 0;
	    TEST(seq[i++].equals("A") &&
		 seq[i++].equals("A1"));

	    ctx2 = ctx.create_child("child");

	    any.insert_string("C1");
	    ctx2.set_one_value("C", any);

	    any.insert_string("C2");
	    ctx2.set_one_value("CCC", any);

	    any.insert_string("X1-1");
	    ctx2.set_one_value("X", any);

	    seq = ti.opContext("*", ctx2);
	    TEST(seq.length == 5 * 2);
	    i = 0;
	    TEST(seq[i++].equals("A") &&
		 seq[i++].equals("A1"));
	    TEST(seq[i++].equals("AAA") &&
		 seq[i++].equals("A2"));
	    TEST(seq[i++].equals("C") &&
		 seq[i++].equals("C1"));
	    TEST(seq[i++].equals("CCC") &&
		 seq[i++].equals("C2"));
	    TEST(seq[i++].equals("X") &&
		 seq[i++].equals("X1-1"));
	}
    }
}
