// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import test.TestInterfacePackage.*;
import test.TestInterfaceExPackage.*;

class TestStubException extends TestBase
{
    TestStubException(TestInterfaceEx ti, boolean dyn)
    {
	int i, j, k, l;

	ORB orb = ORB.init();

	{
	    try
	    {
		ti.opVoidEx();
		TEST(false);
	    }
	    catch(ExVoid ex)
	    {
	    }
	}

	{
	    ShortHolder inOut = new ShortHolder((short)20);
	    ShortHolder out = new ShortHolder();

	    try
	    {
		ti.opShortEx((short)10, inOut, out);
		TEST(false);
	    }
	    catch(ExShort ex)
	    {
		TEST(ex.value == 30);
	    }
	}

	{
	    IntHolder inOut = new IntHolder(20);
	    IntHolder out = new IntHolder();

	    try
	    {
		ti.opLongEx(10, inOut, out);
		TEST(false);
	    }
	    catch(ExLong ex)
	    {
		TEST(ex.value == 30);
	    }
	}

	{
	    ShortHolder inOut = new ShortHolder((short)20);
	    ShortHolder out = new ShortHolder();

	    try
	    {
		ti.opUShortEx((short)10, inOut, out);
		TEST(false);
	    }
	    catch(ExUShort ex)
	    {
		TEST(ex.value == 30);
	    }
	}

	{
	    IntHolder inOut = new IntHolder(20);
	    IntHolder out = new IntHolder();

	    try
	    {
		ti.opULongEx(10, inOut, out);
		TEST(false);
	    }
	    catch(ExULong ex)
	    {
		TEST(ex.value == 30);
	    }
	}

	{
	    FloatHolder inOut = new FloatHolder(20);
	    FloatHolder out = new FloatHolder();

	    try
	    {
		ti.opFloatEx(10, inOut, out);
		TEST(false);
	    }
	    catch(ExFloat ex)
	    {
		TEST(ex.value == 30);
	    }
	}

	{
	    DoubleHolder inOut = new DoubleHolder(20);
	    DoubleHolder out = new DoubleHolder();

	    try
	    {
		ti.opDoubleEx(10, inOut, out);
		TEST(false);
	    }
	    catch(ExDouble ex)
	    {
		TEST(ex.value == 30);
	    }
	}

	{
	    BooleanHolder inOut = new BooleanHolder(true);
	    BooleanHolder out = new BooleanHolder();

	    try
	    {
		ti.opBooleanEx(true, inOut, out);
		TEST(false);
	    }
	    catch(ExBoolean ex)
	    {
		TEST(ex.value == true);
	    }
	}

	{
	    CharHolder inOut = new CharHolder((char)1);
	    CharHolder out = new CharHolder();

	    try
	    {
		ti.opCharEx('a', inOut, out);
		TEST(false);
	    }
	    catch(ExChar ex)
	    {
		TEST(ex.value == 'b');
	    }
	}

	{
	    ByteHolder inOut = new ByteHolder((byte)20);
	    ByteHolder out = new ByteHolder();

	    try
	    {
		ti.opOctetEx((byte)10, inOut, out);
		TEST(false);
	    }
	    catch(ExOctet ex)
	    {
		TEST(ex.value == 30);
	    }
	}

	{
	    StringHolder inOut = new StringHolder("world!");
	    StringHolder out = new StringHolder();

	    try
	    {
		ti.opStringEx("Hello, ", inOut, out);
		TEST(false);
	    }
	    catch(ExString ex)
	    {
		TEST(ex.value.equals("Hello, world!"));
	    }
	}

	{
	    VariableStruct vStruct = new VariableStruct();
	    vStruct.s = "xyz";
	    Any any = orb.create_any();
	    VariableStructHelper.insert(any, vStruct);
	    AnyHolder inOut = new AnyHolder(orb.create_any());
	    AnyHolder out = new AnyHolder(orb.create_any());

	    try
	    {
		ti.opAnyEx(any, inOut, out);
		TEST(false);
	    }
	    catch(ExAny ex)
	    {
		VariableStruct vStructRet;
		vStructRet = VariableStructHelper.extract(any);
		TEST(vStructRet.s.equals("xyz"));
	    }
	}

	{
	    test.TestInterfacePackage.TestEnumHolder inOut =
		new test.TestInterfacePackage.TestEnumHolder();
	    test.TestInterfacePackage.TestEnumHolder out =
		new test.TestInterfacePackage.TestEnumHolder();
	    inOut.value = test.TestInterfacePackage.TestEnum.TestEnum2;

	    try
	    {
		ti.opTestEnumEx(test.TestInterfacePackage.TestEnum.TestEnum3,
				inOut, out);
		TEST(false);
	    }
	    catch(ExTestEnum ex)
	    {
		TEST(ex.value == test.TestInterfacePackage.TestEnum.TestEnum3);
	    }
	}

	if(!dyn)
	{
	    TestInterfaceHolder inOut = new TestInterfaceHolder();
	    TestInterfaceHolder out = new TestInterfaceHolder();
	    inOut.value = (TestInterface)ti._duplicate();
	    
	    try
	    {
		ti.opTestInterfaceEx(ti, inOut, out);
		TEST(false);
	    }
	    catch(ExTestInterface ex)
	    {
		TEST(ex.value._is_equivalent(ti));
	    }
	}
	
	{
	    test.TestInterfacePackage.FixedStruct st =
		new test.TestInterfacePackage.FixedStruct();
	    st.s = 100;
	    st.l = -100;
	    test.TestInterfacePackage.FixedStructHolder inOut =
		new test.TestInterfacePackage.FixedStructHolder(
		    new test.TestInterfacePackage.FixedStruct());
	    test.TestInterfacePackage.FixedStructHolder out =
		new test.TestInterfacePackage.FixedStructHolder();
	    inOut.value.s = 10000;
	    inOut.value.l = 100000;
	    
	    try
	    {
		ti.opFixedStructEx(st, inOut, out);
		TEST(false);
	    }
	    catch(ExFixedStruct ex)
	    {
		TEST(ex.value.s == st.s);
		TEST(ex.value.l == st.l);
	    }
	}
	
	{
	    test.TestInterfacePackage.VariableStruct st =
		new test.TestInterfacePackage.VariableStruct();
	    st.s = "$$$";
	    test.TestInterfacePackage.VariableStructHolder inOut =
		new test.TestInterfacePackage.VariableStructHolder(
		    new test.TestInterfacePackage.VariableStruct());
	    test.TestInterfacePackage.VariableStructHolder out =
		new test.TestInterfacePackage.VariableStructHolder();
	    inOut.value.s = "bla";
	    
	    try
	    {
		ti.opVariableStructEx(st, inOut, out);
		TEST(false);
	    }
	    catch(ExVariableStruct ex)
	    {
		TEST(ex.value.s.equals(st.s));
	    }
	}
	
	{
	    FixedUnion un = new FixedUnion();
	    un.b((short)999, true);
	    FixedUnionHolder inOut =
		new FixedUnionHolder(new FixedUnion());
	    FixedUnionHolder out =
		new FixedUnionHolder();
	    inOut.value.l(100);
	    
	    try
	    {
		ti.opFixedUnionEx(un, inOut, out);
		TEST(false);
	    }
	    catch(ExFixedUnion ex)
	    {
		TEST(ex.value.discriminator() == 999);
		TEST(ex.value.b() == true);
	    }
	}
	
	{
	    if(!dyn)
	    {
		VariableUnion un = new VariableUnion();
		un.ti(ti);
		VariableUnionHolder inOut =
		    new VariableUnionHolder(new VariableUnion());
		VariableUnionHolder out =
		    new VariableUnionHolder();
		VariableStruct st =	new VariableStruct();
		st.s = "bla";
		inOut.value.st(st);
		
		try
		{
		    ti.opVariableUnionEx(un, inOut, out);
		    TEST(false);
		}
		catch(ExVariableUnion ex)
		{
		    TEST(ex.value.ti()._is_equivalent(ti));
		}
	    }
	}
    
	{
	    String[] seq = new String[3];
	    seq[0] = "!!!";
	    seq[1] = "@@@";
	    seq[2] = "###";
	    StringSequenceHolder inOut = new StringSequenceHolder();
	    StringSequenceHolder out = new StringSequenceHolder();
	    inOut.value = new String[2];
	    inOut.value[0] = "%";
	    inOut.value[1] = "^^";

	    try
	    {
		ti.opStringSequenceEx(seq, inOut, out);
		TEST(false);
	    }
	    catch(ExStringSequence ex)
	    {
		TEST(ex.value.length == 5);
		TEST(ex.value[0].equals("!!!"));
		TEST(ex.value[1].equals("@@@"));
		TEST(ex.value[2].equals("###"));
		TEST(ex.value[3].equals("%"));
		TEST(ex.value[4].equals("^^"));
	    }
	}

	{
	    short[][][] ar =
	    {
		{
		    { 1, 2, 3, 4 },
		    { 10, -10, 11, -11 },
		    { -999, 0, 888, 123 }
		},
		{
		    { 17, 27, 37, 47 },
		    { 710, -710, 711, -711 },
		    { -99, 0, 88, 13 }
		}
	    };

	    short[][][] ret;
	    FixedArrayHolder inOut = new FixedArrayHolder(new short[2][3][4]);
	    FixedArrayHolder out = new FixedArrayHolder();
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    for(k = 0 ; k < 4 ; k++)
			inOut.value[i][j][k] = (short)(i + j + k);

	    try
	    {
		ti.opFixedArrayEx(ar, inOut, out);
		TEST(false);
	    }
	    catch(ExFixedArray ex)
	    {
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			for(k = 0 ; k < 4 ; k++)
			{
			    TEST(ar[i][j][k] == ex.value[i][j][k]);
			}
	    }
	}

	{
	    String[][] ar =
	    {
		{ "aa", "bb", "cc" },
		{ "AA", "BB", "CC" }
	    };

	    String[][] ret;
	    VariableArrayHolder inOut =
		new VariableArrayHolder(new String[2][3]);
	    for(i = 0 ; i < 2 ; i++)
		for(j = 0 ; j < 3 ; j++)
		    inOut.value[i][j] = "abc";
	    VariableArrayHolder out = new VariableArrayHolder();

	    try
	    {
		ti.opVariableArrayEx(ar, inOut, out);
		TEST(false);
	    }
	    catch(ExVariableArray ex)
	    {
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
		    {
			TEST(ar[i][j].equals(ex.value[i][j]));
		    }
	    }
	}

	{
	    short[][][] ar0 =
            {
		{
		    { 1, 2, 3, 4 },
		    { 10, -10, 11, -11 },
		    { -999, 0, 888, 123 }
		},
		{
		    { 17, 27, 37, 47 },
		    { 710, -710, 711, -711 },
		    { -99, 0, 88, 13 }
		}
	    };

	    short[][][] ar1 =
	    {
		{
		    { 2, 3, 4, 1 },
		    { 10, 11, 11, -10 },
		    { -0, 239, 123, 888 }
		},
		{
		    { 17, 37, 47, 27 },
		    { 710, -710, 711, -711 },
		    { -0, -99, 13, 8338 }
		}
	    };

	    short[][][] ar2 =
	    {
		{
		    { 1, 2, -3, -234 },
		    { 10, -11, 11, -10 },
		    { -999, 30, 1888, 123 }
		},
		{
		    { 27, 37, 117, 47 },
		    { 710, -7150, 711, -711 },
		    { -0, 13, 929, 88 }
		}
	    };

	    short[][][][] seq = new short[3][2][3][4];
            seq[0] = ar0;
            seq[1] = ar1;
            seq[2] = ar2;

	    FixedArraySequenceHolder inOut =
		new FixedArraySequenceHolder(new short[4][2][3][4]);
	    for(l = 0 ; l < 4 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			for(k = 0 ; k < 4 ; k++)
			    inOut.value[l][i][j][k] = (short)(i + j + k + l);

	    short[][][][] ret;
	    FixedArraySequenceHolder out = new FixedArraySequenceHolder();

	    try
	    {
		ret = ti.opFixedArraySequenceEx(seq, inOut, out);
		TEST(false);
	    }
	    catch(ExFixedArraySequence ex)
	    {
		TEST(ex.value.length == 7);

		for(l = 0 ; l < 3 ; l++)
		    for(i = 0 ; i < 2 ; i++)
			for(j = 0 ; j < 3 ; j++)
			    for(k = 0 ; k < 4 ; k++)
			    {
				TEST(seq[l][i][j][k] == ex.value[l][i][j][k]);
			    }
 
		for(l = 0 ; l < 4 ; l++)
		    for(i = 0 ; i < 2 ; i++)
			for(j = 0 ; j < 3 ; j++)
			    for(k = 0 ; k < 4 ; k++)
			    {
				TEST(ex.value[3 + l][i][j][k] ==
				     i + j + k + l);
			    }
	    }
	}

	{
	    String[][] ar0 =
            {
                { "aa", "bb", "cc" },
                { "AA", "BB", "CC" }
            };
 
            String[][] ar1 =
            {
                { "a-a", "b-b", "c-c" },
                { "A-A", "B-B", "C-C" }
            };

	    String[][][] seq = new String[2][][];
            seq[0] = ar0;
            seq[1] = ar1;

	    VariableArraySequenceHolder inOut =
		new VariableArraySequenceHolder(new String[4][2][3]);
	    for(l = 0 ; l < 4 ; l++)
		for(i = 0 ; i < 2 ; i++)
		    for(j = 0 ; j < 3 ; j++)
			inOut.value[l][i][j] = "***";

	    String[][][] ret;
	    VariableArraySequenceHolder out =
		new VariableArraySequenceHolder();

	    try
	    {
		ret = ti.opVariableArraySequenceEx(seq, inOut, out);
		TEST(false);
	    }
	    catch(ExVariableArraySequence ex)
	    {
		TEST(ex.value.length == 6);

		for(l = 0 ; l < 2 ; l++)
		    for(i = 0 ; i < 2 ; i++)
			for(j = 0 ; j < 3 ; j++)
			{
			    TEST(seq[l][i][j].equals(ex.value[l][i][j]));
			}
 
		for(l = 0 ; l < 4 ; l++)
		    for(i = 0 ; i < 2 ; i++)
			for(j = 0 ; j < 3 ; j++)
			{
			    TEST(ex.value[2 + l][i][j].equals("***"));
			}

	    }
	}

	{
	    try
	    {
		ti.op_UNKNOWN_Ex();
		TEST(false);
	    }
	    catch(UNKNOWN ex)
	    {
		TEST(ex.minor == 1);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_BAD_PARAM_Ex();
		TEST(false);
	    }
	    catch(BAD_PARAM ex)
	    {
		TEST(ex.minor == 2);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_IMP_LIMIT_Ex();
		TEST(false);
	    }
	    catch(IMP_LIMIT ex)
	    {
		TEST(ex.minor == 4);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_COMM_FAILURE_Ex();
		TEST(false);
	    }
	    catch(COMM_FAILURE ex)
	    {
		TEST(ex.minor == 5);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_INV_OBJREF_Ex();
		TEST(false);
	    }
	    catch(INV_OBJREF ex)
	    {
		TEST(ex.minor == 6);
		TEST(ex.completed == CompletionStatus.COMPLETED_MAYBE);
	    }

	    try
	    {
		ti.op_NO_PERMISSION_Ex();
		TEST(false);
    }
	    catch(NO_PERMISSION ex)
	    {
		TEST(ex.minor == 7);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_INTERNAL_Ex();
		TEST(false);
	    }
	    catch(INTERNAL ex)
	    {
		TEST(ex.minor == 8);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_MARSHAL_Ex();
		TEST(false);
	    }
	    catch(MARSHAL ex)
	    {
		TEST(ex.minor == 9);
		TEST(ex.completed == CompletionStatus.COMPLETED_MAYBE);
	    }

	    try
	    {
		ti.op_INITIALIZE_Ex();
		TEST(false);
	    }
	    catch(INITIALIZE ex)
	    {
		TEST(ex.minor == 10);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_NO_IMPLEMENT_Ex();
		TEST(false);
	    }
	    catch(NO_IMPLEMENT ex)
	    {
		TEST(ex.minor == 11);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_BAD_TYPECODE_Ex();
		TEST(false);
	    }
	    catch(BAD_TYPECODE ex)
	    {
		TEST(ex.minor == 12);
		TEST(ex.completed == CompletionStatus.COMPLETED_MAYBE);
	    }


	    try
	    {
		ti.op_BAD_OPERATION_Ex();
		TEST(false);
	    }
	    catch(BAD_OPERATION ex)
	    {
		TEST(ex.minor == 13);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }


	    try
	    {
		ti.op_NO_RESOURCES_Ex();
		TEST(false);
	    }
	    catch(NO_RESOURCES ex)
	    {
		TEST(ex.minor == 14);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_NO_RESPONSE_Ex();
		TEST(false);
	    }
	    catch(NO_RESPONSE ex)
	    {
		TEST(ex.minor == 15);
		TEST(ex.completed == CompletionStatus.COMPLETED_MAYBE);
	    }

	    try
	    {
		ti.op_PERSIST_STORE_Ex();
		TEST(false);
	    }
	    catch(PERSIST_STORE ex)
	    {
		TEST(ex.minor == 16);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_BAD_INV_ORDER_Ex();
		TEST(false);
	    }
	    catch(BAD_INV_ORDER ex)
	    {
		TEST(ex.minor == 17);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_TRANSIENT_Ex();
		TEST(false);
	    }
	    catch(TRANSIENT ex)
	    {
		TEST(ex.minor == 18);
		TEST(ex.completed == CompletionStatus.COMPLETED_MAYBE);
	    }

	    try
	    {
		ti.op_FREE_MEM_Ex();
		TEST(false);
	    }
	    catch(FREE_MEM ex)
	    {
		TEST(ex.minor == 19);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_INV_IDENT_Ex();
		TEST(false);
	    }
	    catch(INV_IDENT ex)
	    {
		TEST(ex.minor == 20);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_INV_FLAG_Ex();
		TEST(false);
	    }
	    catch(INV_FLAG ex)
	    {
		TEST(ex.minor == 21);
		TEST(ex.completed == CompletionStatus.COMPLETED_MAYBE);
	    }

	    try
	    {
		ti.op_INTF_REPOS_Ex();
		TEST(false);
	    }
	    catch(INTF_REPOS ex)
	    {
		TEST(ex.minor == 22);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_BAD_CONTEXT_Ex();
		TEST(false);
	    }
	    catch(BAD_CONTEXT ex)
	    {
		TEST(ex.minor == 23);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_OBJ_ADAPTER_Ex();
		TEST(false);
	    }
	    catch(OBJ_ADAPTER ex)
	    {
		TEST(ex.minor == 24);
		TEST(ex.completed == CompletionStatus.COMPLETED_MAYBE);
	    }

	    try
	    {
		ti.op_DATA_CONVERSION_Ex();
		TEST(false);
	    }
	    catch(DATA_CONVERSION ex)
	    {
		TEST(ex.minor == 25);
		TEST(ex.completed == CompletionStatus.COMPLETED_YES);
	    }

	    try
	    {
		ti.op_OBJECT_NOT_EXIST_Ex();
		TEST(false);
	    }
	    catch(OBJECT_NOT_EXIST ex)
	    {
		TEST(ex.minor == 26);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_TRANSACTION_REQUIRED_Ex();
		TEST(false);
	    }
	    catch(TRANSACTION_REQUIRED ex)
	    {
		TEST(ex.minor == 27);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_TRANSACTION_ROLLEDBACK_Ex();
		TEST(false);
	    }
	    catch(TRANSACTION_ROLLEDBACK ex)
	    {
		TEST(ex.minor == 28);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

	    try
	    {
		ti.op_INVALID_TRANSACTION_Ex();
		TEST(false);
	    }
	    catch(INVALID_TRANSACTION ex)
	    {
		TEST(ex.minor == 29);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }

            try
	    {
		ti.op_INV_POLICY_Ex();
		TEST(false);
	    }
	    catch(INV_POLICY ex)
	    {
		TEST(ex.minor == 30);
		TEST(ex.completed == CompletionStatus.COMPLETED_NO);
	    }
	}
    }
}
