// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;

class TestTypeCode extends TestBase
{
    public TestTypeCode()
    {
	ORB orb = ORB.init();

	try
	{
	    TCKind kind = TestStruct1Helper.type().kind();
	    TEST(kind == TCKind.tk_struct);

	    String name = TestStruct1Helper.type().name();
	    TEST(name.equals("TestStruct1"));

	    long count = TestStruct1Helper.type().member_count();
	    TEST(count == 7);

	    String name0 = TestStruct1Helper.type().member_name(0);
	    TEST(name0.equals("s"));

	    String name1 = TestStruct1Helper.type().member_name(1);
	    TEST(name1.equals("l"));

	    String name2 = TestStruct1Helper.type().member_name(2);
	    TEST(name2.equals("d"));

	    String name3 = TestStruct1Helper.type().member_name(3);
	    TEST(name3.equals("b"));

	    String name4 = TestStruct1Helper.type().member_name(4);
	    TEST(name4.equals("c"));

	    String name5 = TestStruct1Helper.type().member_name(5);
	    TEST(name5.equals("o"));

	    String name6 = TestStruct1Helper.type().member_name(6);
	    TEST(name6.equals("str"));

	    TypeCode type0 = TestStruct1Helper.type().member_type(0);
	    TEST(type0.equal(orb.get_primitive_tc(TCKind.tk_short)));

	    TypeCode type1 = TestStruct1Helper.type().member_type(1);
	    TEST(type1.equal(orb.get_primitive_tc(TCKind.tk_long)));

	    TypeCode type2 = TestStruct1Helper.type().member_type(2);
	    TEST(type2.equal(orb.get_primitive_tc(TCKind.tk_double)));

	    TypeCode type3 = TestStruct1Helper.type().member_type(3);
	    TEST(type3.equal(orb.get_primitive_tc(TCKind.tk_boolean)));

	    TypeCode type4 = TestStruct1Helper.type().member_type(4);
	    TEST(type4.equal(orb.get_primitive_tc(TCKind.tk_char)));

	    TypeCode type5 = TestStruct1Helper.type().member_type(5);
	    TEST(type5.equal(orb.get_primitive_tc(TCKind.tk_octet)));

	    TypeCode type6 = TestStruct1Helper.type().member_type(6);
	    TEST(type6.equal(orb.get_primitive_tc(TCKind.tk_string)));
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    TEST(false);
	}
	catch(org.omg.CORBA.TypeCodePackage.Bounds ex)
	{
	    TEST(false);
	}

	try
	{
	    TCKind kind = TestStruct2Helper.type().kind();
	    TEST(kind == TCKind.tk_struct);

	    String name = TestStruct2Helper.type().name();
	    TEST(name.equals("TestStruct2"));

	    long count = TestStruct2Helper.type().member_count();
	    TEST(count == 4);

	    String name0 = TestStruct2Helper.type().member_name(0);
	    TEST(name0.equals("s"));

	    TypeCode type0 = TestStruct2Helper.type().member_type(0);
	    TEST(type0.equal(TestStruct1Helper.type()));

	    String name1 = TestStruct2Helper.type().member_name(1);
	    TEST(name1.equals("a"));

	    TypeCode type1 = TestStruct2Helper.type().member_type(1);
	    TEST(type1.equal(orb.get_primitive_tc(TCKind.tk_any)));

	    String name2 = TestStruct2Helper.type().member_name(2);
	    TEST(name2.equals("da"));

	    TypeCode type2 = TestStruct2Helper.type().member_type(2);
	    TEST(type2.equal(DoubleArrayHelper.type()));

	    String name3 = TestStruct2Helper.type().member_name(3);
	    TEST(name3.equals("sa"));

	    TypeCode type3 = TestStruct2Helper.type().member_type(3);
	    TEST(type3.equal(orb.create_array_tc(
		100, orb.get_primitive_tc(TCKind.tk_string))));
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    TEST(false);
	}
	catch(org.omg.CORBA.TypeCodePackage.Bounds ex)
	{
	    TEST(false);
	}

	try
	{
	    TCKind kind = TestStruct3Helper.type().kind();
	    TEST(kind == TCKind.tk_struct);
	    
	    String name = TestStruct3Helper.type().name();
	    TEST(name.equals("TestStruct3"));
	    
	    int count = TestStruct3Helper.type().member_count();
	    TEST(count == 2);
	    
	    String name0 = TestStruct3Helper.type().member_name(0);
	    TEST(name0.equals("l"));
	    
	    TypeCode type0 = TestStruct3Helper.type().member_type(0);
	    TEST(type0.equal(orb.get_primitive_tc(TCKind.tk_long)));
	    
	    String name1 = TestStruct3Helper.type().member_name(1);
	    TEST(name1.equals("seq"));
	    
	    TypeCode type1 = TestStruct3Helper.type().member_type(1);
	    TypeCode contentType = type1.content_type();
	    TEST(contentType.equal(TestStruct3Helper.type()));
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    TEST(false);
	}
	catch(org.omg.CORBA.TypeCodePackage.Bounds ex)
	{
	    TEST(false);
	}

	try
	{
	    TCKind kind = TestStruct4Helper.type().kind();
	    TEST(kind == TCKind.tk_struct);
	    
	    String name = TestStruct4Helper.type().name();
	    TEST(name.equals("TestStruct4"));
	    
	    int count = TestStruct4Helper.type().member_count();
	    TEST(count == 2);
	    
	    String name0 = TestStruct4Helper.type().member_name(0);
	    TEST(name0.equals("a"));
	    
	    TypeCode type0 = TestStruct4Helper.type().member_type(0);
	    TEST(type0.equal(TestStruct3Helper.type()));
	    
	    String name1 = TestStruct4Helper.type().member_name(1);
	    TEST(name1.equals("b"));
	    
	    TypeCode type1 = TestStruct4Helper.type().member_type(1);
	    TypeCode contentType = type1.content_type();
	    TEST(contentType.equal(TestStruct3Helper.type()));
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    TEST(false);
	}
	catch(org.omg.CORBA.TypeCodePackage.Bounds ex)
	{
	    TEST(false);
	}

	try
	{
	    TCKind kind = TestUnion4Helper.type().kind();
	    TEST(kind == TCKind.tk_union);
	    
	    String name = TestUnion4Helper.type().name();
	    TEST(name.equals("TestUnion4"));
	    
	    int count = TestUnion4Helper.type().member_count();
	    TEST(count == 2);
	    
	    String name0 = TestUnion4Helper.type().member_name(0);
	    TEST(name0.equals("seq"));
	    
	    TypeCode type0 = TestUnion4Helper.type().member_type(0);
	    TypeCode contentType = type0.content_type();
	    TEST(contentType.equal(TestUnion4Helper.type()));
	    
	    String name1 = TestUnion4Helper.type().member_name(1);
	    TEST(name1.equals("c"));
	    
	    TypeCode type1 = TestUnion4Helper.type().member_type(1);
	    TEST(type1.equal(orb.get_primitive_tc(TCKind.tk_char)));
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    TEST(false);
	}
	catch(org.omg.CORBA.TypeCodePackage.Bounds ex)
	{
	    TEST(false);
	}

	try
	{
	    TypeCode p;

	    p = RepositoryIdHelper.type();
	    TEST(p.name().equals("RepositoryId"));

	    p = ScopedNameHelper.type();
	    TEST(p.name().equals("ScopedName"));

	    p = IdentifierHelper.type();
	    TEST(p.name().equals("Identifier"));

	    p = DefinitionKindHelper.type();
	    TEST(p.name().equals("DefinitionKind"));

	    p = IRObjectHelper.type();
	    TEST(p.name().equals("IRObject"));

	    p = VersionSpecHelper.type();
	    TEST(p.name().equals("VersionSpec"));

	    p = ContainedHelper.type();
	    TEST(p.name().equals("Contained"));

	    p = org.omg.CORBA.ContainedPackage.DescriptionHelper.type();
	    TEST(p.name().equals("Description"));

	    p = InterfaceDefSeqHelper.type();
	    TEST(p.name().equals("InterfaceDefSeq"));

	    p = ContainedSeqHelper.type();
	    TEST(p.name().equals("ContainedSeq"));

	    p = StructMemberHelper.type();
	    TEST(p.name().equals("StructMember"));

	    p = StructMemberSeqHelper.type();
	    TEST(p.name().equals("StructMemberSeq"));

	    p = UnionMemberHelper.type();
	    TEST(p.name().equals("UnionMember"));

	    p = UnionMemberSeqHelper.type();
	    TEST(p.name().equals("UnionMemberSeq"));

	    p = EnumMemberSeqHelper.type();
	    TEST(p.name().equals("EnumMemberSeq"));

	    p = ContainerHelper.type();
	    TEST(p.name().equals("Container"));

	    p = org.omg.CORBA.ContainerPackage.DescriptionHelper.type();
	    TEST(p.name().equals("Description"));

	    p = org.omg.CORBA.ContainerPackage.DescriptionSeqHelper.type();
	    TEST(p.name().equals("DescriptionSeq"));

	    p = IDLTypeHelper.type();
	    TEST(p.name().equals("IDLType"));

	    p = PrimitiveKindHelper.type();
	    TEST(p.name().equals("PrimitiveKind"));

	    p = RepositoryHelper.type();
	    TEST(p.name().equals("Repository"));

	    p = ModuleDefHelper.type();
	    TEST(p.name().equals("ModuleDef"));

	    p = ModuleDescriptionHelper.type();
	    TEST(p.name().equals("ModuleDescription"));

	    p = ConstantDefHelper.type();
	    TEST(p.name().equals("ConstantDef"));

	    p = ConstantDescriptionHelper.type();
	    TEST(p.name().equals("ConstantDescription"));

	    p = TypedefDefHelper.type();
	    TEST(p.name().equals("TypedefDef"));

	    p = TypeDescriptionHelper.type();
	    TEST(p.name().equals("TypeDescription"));

	    p = StructDefHelper.type();
	    TEST(p.name().equals("StructDef"));

	    p = UnionDefHelper.type();
	    TEST(p.name().equals("UnionDef"));

	    p = EnumDefHelper.type();
	    TEST(p.name().equals("EnumDef"));

	    p = AliasDefHelper.type();
	    TEST(p.name().equals("AliasDef"));

	    p = PrimitiveDefHelper.type();
	    TEST(p.name().equals("PrimitiveDef"));

	    p = StringDefHelper.type();
	    TEST(p.name().equals("StringDef"));

	    p = SequenceDefHelper.type();
	    TEST(p.name().equals("SequenceDef"));

	    p = ArrayDefHelper.type();
	    TEST(p.name().equals("ArrayDef"));

	    p = ExceptionDefHelper.type();
	    TEST(p.name().equals("ExceptionDef"));

	    p = ExceptionDescriptionHelper.type();
	    TEST(p.name().equals("ExceptionDescription"));

	    p = AttributeModeHelper.type();
	    TEST(p.name().equals("AttributeMode"));

	    p = AttributeDefHelper.type();
	    TEST(p.name().equals("AttributeDef"));

	    p = AttributeDescriptionHelper.type();
	    TEST(p.name().equals("AttributeDescription"));

	    p = OperationModeHelper.type();
	    TEST(p.name().equals("OperationMode"));

	    p = ParameterModeHelper.type();
	    TEST(p.name().equals("ParameterMode"));

	    p = ParameterDescriptionHelper.type();
	    TEST(p.name().equals("ParameterDescription"));

	    p = ParDescriptionSeqHelper.type();
	    TEST(p.name().equals("ParDescriptionSeq"));

	    p = ContextIdentifierHelper.type();
	    TEST(p.name().equals("ContextIdentifier"));

	    p = ContextIdSeqHelper.type();
	    TEST(p.name().equals("ContextIdSeq"));

	    p = ExceptionDefSeqHelper.type();
	    TEST(p.name().equals("ExceptionDefSeq"));

	    p = ExcDescriptionSeqHelper.type();
	    TEST(p.name().equals("ExcDescriptionSeq"));

	    p = OperationDefHelper.type();
	    TEST(p.name().equals("OperationDef"));

	    p = OperationDescriptionHelper.type();
	    TEST(p.name().equals("OperationDescription"));

	    p = RepositoryIdSeqHelper.type();
	    TEST(p.name().equals("RepositoryIdSeq"));

	    p = OpDescriptionSeqHelper.type();
	    TEST(p.name().equals("OpDescriptionSeq"));

	    p = AttrDescriptionSeqHelper.type();
	    TEST(p.name().equals("AttrDescriptionSeq"));

	    p = InterfaceDefHelper.type();
	    TEST(p.name().equals("InterfaceDef"));

	    p = org.omg.CORBA.InterfaceDefPackage.
		FullInterfaceDescriptionHelper.type();
	    TEST(p.name().equals("FullInterfaceDescription"));

	    p = InterfaceDescriptionHelper.type();
	    TEST(p.name().equals("InterfaceDescription"));
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    TEST(false);
	}
    }
}

