// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosPropertyService;

import org.omg.CosPropertyService.*;

final class PropertiesIterator extends _PropertiesIteratorImplBase
{
    private org.omg.CORBA.ORB orb_;
    private PropertyDef[] properties_;
    private int idx_;

    PropertiesIterator(org.omg.CORBA.ORB orb, PropertyDef[] properties)
    {
	orb_ = orb;
	properties_ = properties;
    }

    public void
    reset()
    {
	idx_ = 0;
    }

    public boolean
    next_one(PropertyHolder aproperty)
    {
	if(idx_ < properties_.length)
	{
	    aproperty.value = new Property(properties_[idx_].property_name,
					   properties_[idx_].property_value);
	    idx_++;
	    return true;
	}
	else
	{
	    aproperty.value = new Property("", orb_.create_any());
	    return false;
	}
    }

    public boolean
    next_n(int how_many, PropertiesHolder nproperties)
    {
	int len = properties_.length;
	int num = len - idx_ < how_many ? len - idx_ : how_many;

	nproperties.value = new Property[num];

	for(int i = 0 ; i < num ; i++)
	{
	    nproperties.value[i] =
		new Property(properties_[idx_].property_name,
			     properties_[idx_].property_value);
	    idx_++;
	}

	if(how_many > num)
	    return false;
	else
	    return true;
    }

    public void
    destroy()
    {
	orb_.disconnect(this);
    }
}
