// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosPropertyService;

import org.omg.CosPropertyService.*;

final class PropertyNamesIterator extends _PropertyNamesIteratorImplBase
{
    private org.omg.CORBA.ORB orb_;
    private String[] names_;
    private int idx_;

    PropertyNamesIterator(org.omg.CORBA.ORB orb, String[] names)
    {
	orb_ = orb;
	names_ = names;
    }

    public void
    reset()
    {
	idx_ = 0;
    }

    public boolean
    next_one(org.omg.CORBA.StringHolder property_name)
    {
	if(idx_ < names_.length)
	{
	    property_name.value = names_[idx_++];
	    return true;
	}
	else
	{
	    property_name.value = "";
	    return false;
	}
    }

    public boolean
    next_n(int how_many, PropertyNamesHolder property_names)
    {
	int len = names_.length;
	int num = len - idx_ < how_many ? len - idx_ : how_many;

	property_names.value = new String[num];
	System.arraycopy(names_, idx_, property_names.value, 0, num);
	idx_ += num;

	if(how_many > num)
	    return false;
	else
	    return true;
    }

    public void
    destroy()
    {
	orb_.disconnect(this);
    }
}
