// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosPropertyService;

import org.omg.CosPropertyService.*;

final public class PropertySetDef extends _PropertySetDefImplBase
{
    //
    // The ORB
    //
    private org.omg.CORBA.ORB orb_;

    //
    // Any with typecode tk_void
    //
    private static org.omg.CORBA.Any any_;

    //
    // My PropertyDefs
    //
    private java.util.Hashtable propertyTab_;

    //
    // List of allowed TypeCodes
    //
    private org.omg.CORBA.TypeCode[] allowedTypes_;

    //
    // List of allowed properties
    //
    private PropertyDef[] allowedProperties_;

    public PropertySetDef(org.omg.CORBA.ORB orb)
    {
	orb_ = orb;
        propertyTab_ = new java.util.Hashtable();
    }

    public PropertySetDef(org.omg.CORBA.ORB orb,
			  org.omg.CORBA.TypeCode[] allowed_property_types,
			  PropertyDef[] allowed_property_defs)
    {
	orb_ = orb;
        propertyTab_ = new java.util.Hashtable();
	allowedTypes_ = allowed_property_types;
	allowedProperties_ = allowed_property_defs;
    }

    public PropertySetDef(org.omg.CORBA.ORB orb,
			  PropertyDef[] initial_property_defs)
    {
	orb_ = orb;

        //
        // Optimize hashtable by using an initial load factor of 0.5
        //
        propertyTab_ = initial_property_defs.length != 0 ?
            new java.util.Hashtable(2 * initial_property_defs.length) :
            new java.util.Hashtable();

	for(int i = 0 ; i < initial_property_defs.length ; i++)
	    propertyTab_.put(initial_property_defs[i].property_name,
			     initial_property_defs[i]);
    }

    public void
    define_property(String property_name, org.omg.CORBA.Any property_value)
        throws InvalidPropertyName,
               ConflictingProperty,
               UnsupportedTypeCode,
               UnsupportedProperty,
               ReadOnlyProperty
    {
	try
	{
	    define_property_with_mode(property_name, property_value,
				      PropertyModeType.undefined);
	}
	catch(UnsupportedMode ex)
	{
	    // This exception can't be thrown in this context
	    throw new RuntimeException();
	}
    }

    public void
    define_properties(Property[] nproperties)
	throws MultipleExceptions
    {
	PropertyDef[] p = new PropertyDef[nproperties.length];
	for(int i = 0 ; i < nproperties.length ; i++)
	    p[i] = new PropertyDef(nproperties[i].property_name,
				   nproperties[i].property_value,
				   PropertyModeType.undefined);

	define_properties_with_modes(p);
    }

    public int
    get_number_of_properties()
    {
	return propertyTab_.size();
    }

    public void
    get_all_property_names(int how_many,
                           PropertyNamesHolder property_names,
                           PropertyNamesIteratorHolder rest)
    {
	int i;
 
	int len = propertyTab_.size();
	int num = len < how_many ? len : how_many;
 
        property_names.value = new String[num];
 
        java.util.Enumeration e = propertyTab_.keys();
        for(i = 0 ; i < num ; i++)
	    property_names.value[i] = (String)(e.nextElement());
 
        if(how_many < len)
        {
            String[] rem = new String[len - how_many];
 
            for(i = 0 ; i < len - how_many ; i++)
		rem[i] = (String)(e.nextElement());
 
            rest.value = new PropertyNamesIterator(orb_, rem);
        }
    }

    public org.omg.CORBA.Any
    get_property_value(String property_name)
        throws PropertyNotFound,
               InvalidPropertyName
    {
	if(property_name.length() == 0)
	    throw new InvalidPropertyName();

	PropertyDef p = (PropertyDef)(propertyTab_.get(property_name));
	if(p == null)
	    throw new PropertyNotFound();

	return p.property_value;
    }

    public boolean
    get_properties(String[] property_names, PropertiesHolder nproperties)
    {
	//
	// Assume that all names are valid (to set default vector length)
	//
	java.util.Vector properties =
	    new java.util.Vector(property_names.length);
	boolean allNamesAreValid = true;

	for(int i = 0 ; i < property_names.length ; i++)
	{
	    PropertyDef p = (PropertyDef)(propertyTab_.get(property_names[i]));
	    if(p != null)
		properties.addElement(new Property(p.property_name,
						   p.property_value));
	    else
	    {
                //
                // Create property with value tk_void
                //
		if(any_ == null)
		{
		    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
		    any_ = orb.create_any();
		    any_.type(orb.get_primitive_tc(
			org.omg.CORBA.TCKind.tk_void));
		}

		properties.addElement(new Property(property_names[i], any_));
		allNamesAreValid = false;
	    }
	}

	//
	// Copy property vector to array with results
	//
	nproperties.value = new Property[properties.size()];
	properties.copyInto(nproperties.value);

	return allNamesAreValid;
    }

    public void
    get_all_properties(int how_many, PropertiesHolder nproperties,
                       PropertiesIteratorHolder rest)
    {
	int i;
 
	int len = propertyTab_.size();
	int num = len < how_many ? len : how_many;
 
        nproperties.value = new Property[num];
 
        java.util.Enumeration e = propertyTab_.elements();
        for(i = 0 ; i < num ; i++)
	{
	    PropertyDef pd = (PropertyDef)(e.nextElement());
	    nproperties.value[i] =
		new Property(pd.property_name, pd.property_value);
	}
 
        if(how_many < len)
        {
            PropertyDef[] rem = new PropertyDef[len - how_many];
 
            for(i = 0 ; i < len - how_many ; i++)
		rem[i] = (PropertyDef)(e.nextElement());
 
            rest.value = new PropertiesIterator(orb_, rem);
        }
    }

    public void
    delete_property(String property_name)
        throws PropertyNotFound,
               InvalidPropertyName,
               FixedProperty
   {
       if(property_name.length() == 0)
	   throw new InvalidPropertyName();

       PropertyDef p = (PropertyDef)(propertyTab_.get(property_name));
       if(p == null)
	   throw new PropertyNotFound();

       if(p.property_mode == PropertyModeType.fixed_normal ||
	  p.property_mode == PropertyModeType.fixed_readonly)
	   throw new FixedProperty();

       propertyTab_.remove(p.property_name);
   }

    public void
    delete_properties(String[] property_names)
        throws MultipleExceptions
    {
	//
	// Table with exceptions
	//
	java.util.Vector exceptionVec = new java.util.Vector();

	//
	// Table for remaining (fixed) properties
	//
	java.util.Hashtable fixedTab = new java.util.Hashtable();

	for(int i = 0 ; i < property_names.length ; i++)
	{
	    if(property_names[i].length() == 0)
	    {
		PropertyException ex = new PropertyException(
		    ExceptionReason.invalid_property_name, property_names[i]);
		exceptionVec.addElement(ex);

		continue;
	    }

	    PropertyDef p = (PropertyDef)(propertyTab_.get(property_names[i]));
	    if(p == null)
	    {
		PropertyException ex = new PropertyException(
		    ExceptionReason.property_not_found, property_names[i]);
		exceptionVec.addElement(ex);

		continue;
	    }

	    if(p.property_mode == PropertyModeType.fixed_normal ||
	       p.property_mode == PropertyModeType.fixed_readonly)
	    {
		PropertyException ex = new PropertyException(
		    ExceptionReason.fixed_property, property_names[i]);
		exceptionVec.addElement(ex);

		continue;
	    }

	    fixedTab.put(p.property_name, p);
	}

	propertyTab_ = fixedTab;

	//
	// Check for exceptions
	//
	if(!exceptionVec.isEmpty())
	{
	    PropertyException[] ex =
		new PropertyException[exceptionVec.size()];
	    exceptionVec.copyInto(ex);

	    throw new MultipleExceptions(ex);
	}
    }

    public boolean
    delete_all_properties()
    {
	//
	// Table with remaining (fixed) properties
	//
	java.util.Hashtable fixedTab = new java.util.Hashtable();

	java.util.Enumeration e = propertyTab_.elements();
	while(e.hasMoreElements())
	{
	    PropertyDef p = (PropertyDef)(e.nextElement());
	    if(p.property_mode == PropertyModeType.fixed_normal ||
	       p.property_mode == PropertyModeType.fixed_readonly)
		fixedTab.put(p.property_name, p);
	}

	propertyTab_ = fixedTab;

	return propertyTab_.size() == 0;
    }

    public boolean
    is_property_defined(String property_name)
        throws InvalidPropertyName
    {
	if(property_name.length() == 0)
	    throw new InvalidPropertyName();

	return propertyTab_.containsKey(property_name);
    }

    public void
    get_allowed_property_types(PropertyTypesHolder property_types)
    {
	property_types.value = allowedTypes_;
    }

    public void
    get_allowed_properties(PropertyDefsHolder property_defs)
    {
	property_defs.value = allowedProperties_;
    }

    public void
    define_property_with_mode(String property_name,
                              org.omg.CORBA.Any property_value,
                              PropertyModeType property_mode)
        throws InvalidPropertyName,
               ConflictingProperty,
               UnsupportedTypeCode,
               UnsupportedProperty,
               UnsupportedMode,
               ReadOnlyProperty
    {
	//
	// Check name, type and property
	//
	check(property_name, property_value, property_mode);

	PropertyDef p = (PropertyDef)(propertyTab_.get(property_name));

	//
	// Overwrite existing property if allowed
	//
	if(p != null)
	{
	    if(p.property_mode == PropertyModeType.read_only ||
	       p.property_mode == PropertyModeType.fixed_readonly)
		throw new ReadOnlyProperty();

	    //
	    // Check type
	    //
	    if(!p.property_value.type().equal(property_value.type()))
		throw new ConflictingProperty();

	    //
	    // Set new value
	    //
	    p.property_value = property_value;
	}
	else
	    propertyTab_.put(property_name,
			     new PropertyDef(property_name, property_value,
					     property_mode));
    }

    public void
    define_properties_with_modes(PropertyDef[] property_defs)
        throws MultipleExceptions
    {
	java.util.Vector exceptionVec = new java.util.Vector();

	//
	// Check name, type and property
	//
	for(int i = 0 ; i < property_defs.length ; i++)
	{
	    try
	    {
		check(property_defs[i].property_name,
		      property_defs[i].property_value,
		      property_defs[i].property_mode);
	    }
	    catch(InvalidPropertyName ex)
	    {
		PropertyException e = new PropertyException(
		    ExceptionReason.invalid_property_name,
		    property_defs[i].property_name);
		exceptionVec.addElement(e);
 
		continue;
	    }
	    catch(UnsupportedTypeCode ex)
	    {
		PropertyException e = new PropertyException(
		    ExceptionReason.unsupported_type_code,
		    property_defs[i].property_name);
		exceptionVec.addElement(e);

		continue;
	    }
	    catch(UnsupportedProperty ex)
	    {
		PropertyException e = new PropertyException(
		    ExceptionReason.unsupported_property,
		    property_defs[i].property_name);
		exceptionVec.addElement(e);

		continue;
	    }

	    PropertyDef p = (PropertyDef)
		(propertyTab_.get(property_defs[i].property_name));

	    //
	    // Overwrite existing property if allowed
	    //
	    if(p != null)
	    {
		if(p.property_mode == PropertyModeType.read_only ||
		   p.property_mode == PropertyModeType.fixed_readonly)
		{
		    PropertyException ex =
			new PropertyException(
			    ExceptionReason.read_only_property,
			    property_defs[i].property_name);
		    exceptionVec.addElement(ex);

		    continue;
		}

		//
		// Check type
		//
		if(!p.property_value.type().equal(
		   property_defs[i].property_value.type()))
		{
		    PropertyException ex =
			new PropertyException(
			    ExceptionReason.conflicting_property,
			    property_defs[i].property_name);
		    exceptionVec.addElement(ex);

		    continue;
		}

		//
		// Set new value
		//
		p.property_value = property_defs[i].property_value;
	    }
	    else
		propertyTab_.put(
		    property_defs[i].property_name,
		    new PropertyDef(property_defs[i].property_name,
				    property_defs[i].property_value,
				    property_defs[i].property_mode));
	}

	//
	// Check for exceptions
	//
	if(!exceptionVec.isEmpty())
	{
	    PropertyException[] ex =
		new PropertyException[exceptionVec.size()];
	    exceptionVec.copyInto(ex);

	    throw new MultipleExceptions(ex);
	}
    }

    public PropertyModeType
    get_property_mode(String property_name)
        throws PropertyNotFound,
               InvalidPropertyName
    {
	if(property_name.length() == 0)
	    throw new InvalidPropertyName();

	PropertyDef p = (PropertyDef)(propertyTab_.get(property_name));
	if(p == null)
	    throw new PropertyNotFound();

	return p.property_mode;
    }

    public boolean
    get_property_modes(String[] property_names,
                       PropertyModesHolder property_modes)
    {
	boolean allDefined = true;
	property_modes.value = new PropertyMode[property_names.length];

	for(int i = 0 ; i < property_names.length ; i++)
	{
	    PropertyDef p = (PropertyDef)(propertyTab_.get(property_names[i]));
	    if(p != null)
		property_modes.value[i] = new PropertyMode(p.property_name,
							   p.property_mode);
	    else
	    {
		property_modes.value[i] =
		    new PropertyMode(property_names[i],
				     PropertyModeType.undefined);
		allDefined = false;
	    }
	}

	return allDefined;
    }

    public void
    set_property_mode(String property_name, PropertyModeType property_mode)
        throws InvalidPropertyName,
               PropertyNotFound,
               UnsupportedMode
    {
	if(property_name.length() == 0)
	    throw new InvalidPropertyName();

        PropertyDef p = (PropertyDef)(propertyTab_.get(property_name));
	if(p == null)
	    throw new PropertyNotFound();

	if(property_mode == PropertyModeType.undefined)
	    throw new UnsupportedMode();

	p.property_mode = property_mode;
    }

    public void
    set_property_modes(PropertyMode[] property_modes)
        throws MultipleExceptions
    {
	java.util.Vector exceptionVec = new java.util.Vector();

	for(int i = 0 ; i < property_modes.length ; i++)
	{
	    if(property_modes[i].property_name.length() == 0)
	    {
		PropertyException ex = new PropertyException(
		    ExceptionReason.invalid_property_name,
		    property_modes[i].property_name);
		exceptionVec.addElement(ex);

		continue;
	    }

	    PropertyDef p = (PropertyDef)
		(propertyTab_.get(property_modes[i].property_name));
	    if(p == null)
	    {
		PropertyException ex =
		    new PropertyException(ExceptionReason.property_not_found,
					  property_modes[i].property_name);
		exceptionVec.addElement(ex);

		continue;
	    }

	    if(property_modes[i].property_mode == PropertyModeType.undefined)
	    {
		PropertyException ex =
		    new PropertyException(ExceptionReason.unsupported_mode,
					  property_modes[i].property_name);
		exceptionVec.addElement(ex);

		continue;
	    }

	    p.property_mode = property_modes[i].property_mode;
	}

	//
	// Check for exceptions
	//
	if(!exceptionVec.isEmpty())
	{
	    PropertyException[] ex =
		new PropertyException[exceptionVec.size()];
	    exceptionVec.copyInto(ex);

	    throw new MultipleExceptions(ex);
	}
    }

    //
    // Check name, type and property
    //
    private void
    check(String property_name, org.omg.CORBA.Any property_value,
	  PropertyModeType property_mode)
        throws InvalidPropertyName,
               UnsupportedTypeCode,
               UnsupportedProperty
    {
	int i;

	//
	// Check name
	//
	if(property_name.length() == 0)
	    throw new InvalidPropertyName();

	//
	// Check if property is allowed
	//
	if(allowedProperties_ != null)
	{
	    boolean propertyIsAllowed = false;
	    for(i = 0 ; i < allowedProperties_.length ; i++)
	    {
		if(allowedProperties_[i].property_name.equals(property_name))
		{
		    //
		    // Check if the type matches
		    //
		    if(!allowedProperties_[i].property_value.type().
		       equal(property_value.type()))
			throw new UnsupportedTypeCode();
		    
		    //
		    // Mode is only relevant if not undefined
		    //
		    if(property_mode != PropertyModeType.undefined)
		    {
			if(allowedProperties_[i].property_mode !=
			   property_mode)
			    continue;
		    }

		    propertyIsAllowed = true;
		    break;
		}
	    }

	    if(!propertyIsAllowed)
		throw new UnsupportedProperty();
	}

	//
	// Check if TypeCode is allowed
	//
	if(allowedTypes_ != null)
	{
	    boolean typeIsAllowed = false;
	    for(i = 0 ; i < allowedTypes_.length ; i++)
	    {
		if(allowedTypes_[i].equal(property_value.type()))
		{
		    typeIsAllowed = true;
		    break;
		}
	    }

	    if(!typeIsAllowed)
		throw new UnsupportedTypeCode();
	}
    }
}
