// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosPropertyService;

import org.omg.CosPropertyService.*;

final public class PropertySetDefFactory extends _PropertySetDefFactoryImplBase
{
    private org.omg.CORBA.ORB orb_;

    public PropertySetDefFactory(org.omg.CORBA.ORB orb)
    {
	orb_ = orb;
    }

    public org.omg.CosPropertyService.PropertySetDef
    create_propertysetdef()
    {
	return new PropertySetDef(orb_);
    }

    public org.omg.CosPropertyService.PropertySetDef
    create_constrained_propertysetdef(
	org.omg.CORBA.TypeCode[] allowed_property_types,
	PropertyDef[] allowed_property_defs)
        throws ConstraintNotSupported
    {
	return new PropertySetDef(orb_,
				  allowed_property_types,
				  allowed_property_defs);
    }

    public org.omg.CosPropertyService.PropertySetDef
    create_initial_propertysetdef(PropertyDef[] initial_property_defs)
	throws MultipleExceptions
    {
	//
	// Table with exceptions
	//
	java.util.Vector exceptionVec = new java.util.Vector();

	for(int i = 0 ; i < initial_property_defs.length ; i++)
	{
	    if(initial_property_defs[i].property_name.length() == 0)
	    {
		PropertyException ex = new PropertyException(
		    ExceptionReason.invalid_property_name,
		    initial_property_defs[i].property_name);
		exceptionVec.addElement(ex);

		continue;
	    }
	}

	//
	// Check for exceptions
	//
	if(!exceptionVec.isEmpty())
	{
	    PropertyException[] ex =
		new PropertyException[exceptionVec.size()];
	    exceptionVec.copyInto(ex);

	    throw new MultipleExceptions(ex);
	}

	return new PropertySetDef(orb_, initial_property_defs);
    }
}
