// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CosPropertyService;

import org.omg.CosPropertyService.*;

final public class PropertySetFactory extends _PropertySetFactoryImplBase
{
    private org.omg.CORBA.ORB orb_;

    public PropertySetFactory(org.omg.CORBA.ORB orb)
    {
	orb_ = orb;
    }

    public org.omg.CosPropertyService.PropertySet
    create_propertyset()
    {
	return new PropertySetDef(orb_);
    }

    public org.omg.CosPropertyService.PropertySet
    create_constrained_propertyset(
	org.omg.CORBA.TypeCode[] allowed_property_types,
	Property[] allowed_properties)
            throws ConstraintNotSupported
    {
	PropertyDef[] p = new PropertyDef[allowed_properties.length];
	for(int i = 0 ; i < allowed_properties.length ; i++)
	    p[i] = new PropertyDef(allowed_properties[i].property_name,
				   allowed_properties[i].property_value,
				   PropertyModeType.normal);

	return new PropertySetDef(orb_, allowed_property_types, p);
    }

    public org.omg.CosPropertyService.PropertySet
    create_initial_propertyset(Property[] initial_properties)
	throws MultipleExceptions
    {
	//
	// Table with exceptions
	//
	java.util.Vector exceptionVec = new java.util.Vector();

	PropertyDef[] p = new PropertyDef[initial_properties.length];

	for(int i = 0 ; i < initial_properties.length ; i++)
	{
	    if(initial_properties[i].property_name.length() == 0)
	    {
		PropertyException ex = new PropertyException(
		    ExceptionReason.invalid_property_name,
		    initial_properties[i].property_name);
		exceptionVec.addElement(ex);

		continue;
	    }

	    p[i] = new PropertyDef(initial_properties[i].property_name,
				   initial_properties[i].property_value,
				   PropertyModeType.normal);
	}

	//
	// Check for exceptions
	//
	if(!exceptionVec.isEmpty())
	{
	    PropertyException[] ex =
		new PropertyException[exceptionVec.size()];
	    exceptionVec.copyInto(ex);

	    throw new MultipleExceptions(ex);
	}

	return new PropertySetDef(orb_, p);
    }
}
