// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package com.ooc.CosPropertyService;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Server
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
	    //
	    // Set program name
	    //
	    String progName = "com.ooc.CosPropertyService.Server";

	    //
	    // Create ORB
	    //
	    ORB orb = ORB.init(args, props);
 
	    //
	    // Filter options
	    //
	    args = ((com.ooc.CORBA.ORB)orb).filter_options(args);

	    //
	    // Resolve the service object if available as an initial
	    // reference.
	    //
	    String service = "PropertyService";
	    org.omg.CORBA.Object serviceObject = null;
	    try
	    {
		serviceObject = orb.resolve_initial_references(service);
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName e)
	    {
	    }

	    //
	    // Set the IIOP port based on the port defined in the IIOP profile
	    // of the service object (if it exists). Then create the BOA.
	    //
	    com.ooc.CORBA.BOA.set_iiop_port_from_object(serviceObject);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);
	    
	    //
	    // Filter options
	    //
	    args = ((com.ooc.CORBA.BOA)boa).filter_options(args);
	    
	    //
	    // Get options
	    //
	    boolean ior = false;
	    
	    for(int i = 0 ; i < args.length && args[i].startsWith("-") ; i++)
	    {
		if(args[i].equals("--help") ||
		   args[i].equals("-h"))
		{
		    usage(progName);
		    System.exit(0);
		}
		else if(args[i].equals("--version") ||
			args[i].equals("-v"))
		{
		    System.err.println("Property Service " +
				       com.ooc.CORBA.Version.version);
		    System.exit(0);
		}
		else if(args[i].equals("--ior") ||
			args[i].equals("-i"))
		{
		    ior = true;
		}
		else
		{
		    System.out.println(progName + ": Unknown option `" +
				       args[i] + "'\n");
		    usage(progName);
		    System.exit(1);
		}
	    }

	    //
	    // Create factory
	    //
	    PropertySetDefFactory p = new PropertySetDefFactory(orb);
	    ((com.ooc.CORBA.ORB)orb).connect(p,
					     "DefaultPropertySetDefFactory");

	    //
	    // Print IOR on standard output
	    //
	    if(ior)
	    {
		String s = orb.object_to_string(p);
		System.out.println(s);
	    }

	    //
	    // Run implementation
	    //
	    boa.impl_is_ready(null);
	}
	catch(SystemException ex)
	{
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }

    static void
    usage(String progName)
    {
	System.err.println("Usage:");
        System.err.println(progName + " [options]\n" +
                           "\n" +
                           "Options:\n" +
                           "-h, --help             " +
                           "Show this message.\n" +
                           "-v, --version          " +
                           "Show Property Service version.\n" +
                           "-i, --ior              " +
                           "Print IOR on standard output.");
    }
}
