// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosPropertyService.*;
import java.util.*;

public class Test
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	//
	// Create ORB and BOA
	//
	ORB orb = ORB.init(args, props);
	BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	PropertySetDefFactory factory =
	    new com.ooc.CosPropertyService.PropertySetDefFactory(orb);

	//
	// Run test with unconstrained PropertySetDef
	//
	System.out.println("Running tests with unconstrained PropertySet");
	testUnconstrained(orb, factory.create_propertysetdef());

	//
	// Set up PropertySetDef constraints, only tk_string is allowed
	//
	TypeCode[] allowedTypes = new TypeCode[1];
	allowedTypes[0] = orb.get_primitive_tc(TCKind.tk_string);
	PropertyDef[] allowedProperties = new PropertyDef[3];
	Any any = orb.create_any();
	any.insert_string("property_value");
	allowedProperties[0] =
	    new PropertyDef("read_only", any, PropertyModeType.read_only);
	allowedProperties[1] =
	    new PropertyDef("fixed_normal", any,
			    PropertyModeType.fixed_normal);
	allowedProperties[2] =
	    new PropertyDef("fixed_readonly", any,
			    PropertyModeType.fixed_readonly);
	System.out.println("Running tests with constrained PropertySet");
	try
	{
	    testConstrained(orb, factory.create_constrained_propertysetdef(
		allowedTypes, allowedProperties));
	}
	catch(ConstraintNotSupported ex)
	{
	    throw new TestException();
	}

	//
	// Set up initial PropertySetDef
	//
	any.insert_string("initial_property_value");
	PropertyDef[] initialProperties = new PropertyDef[1];
	initialProperties[0] = new PropertyDef("initial_property", any,
					       PropertyModeType.normal);
	System.out.println("Running tests with initial PropertySet");
	try
	{
	    testInitial(orb, factory.create_initial_propertysetdef(
		initialProperties));
	}
	catch(MultipleExceptions ex)
	{
	    throw new TestException();
	}
    }

    //
    // Tests for unconstrained PropertySetDef
    //
    static void testUnconstrained(ORB orb, PropertySetDef set)
    {
	int i, j;

	{
	    System.out.print("  Testing define_property()... ");

	    for(i = 0 ; i < 10 ; i++)
	    {
		Any any = orb.create_any();
		any.insert_long(i);

		try
		{
		    set.define_property("property_" + i, any);
		}
		catch(ReadOnlyProperty ex)
		{
		    throw new TestException();
		}
		catch(ConflictingProperty ex)
		{
		    throw new TestException();
		}
		catch(UnsupportedProperty ex)
		{
		    throw new TestException();
		}
		catch(UnsupportedTypeCode ex)
		{
		    throw new TestException();
		}
		catch(InvalidPropertyName ex)
		{
		    throw new TestException();
		}
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing define_properties()... ");

	    Property[] nproperties = new Property[10];

	    for(i = 10 ; i < 20 ; i++)
	    {
		Any any = orb.create_any();
		any.insert_long(i);
		nproperties[i - 10] = new Property("property_" + i, any);
	    }

	    try
	    {
		set.define_properties(nproperties);
	    }
	    catch(MultipleExceptions ex)
	    {
		throw new TestException();
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_all_property_names() " +
			     "without iterator... ");

	    PropertyNamesHolder nh = new PropertyNamesHolder();
	    PropertyNamesIteratorHolder ih = new PropertyNamesIteratorHolder();

	    int n = set.get_number_of_properties();
	    set.get_all_property_names(n, nh, ih);
	    String[] names = nh.value;

	    if(names.length != n)
		throw new TestException();

	    java.util.Vector v = new java.util.Vector(n);
	    for(i = 0 ; i < n ; i++)
		v.addElement("property_" + i);

	    //
	    // Check if each property name exists only once
	    //
	    for(i = 0 ; i < n ; i++)
	    {
		if(!v.contains(names[i]))
		   throw new TestException();

		v.removeElement(names[i]);
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_all_property_names() " +
			     "with iterator... ");

	    PropertyNamesHolder nh = new PropertyNamesHolder();
	    PropertyNamesIteratorHolder ih = new PropertyNamesIteratorHolder();

	    //
	    // Get one name without iterator
	    //
	    set.get_all_property_names(1, nh, ih);
	    if(nh.value.length != 1)
		throw new TestException();

	    int n = set.get_number_of_properties();

	    String[] names = new String[n];
	    names[0] = nh.value[0];

	    //
	    // Get remaining names with iterator
	    //
	    StringHolder h = new StringHolder();
	    i = 1;
	    while(ih.value.next_one(h))
		names[i++] = h.value;

	    java.util.Vector v = new java.util.Vector(n);
	    for(i = 0 ; i < n ; i++)
		v.addElement("property_" + i);

	    //
	    // Check if each property name exists only once
	    //
	    for(i = 0 ; i < n ; i++)
	    {
		if(!v.contains(names[i]))
		   throw new TestException();

		v.removeElement(names[i]);
	    }

	    ih.value.destroy();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_property_value()... ");

	    int n = set.get_number_of_properties();
	    for(i = 0 ; i < n ; i++)
	    {
		Any any;

		try
		{
		    any = set.get_property_value("property_" + i);
		}
		catch(InvalidPropertyName ex)
		{
		    throw new TestException();
		}
		catch(PropertyNotFound ex)
		{
		    throw new TestException();
		}

		int value = any.extract_long();
		if(value != i)
		    throw new TestException();
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_properties()... ");

	    int n = set.get_number_of_properties();
	    String[] names = new String[n];
	    for(i = 0 ; i < n ; i++)
		names[i] = "property_" + i;

	    PropertiesHolder nproperties = new PropertiesHolder();
	    set.get_properties(names, nproperties);

	    java.util.Vector vs = new java.util.Vector(n);
	    java.util.Vector vi = new java.util.Vector(n);
	    for(i = 0 ; i < n ; i++)
	    {
		vs.addElement("property_" + i);
		vi.addElement(new Integer(i));
	    }

	    //
	    // Check if each property name exists only once
	    //
	    int match = 0;
	    for(i = 0 ; i < n ; i++)
	    {
		for(j = 0 ; j < n ; j++)
		{
		    String s = nproperties.value[i].property_name;
		    if(!s.equals((String)(vs.elementAt(j))))
			continue;

		    Any any = nproperties.value[i].property_value;
		    int value = any.extract_long();
		    if(value != (((Integer)(vi.elementAt(j))).intValue()))
			continue;

		    //
		    // Mark current element as invalid, it has passed the test
		    //
		    vs.setElementAt("", j);
		    vi.setElementAt(new Integer(-1), j);

		    match++;
		}
	    }

	    if(match != n)
		throw new TestException();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_all_properties() " +
			     "without iterator... ");

	    PropertiesHolder ph = new PropertiesHolder();
	    PropertiesIteratorHolder ih = new PropertiesIteratorHolder();
	    int n = set.get_number_of_properties();
	    set.get_all_properties(n, ph, ih);
	    if(ph.value.length != n)
		throw new TestException();

	    java.util.Vector vs = new java.util.Vector(n);
	    java.util.Vector vi = new java.util.Vector(n);
	    for(i = 0 ; i < n ; i++)
	    {
		vs.addElement("property_" + i);
		vi.addElement(new Integer(i));
	    }

	    //
	    // Check if each property name exists only once
	    //
	    int match = 0;
	    for(i = 0 ; i < n ; i++)
	    {
		for(j = 0 ; j < n ; j++)
		{
		    String s = ph.value[i].property_name;
		    if(!s.equals((String)(vs.elementAt(j))))
			continue;

		    Any any = ph.value[i].property_value;
		    int value = any.extract_long();
		    if(value != (((Integer)(vi.elementAt(j))).intValue()))
			continue;

		    //
		    // Mark current element as invalid, it has passed the test
		    //
		    vs.setElementAt("", j);
		    vi.setElementAt(new Integer(-1), j);

		    match++;
		}
	    }

	    if(match != n)
		throw new TestException();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_all_properties() " +
			     "with iterator... ");

	    PropertiesHolder ph = new PropertiesHolder();
	    PropertiesIteratorHolder ih = new PropertiesIteratorHolder();

            //
            // Get one property without iterator
            //
 	    set.get_all_properties(1, ph, ih);
	    if(ph.value.length != 1)
		throw new TestException();

	    int n = set.get_number_of_properties();
	    Property[] properties = new Property[n];
	    properties[0] = ph.value[0];

	    //
	    // Get remaining properties with iterator
	    //
            PropertyHolder h = new PropertyHolder();
            i = 1;
            while(ih.value.next_one(h))
                properties[i++] = h.value;
 
	    java.util.Vector vs = new java.util.Vector(n);
	    java.util.Vector vi = new java.util.Vector(n);
	    for(i = 0 ; i < n ; i++)
	    {
		vs.addElement("property_" + i);
		vi.addElement(new Integer(i));
	    }

	    //
	    // Check if each property name exists only once
	    //
	    int match = 0;
	    for(i = 0 ; i < n ; i++)
	    {
		for(j = 0 ; j < n ; j++)
		{
		    String s = properties[i].property_name;
		    if(!s.equals((String)(vs.elementAt(j))))
			continue;

		    Any any = properties[i].property_value;
		    int value = any.extract_long();
		    if(value != (((Integer)(vi.elementAt(j))).intValue()))
			continue;

		    //
		    // Mark current element as invalid, it has passed the test
		    //
		    vs.setElementAt("", j);
		    vi.setElementAt(new Integer(-1), j);

		    match++;
		}
	    }

	    if(match != n)
		throw new TestException();

	    ih.value.destroy();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing is_property_defined()... ");

	    int n = set.get_number_of_properties();
	    for(i = 0 ; i < n ; i++)
	    {
		String name = "property_" + i;

		try
		{
		    if(!set.is_property_defined(name))
			throw new TestException();
		}
		catch(InvalidPropertyName ex)
		{
		    throw new TestException();
		}
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing delete_property()... ");

	    //
	    // Delete first 5 properties, 15 remain
	    //
	    for(i = 0 ; i < 5 ; i++)
	    {
		String name = "property_" + i;

		try
		{
		    set.delete_property(name);
		}
		catch(InvalidPropertyName ex)
		{
		    throw new TestException();
		}
		catch(PropertyNotFound ex)
		{
		    throw new TestException();
		}
		catch(FixedProperty ex)
		{
		    throw new TestException();
		}
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing delete_properties()... ");

	    //
	    // Delete next 10 properties, 5 remain
	    //
	    String[] names = new String[10];
	    for(i = 5 ; i < 15 ; i++)
		names[i - 5] = "property_" + i;

	    try
	    {
		set.delete_properties(names);
	    }
	    catch(MultipleExceptions ex)
	    {
		throw new TestException();
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing delete_all_properties()... ");

	    //
	    // 10 properties remain and are deleted now
	    //
	    if(!set.delete_all_properties())
		throw new TestException();

	    if(set.get_number_of_properties() != 0)
		throw new TestException();

	    System.out.println("OK!");
	}
    }

    //
    // Tests for constrained PropertySetDef
    //
    static void testConstrained(ORB orb, PropertySetDef set)
    {
	Any any = orb.create_any();
	boolean except;

	{
	    System.out.print("  Testing get_allowed_property_types()... ");

	    PropertyTypesHolder types = new PropertyTypesHolder();
	    set.get_allowed_property_types(types);

	    if(types.value.length != 1)
		throw new TestException();

	    if(!types.value[0].equal(orb.get_primitive_tc(TCKind.tk_string)))
		throw new TestException();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_allowed_properties()... ");

	    PropertyDefsHolder properties = new PropertyDefsHolder();
	    set.get_allowed_properties(properties);

	    if(properties.value.length != 3)
		throw new TestException();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing define_property_with_mode()... ");

	    //
	    // Try to add allowed properties
	    //
	    any.insert_string("property_value");
	    try
	    {
		set.define_property_with_mode("fixed_normal", any,
					      PropertyModeType.fixed_normal);
		set.define_property_with_mode("read_only", any,
					      PropertyModeType.read_only);
		set.define_property_with_mode("fixed_readonly", any,
					      PropertyModeType.fixed_readonly);
	    }
	    catch(ReadOnlyProperty ex)
	    {
		throw new TestException();
	    }
	    catch(ConflictingProperty ex)
	    {
		throw new TestException();
	    }
	    catch(UnsupportedProperty ex)
	    {
		throw new TestException();
	    }
	    catch(UnsupportedTypeCode ex)
	    {
		throw new TestException();
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }
	    catch(UnsupportedMode ex)
	    {
		throw new TestException();
	    }

	    //
	    // Try to change readonly property
	    //
	    any.insert_string("property_value");
	    except = false;
	    try
	    {
		set.define_property("read_only", any);
	    }
	    catch(ReadOnlyProperty ex)
	    {
		// This exception must be thrown
		except = true;
	    }
	    catch(ConflictingProperty ex)
	    {
		throw new TestException();
	    }
	    catch(UnsupportedProperty ex)
	    {
		throw new TestException();
	    }
	    catch(UnsupportedTypeCode ex)
	    {
		throw new TestException();
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }

            if(!except)
                throw new TestException();

	    //
	    // Try to add illegal TypeCode
	    //
	    any.insert_long(1);
	    except = false;
	    try
	    {
		set.define_property("fixed_normal", any);
	    }
	    catch(ReadOnlyProperty ex)
	    {
		throw new TestException();
	    }
	    catch(ConflictingProperty ex)
	    {
		throw new TestException();
	    }
	    catch(UnsupportedProperty ex)
	    {
		// This exception must be thrown
		except = true;
	    }
	    catch(UnsupportedTypeCode ex)
	    {
		// This exception must be thrown
		except = true;
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }

	    if(!except)
		throw new TestException();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_property_mode()... ");

	    PropertyModeType fixed_normal;
	    PropertyModeType read_only;
	    PropertyModeType fixed_readonly;
	    try
	    {
		fixed_normal = set.get_property_mode("fixed_normal");
		read_only = set.get_property_mode("read_only");
		fixed_readonly = set.get_property_mode("fixed_readonly");
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }
	    catch(PropertyNotFound ex)
	    {
		throw new TestException();
	    }

	    if(fixed_normal != PropertyModeType.fixed_normal ||
	       read_only != PropertyModeType.read_only ||
	       fixed_readonly != PropertyModeType.fixed_readonly)
		throw new TestException();

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing delete_property()... ");

	    except = false;
	    //
	    // Try to delete fixed_normal property;
	    //
	    try
	    {
		set.delete_property("fixed_normal");
	    }
	    catch(FixedProperty ex)
	    {
		// This exception must be thrown
		except = true;
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }
	    catch(PropertyNotFound ex)
	    {
		throw new TestException();
	    }

	    if(!except)
		throw new TestException();

	    System.out.println("OK!");
	}
    }

    //
    // Tests for initial PropertySetDef
    //
    static void testInitial(ORB orb, PropertySetDef set)
    {
	{
	    System.out.print("  Testing get_number_of_properties()... ");

	    if(set.get_number_of_properties() != 1)
		throw new TestException();

	    System.out.println("OK!");
	}
	    
	{
	    System.out.print("  Testing is_property_defined()... ");

	    try
	    {
		if(!set.is_property_defined("initial_property"))
		    throw new TestException();
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }

	    try
	    {
		if(set.is_property_defined("illegal_property"))
		    throw new TestException();
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }

	    System.out.println("OK!");
	}

	{
	    System.out.print("  Testing get_property_value()... ");

	    Any any;
	    try
	    {
		any = set.get_property_value("initial_property");
	    }
	    catch(InvalidPropertyName ex)
	    {
		throw new TestException();
	    }
	    catch(PropertyNotFound ex)
	    {
		throw new TestException();
	    }

	    String value = any.extract_string();
	    if(!value.equals("initial_property_value"))
		throw new TestException();

	    System.out.println("OK!");
	}
    }
}

class TestException extends RuntimeException
{
}
