$! Program Name            : INSTALL.COM
$!   Original Author       : NUCMGR
$!   Date                  : 02-Nov-1999
$!   Program Description   :  VMS Installation command procedure.
$!                         :
$!   Usage                 : @INSTALL [targetDirectory]
$!   Note                  : Best executed from SYSTEM account.
$!-
$ echo := write sys$output
$
$ ver = f$verify(0)
$ BASE = f$trnlnm("NEDIT_DIR")
$ if BASE.nes.""
$ then	echo "NEDIT_DIR is defined as ''BASE'"
$	INQUIRE ANS "Is this path UpToDate ? "
$	if f$extract(0,1,ANS).eqs."Y"
$	then	! Update
$		BASE = f$extract(0,f$length(BASE)-2,BASE)
$	else
$		! First time installation or superseed
$ 		DEBUT:
$ 		if P1.eqs.""
$ 		then	INQUIRE P1 "Install directory "
$ 			GOTO DEBUT
$ 		endif
$		! Just to be sure that a relative path was not used
$		! a relative path.
$		P1 = f$extract(0,f$length(P1)-1,P1)
$		!echo P1
$		if f$extract(f$length(P1)-1,1,P1).eqs."."
$		then	P1 = f$extract(0,f$length(P1)-1,P1)
$		endif
$		P1 = P1 + "]"
$
$ 		IF f$parse(P1).eqs.""
$ 		then	ON ERROR THEN EXIT
$			! because you are trying to create a directory
$			! where you are not supposed too (??)
$			CREATE/DIR 'P1'
$ 		endif
$ 		P1 = f$parse(P1) - ".;"
$ 		BASE = f$extract(0,f$length(P1)-1,P1)
$	endif
$	echo base
$ endif
$
$ echo "Moving files"
$ BACKUP/LOG/NEW_VERSION [.NEDIT5_0-HTML-DOC...]*.* 	'BASE'.NEDIT5_0-HTML-DOC...]
$ BACKUP/LOG/NEW_VERSION [.MACROS...]*.*	 	'BASE'.MACROS...]
$ BACKUP/LOG/NEW_VERSION [.ICONS...]*.* 		'BASE'.ICONS...]
$ BACKUP/LOG/NEW_VERSION [.NMP...]*.* 			'BASE'.NMP...]
$
$ echo "Setting protections on ''BASE'...]*.*;*"
$ SET FILE/PROT=(WORLD:RE) 'BASE'...]*.*;*
$
$ echo ""
$ echo "Directory where the executables should be placed may be different"
$ echo "from NEDIT_DIR:[000000]. Press return for the default."
$ INQUIRE P1 "Where to place the executables "
$ if P1.nes.""
$ then	EXEPATH = P1
$ else  EXEPATH = BASE+"]"
$ endif
$
$ echo ""
$ COPY/LOG [.SOURCE]NEDIT.EXE 'EXEPATH'NEDIT.EXE	/PROT=WORLD:E
$ COPY/LOG [.SOURCE]NC.EXE    'EXEPATH'NC.EXE		/PROT=WORLD:E
$
$
$ echo ""
$ ECHO "Generating the Setup File"
$ OPEN/WRITE FILOUT SETUP_NEDIT.COM_TMP
$ OPEN/WRITE FILCLD NEDIT.CLD
$ WRITE FILOUT "$!+"
$ WRITE FILOUT "$! File Auto-Generated by the INSTALL procedure on ",f$time()
$ WRITE FILOUT "$!-"
$ WRITE FILCLD "!+"
$ WRITE FILCLD "! File Auto-Generated by the INSTALL procedure on ",f$time()
$ WRITE FILCLD "!-"
$
$ WRITE FILOUT "$ ver = f$ver(0)"
$ WRITE FILOUT "$"
$ WRITE FILOUT "$ if P1.eqs."""""
$ WRITE FILOUT "$ then P1 = ""/PROCESS"""
$ WRITE FILOUT "$ else if f$extract(1,1,P1).nes.""/"" then P1 = ""/'"+"'p1"+"'"""
$ WRITE FILOUT "$ endif"
$ WRITE FILOUT "$"
$ WRITE FILOUT "$ INSTALL_DIR   = F$PARSE(F$ENVIRONMENT(""PROCEDURE""),,,,""NO_CONCEAL"")-""]["""
$ WRITE FILOUT "$ INSTALL_DIR   = F$EXTRACT(0,F$LOCATE(""]"",INSTALL_DIR)+1,INSTALL_DIR)-""]""+"".]"""
$ WRITE FILOUT "$ define'"+"p1"+"'/nolog NEDIT_DIR '"+"install_dir"+"'"
$ WRITE FILOUT "$ define'"+"p1"+"'/nolog NEDITDOC  NEDIT_DIR:[NEDIT5_0-HTML-DOC]"
$ WRITE FILOUT "$"
$ WRITE FILOUT "$ if P1.nes.""/SYSTEM"""
$ WRITE FILOUT "$ then	! Depend on Installation Choice"
$ if EXEPATH.eqs.P1
$ then
$	WRITE FILOUT "$	! Another path has been chosen for EXECutable installation"
$	WRITE FILOUT "$	NEDIT :== $''EXEPATH'NEDIT.EXE"
$	WRITE FILOUT "$	NC    :== $''EXEPATH'NC.EXE"
$
$	WRITE FILCLD "define verb NEDIT"
$	WRITE FILCLD "   image ''EXEPATH'NEDIT.EXE, cliflags(foreign)"
$	WRITE FILCLD ""
$	WRITE FILCLD "define verb NC"
$	WRITE FILCLD "   image ''EXEPATH'NC.EXE, cliflags(foreign)"
$	WRITE FILCLD ""
$ else
$	WRITE FILOUT "$	! Nedit was installed in the default path
$	WRITE FILOUT "$	NEDIT :== $NEDIT_DIR:[000000]NEDIT.EXE"
$	WRITE FILOUT "$	NC    :== $NEDIT_DIR:[000000]NC.EXE"
$
$	WRITE FILCLD "define verb NEDIT"
$	WRITE FILCLD "   image NEDIT_DIR:[000000]NEDIT.EXE, cliflags(foreign)"
$	WRITE FILCLD ""
$	WRITE FILCLD "define verb NC"
$	WRITE FILCLD "   image NEDIT_DIR:[000000]NC.EXE, cliflags(foreign)"
$	WRITE FILCLD ""
$ endif
$ WRITE FILOUT "$ endif"
$ WRITE FILOUT "$"
$ WRITE FILOUT "$exit"
$ CLOSE FILOUT
$ CLOSE FILCLD
$
$ RENAME/NOLOG/NOCONFIRM SETUP_NEDIT.COM_TMP SETUP_NEDIT.COM
$ COPY/NOLOG   SETUP_NEDIT.COM 	'BASE']
$
$
$ ! All done
$ INQUIRE ANS "Continue"
$ ECHO  ""
$ ECHO  "SYSTEM Installation :"
$ ECHO  " 1) Add the following to your startup procedure"
$ ECHO  "      @''BASE']SETUP_NEDIT SYSTEM"
$ ECHO  ""
$ ECHO  " 2) Then do one of the following "
$ if EXEPATH.eqs.P1
$ then
$  ECHO "    Define foreign symbols ONLY in SYLOGIN.COM"
$  ECHO "      NEDIT :== $''EXEPATH'NEDIT.EXE"
$  ECHO "      NC    :== $''EXEPATH'NC.EXE"
$ else
$  ECHO "    Define foreign symbols ONLY in SYLOGIN.COM"
$  ECHO "      NEDIT :== $NEDIT_DIR:[000000]NEDIT.EXE"
$  ECHO "      NC    :== $NEDIT_DIR:[000000]NC.EXE"
$ endif
$ if f$getsyi("VERSION").ges."V6.2"
$ THEN
$  ECHO  ""
$  ECHO "  --- OR ---"
$  ECHO "    If ''EXEPATH' is part of your DCL$PATH logicals you DO NOT NEED to"
$  ECHO "    perform Step 2 for NEDIT. If you have NCS on your machine, you will"
$  ECHO "    still need to define NC as a foreign symbol as above."
$ ENDIF
$ ECHO  ""
$ ECHO  "  --- OR ---"
$ ECHO  "    You may insert NEDIT.CLD in your DCLTABLES.EXE"
$ ECHO  "    The command would be"
$ ECHO  "       $ SET COMMAND NEDIT.CLD /REPLACE -"
$ ECHO  "          /TABLE=SYS$LIBRARY:DCLTABLES.EXE -"
$ ECHO  "          /OUTPUT=SYS$COMMON:[SYSLIB]DCLTABLES.EXE"
$ ECHO  "    Followed by (on all nodes within your cluster)"
$ ECHO  "       $ INSTALL REPLACE SYS$LIBRARY:DCLTABLES.EXE /HEADER/OPEN/SHARE"
$ ECHO  ""
$ INQUIRE ANS "Continue"
$ ECHO  "USER Installation (if not installed system-wide) :"
$ ECHO  " Add the following line in your LOGIN.COM"
$ ECHO  "    @''BASE']SETUP_NEDIT.COM"
$ ECHO ""
$ ECHO ""
$ ECHO "Installation is complete"
$ ECHO "Post Installation hints ..."
$ ECHO ""
$ if f$search("NEDIT.HLP").nes."" 
$ THEN -
$  ECHO " o You may want to insert NEDIT.HLP in a cluster accessible Help Library"
$  ECHO "   $ LIBRARY/REPLACE SYS$HELP:HELPLIB.HLB NEDIT.HLP"
$ ENDIF
$ if f$search("VIEW$NEDIT.COM").nes."" 
$ THEN 
$  ECHO " o You may want to "
$  ECHO "   $ COPY/prot=w:re VIEW$NEDIT.COM DECW$SYSCOMMON:[VUE$LIBRARY.USER]"
$ ENDIF
$ ECHO " o You may want to add file:///neditdoc/nedit_contents.html to your system"
$ ECHO "   Web-browser(s) jump files."
$ ECHO ""
$
$ ver = f$verify(ver)
$! ----------------------- :
$!   Date of Revision      :  2-NOV-1999
$!   Change Author         : NUCMGR
$!   Purpose of Revision   : Reshaped.
$!                         :
