 .\" 4 .\" @(#)man.1 1.37 90/02/15 SMI; from UCB 6.2 8/7/85 .TH NEDIT 1 "03 November 1994" .SH NAME nedit  .SH SYNOPSIS .B nedit [  .BI \-tags " file" ]  [  .BI \-tabs " n"  ]  [ 	 .B \-wrap  ]  [  .B \-nowrap  ]  .if n .ti +0.6i  [ 
 .B \-autosave  ]  [  .B \-noautosave  ]  [  .B \-autoindent  ]  .if n .ti +0.6i  [  .B \-noautoindent  ]  [  .BI \-rows " n"  ]  [  .BI \-columns " n" ]  .if n .ti +0.6i  [  .BI -font " font"  ]  [  .BI \-xrn " resourcestring"  ]  .if n .ti +0.6i  [ ' .BI \-display " [host]:server[.screen]"  ]  .if n .ti +0.6i  [  .BI \-geometry " geometry" ]  [ 
 .B file... ]  .SH DESCRIPTION K NEdit is a GUI (Graphical User Interface) style plain text editor for work- K stations with X Windows and Motif.  It is written to maximize usability for O people who do intensive and continuous editing, but at the same time is easy to M learn and to use casually.  For programmers, NEdit provides automatic indent, N block indentation adjustment, parenthesis flashing, and Unix ctags processing.  E NEdit is public domain software, available in binary form for Silicon N Graphics, HP, DEC, IBM, and Sun workstations running Unix, as well as for VMS.N Sources and executables for non-supported systems are also available.  Porting1 to other Motif platforms has generally been easy.  .SH INSTALLING NEDITN NEdit is a single stand-alone executable file which can be installed by simplyI copying the appropriate executable "nedit" for your system.  Both sources F and executables are available via anonymous ftp to ftp.fnal.gov in the /pub/nedit directory.  .SH GETTING STARTED E If you are new to X windows, you may need some help setting up your X F environment or using X across a network.  If you have used other MotifM programs before, you can probably use NEdit without much instruction.  Editor K commands are available from the pull-down menus (File, Edit, Search, etc.). 6 If you make a mistake, select Undo from the Edit menu.  M Start NEdit by typing nedit.  You can specify a file or several files to edit J on the command line, but you can also open them from inside NEdit.  If youN don't specify a file name to edit, NEdit will open a window titled "Untitled".I You can create a new file by typing into this window and choosing Save or G Save As... from the File menu.  There is no "main window" in NEdit, all L editor windows are equivalent, and NEdit remains running as long as at least one window is open.   G Most editor commands are available from the pulldown menus (File, Edit, G Search).  If you make a mistake, any editing operation can be undone by M selecting Undo from the Edit menu.  Online help is also available through the 0 Help menu on the right hand side of the menu bar  L To open an existing file once nedit is running, choose Open... from the FileG menu.   Select the file that you want to open in the pop-up dialog that M appears, and click on OK.  You may open any number of files at the same time. J Each file will appear in its own editor window.  Using Open... rather thanM re-typing the nedit command and running additional copies of NEdit, will give L you quick access to all of the files you have open via the Windows menu, and< ensure that you don't accidentally open the same file twice.  J As you become more familiar with NEdit, you can substitute the control andN function keys shown on the right side of the menus for pulling down menus with
 the mouse.  M Dialogs are also streamlined so you can enter information quickly and without N using the mouse (Users who have set their keyboard focus mode to "pointer" canJ set "Popups Under Pointer" in the Default Settings menu to avoid having toM move the mouse into the dialog).  To move the keyboard focus around a dialog, L use the tab and arrow keys.  One of the buttons in a dialog is usually drawnJ with a thick, indented, outline.  This button can be activated by pressingJ return or enter.  For example, to replace the string "thing" with "things" type:   $     <ctrl-r>thing<tab>things<return>  + To open a file named "whole_earth.c", type:        <ctrl-o>who<return>   L (how much of the filename you need to type depends on the other files in theL directory).  See the section titled KEYBOARD SHORTCUTS for more information.# .SH SELECTING, CUTTING, and PASTING H To select text for copying, deleting, or replacing, press the left mouseN button with the pointer at one end of the text you want to select, and drag itM to the other end.  The text will become highlighted.  To select a whole word, K double click (click twice quickly in succession).  Double clicking and then N dragging the mouse will select a number of words.  Similarly, you can select aI whole line or a number of lines by triple clicking or triple clicking and I dragging. Clicking four times selects the entire contents of the window.  M After releasing the mouse button, you can still adjust a selection by holding N down the shift key and dragging on either end of the selection.  To delete theG selected text, press delete or backspace.  To replace it, begin typing.   I Selected text can be dragged to a new location in the file, or to another M window using the middle mouse button.  Holding the control key while dragging I the text will copy the selected text, leaving the original text in place. L Clicking the middle mouse button will also copy selected text to the clickedL position, even if the text is selected in another window or another program.  M The easiest way to copy and move text around in your file or between windows, K is to use the clipboard, an imaginary area that temporarily stores text and G data.  The Cut command removes the selected text from your document and M places it in the clipboard.  Once text is in the clipboard, the Paste command L will copy it to the insert position in your document.  So, to move some textJ from one place to another, select it by dragging the mouse over it, chooseI Cut to remove it from your document, click the pointer to move the insert G point where you want the text inserted, then choose Paste to insert it. I Copy copies text to the clipboard without deleting it from your document.   J Text selected with right mouse button (the middle button in NEdit versionsK built with older 1.1 Motif libraries) is called a secondary selection.  The H type of selection described in previous paragraphs is called the primaryL selection.  The secondary selection is highlighted by underlining.  When youN release the mouse button after making a secondary selection, nedit immediatelyE copies the selected text to the insert point (which can be in another K window).  Holding the control key while making the secondary selection will L delete the text as well as copying it.  Secondary selections are most usefulE for copying text at the point where you are currently typing, and for , substituting text for the primary selection. .SH FINDING AND REPLACING TEXTM The Search menu contains a number of commands for finding and replacing text.   F The Find... and Replace... items present dialogs for entering text forJ searching and replacing.  The dialogs also allow you to choose whether youN want the search to be sensitive to upper and lower case, or whether to use theJ standard Unix pattern matching characters (regular expressions).  SearchesM begin at the current text insertion position and wrap around to the beginning  of the file.  J Find Same and Replace Same repeat the last find or replace command withoutI prompting for search strings.  To selectively replace text, use these two J commands in combination.  Choose Find Same followed by Replace Same if theK highlighted string should be replaced, or Find Same again to move on to the  next string.  E Find Selection searches for the text contained in the current primary L selection (see Selecting Text above).  The selected text does not have to beF in the current editor window.  It may even be in another program.  ForN example, if the word dog appears somewhere in a window on your screen, and youH want to find it in the file that you are editing, select the word dog byJ dragging the mouse across it, switch to your editor window and choose Find Selection from the Search menu.  .SH Searching Backwards F Holding down the shift key while choosing any of the search or replaceK commands from the menu (or using the keyboard shortcut), will search in the L reverse direction.  Note that engaging the caps lock key does not substitute for holding down the shift key.  .SH Regular Expressions L Regular expressions are available in the Find... and Replace... dialogs as aN way to match inexact sequences of characters.  Regular expression substitutionK can also be used to program automatic editing operations.  For example, the M following are search and replace strings to find occurences of the subroutine N get_x, reverse the first and second parameters, add a third parameter of NULL," and change the name to new_get_x": .LP / 	Search string:  get_x\\(([^ ,]*), ([^\\)]*)\\)  .br * 	Replace string: new_get_x(\\2, \\1, NULL)  I To use regular expressions, click on the Regular Expression button in the C Find... or Replace... dialogs before doing a search or replacement.  .SH Regular Expression Syntax H The components of a regular expression are: branches, pieces, atoms, andL ranges. A regular expression consists of zero or more branches, separated by; `|'.  It matches anything that matches one of the branches.   J A branch is zero or more pieces, concatenated.  It matches a match for the/ first, followed by a match for the second, etc.   N A piece is an atom possibly followed by `*', `+', or `?'.  An atom followed byM `*' matches a sequence of 0 or more matches of the atom.  An atom followed by M `+' matches a sequence of 1 or more matches of the atom.  An atom followed by 4 `?' matches a match of the atom, or the null string.  H An atom is a regular expression in parentheses (matching a match for theN regular expression), a range (see below), `.' (matching any single character),O `^' (matching the null string at the beginning of a line string), `$' (matching L the null string at the end of a line), a `\\' followed by a single characterK (matching that character), or a single character with no other significance D (matching that character). \\t, \\n, \\b, \\r, and \\f represent theB characters tab newline, backspace, carriage return, and form feed.  N A range is a sequence of characters enclosed in `[]'.  It normally matches anyH single character from the sequence.  If the sequence begins with `^', itG matches any single character not from the rest of the sequence.  If two O characters in the sequence are separated by `-', this is shorthand for the full G list of ASCII characters between them (e.g. `[0-9]' matches any decimal N digit).  To include a literal `]' in the sequence, make it the first characterK (following a possible `^').  To include a literal `-', make it the first or N last character.  A backslash `\\' followed by a single character includes thatM character, however backslashes are not necessary for most special characters, H since inside a range, only the `]', `-', and '\\' characters are treated
 specially. .SH SubstitutionG Wherever the substitution string contains the character `&', NEdit will O substitute the the entire string that was matched in the Find operation.  Up to F nine sub-expressions of the match string can also be inserted into theM replacement string, using `\\' followed by a digit. \\1 through \\9 represent E the strings that matched parenthesized expressions within the regular I expression, numbered left-to-right in order of their opening parentheses. G Preceding & or \\1-9 with \\U, \\u, \\L, or \\l adjusts the case of the N inserted text.  \\u and \\l change only the first character, while \\U and \\L change the entire string to N upper or lower case.  \\t, \\n, \\b, \\r, and \\f represent the characters tabK newline, backspace, carriage return, and form feed in a substitution string E represent the tab and newline characters as they do in match strings. 
 .SH Ambiguity L If a regular expression could match two different parts of the text, it willO match the one which begins earliest.  If both begin in the same place but match H different lengths, or match the same length in different ways, life gets messier, as follows.  E In general, the possibilities in a list of branches are considered in K left-to-right order, the possibilities for `*', `+', and `?' are considered J longest-first, nested constructs are considered from the outermost in, andN concatenated constructs are considered leftmost-first.  The match that will beM chosen is the one that uses the earliest possibility in the first choice that O has to be made.  If there is more than one choice, the next will be made in the G same manner (earliest possibility) subject to the decision on the first  choice.  And so forth.  I For example, `(ab|a)b*c' could match `abc' in one of two ways.  The first I choice is between `ab' and `a'; since `ab' is earlier, and does lead to a M successful overall match, it is chosen.  Since the `b' is already spoken for, O the `b*' must match its last possibility-the empty string-since it must respect  the earlier choice.   K In the particular case where no `|'s are present and there is only one `*', O `+', or `?', the net effect is that the longest possible match will be chosen.  M So `ab*', presented with `xabbbby', will match `abbbb'. Note that if `ab*' is H tried against `xabyabbbz', it will match `ab' just after `x', due to theN begins-earliest rule.  (In effect, the decision on where to start the match isM the first choice to be made, hence subsequent choices must respect it even if 0 this leads them to less-preferred alternatives.) .SH FEATURES FOR PROGRAMMERSG With Auto Indent turned on (the default), NEdit keeps a running indent. I When you press the return key, space and tabs are inserted to line up the 2 insert point under the start of the previous line.  J The Shift Left and Shift Right commands adjust the indentation for severalO lines at once.  To shift a block of text one character to the right, select the L text, then choose Shift Right from the Edit menu.  Note that the acceleratorO keys for these menu items are Ctrl+9 and Ctrl+0, which correspond to  the right O and left parenthesis on most keyboards.  Remember them as adjusting the text in M the direction pointed to by the parenthesis character.  Holding the Shift key K while selecting either Shift Left or Shift Right will shift the text by one  full tab stop.  K To find a particular line in a source file by line number, choose Goto Line M #... from the Search menu.  You can also directly select the line number text F in a compiler message in the terminal emulator window (xterm, winterm,H decterm, etc.) where you ran the compiler, and choose Goto Selected fromL the Search menu.  To find the line number of a particular line in your file,K turn on Statistics Line in the Preferences menu, and position the insertion N point anywhere on the line.  The statistics line continuously updates the line/ number of the location of the insertion cursor.   K To help you inspect nested parentheses, brackets, braces, quotes, and other M characters, NEdit has both an automatic parenthesis matching mode, and a Find L Matching command.  Automatic parenthesis matching is activated when you typeH or move the insertion cursor after a parenthesis, bracket, or brace.  ItM momentarily highlights the matching character if that character is visible in L the window.  To find a matching character anywhere in the file, select it orM position the cursor after it, and choose Find Matching from the Search menu.  K If the character matches itself, such as a quote or slash, select the first H character of the pair.  NEdit will match {, (, [, <, ", ', `, /, and \\.  N The Open Selected command understands the C preprocessor's #include syntax, soM selecting an #include line and invoking Open Selected will generally find the N file referred to, unless doing so depends on the settings of compiler switches, or other information not available to NEdit.  K NEdit can process tags files generated using the Unix ctags command.  Ctags N creates index files correlating names of functions and declarations with theirK locations in C, Fortran, or Pascal source code files. (See the ctags manual M page for more information).  Ctags produces a file called "tags" which can be M loaded by NEdit.  Once loaded, the information in the tags file enables NEdit M to go directly to the declaration of a highlighted function or data structure N name with a single command.  To load a tags file, select "Load Tags File" fromM the File menu and choose a tags file to load, or specify the name of the tags  file on the NEdit command line:        nedit -tags tags  J NEdit can also be set to load a tags file automatically when it starts up.M Setting the X resource nedit.tagFile to the name of a tag file tells NEdit to N look for that file at startup time (see Customizing NEdit).  The file name canM be either a complete path name, in which case NEdit will always load the same J tags file, or a file name without a path or with a relative path, in whichH case NEdit will load it starting from the current directory.  The secondK option allows you to have different tags files for different projects, each H automatically loaded depending on the directory you're in when you startN NEdit.  Setting the name to "tags" is an obvious choice since this is the name that ctags uses.  J To find the definition of a function or data structure once a tags file isJ loaded, select the name anywhere it appears in your program (see Selecting8 Text) and choose "Find Definition" from the Search menu. .SH KEYBOARD SHORTCUTSL Most of the keyboard shortcuts in NEdit are shown on the right hand sides ofN the pull-down menus.  However, there are more which are not as obvious.  TheseM include menu and dialog mnemonics; labeled keyboard keys, such as the arrows, N page-up, page-down, and home; shifted accelerator keys, like Shift+Ctrl+F; and default actions. .SH Menu Accelerators G Pressing the key combinations shown on the right of the menu items is a O shortcut for selecting the menu item with the mouse.  Some items have the shift O key enclosed in brackets, such as [Shift]Ctrl+F.  This indicates that the shift J key is optional.  In search commands, including the shift key reverses theK direction of the search.  In Shift commands, it makes the command shift the C selected text by a whole tab stop rather than by single characters.  .SH Menu MnemonicsL Pressing the Alt key in combination with one of the underlined characters inL the menu bar pulls down that menu.  Once the menu is pulled down, typing theI underlined characters in a menu item (without the Alt key) activates that N item.  With a menu pulled down, you can also use the arrow keys to select menu4 items, and the space or enter keys to activate them. .SH Labeled Function Keys L The labeled function keys on standard workstation and PC keyboards, like theK arrows, and page-up and page-down, are active in NEdit, though they are not  shown in the pull-down menus.   L Holding down the control key while pressing a named key extends the scope ofI the action that it performs.  For example, Home normally moves the insert K cursor the beginning of a line.  Ctrl+Home moves it to the beginning of the G file. Backspace deletes one character, Ctrl+Backspace deletes one word.   I Holding down the shift key while pressing a named key begins or extends a M selection.  Combining the shift and control keys combines their actions.  For M example, to select a word without using the mouse, position the cursor at the 5 beginning of the word and press Ctrl+Shift+RightArrow   K Under X and Motif, there are several levels of translation between keyboard O keys and the actions they perform in a program.  Keyboards vary from machine to O machine, and so do standards for the meaning of some keys.  NEdit uses the same L mapping of keys to program actions as other Motif programs that include textK fields and editable text.  On most machines, these text editing actions are L properly matched to the labeling of arrow keys and other named keys, such asK Insert, Home, Page-Up, etc..  If you prefer different key bindings, see the  section titled Customization. % .SH Keyboard Shortcuts within Dialogs  .in +3n  .ti -3n K 1. One button in a dialog is usually marked with a thick indented outline.  7 Pressing the Return or Enter key activates this button.    .ti -3n J 2. All dialogs have either a Cancel or Dismiss button.  This button can be. activated by pressing the Escape (or Esc) key.   .ti -3n O 3. Pressing the tab key moves the keyboard focus to the next item in a dialog.  N Within an associated group of buttons, the arrow keys move the focus among the5 buttons.  Shift+Tab moves backward through the items.    .ti -3n N 4. Most items in dialogs have an underline under one character in their name. O Pressing the Alt key along with this character activates a button as if you had M pressed it with the mouse, or moves the keyboard focus to the associated text  field or list.   .ti -3n G 5. You can select items from a list by using the arrow keys to move the 
 selection.   .ti -3n O 6. In file selection dialogs, you can type the beginning characters of the file - name or directory in the list to select files  .in -3n  .SH Entering Control Characters G A shortcut method for including control characters in a file is to type N Ctrl+Alt+character, where character is the ASCII control character equivalent,8 for example Ctrl+Alt+L will enter a form feed character. .SH CRASH RECOVERYK If a system crash, network failure, X server crash, or program error should N happen while you are editing a file, you can easily recover most of your work.L NEdit maintains a backup file which it updates periodically (every 8 editingJ operations or 30 characters typed under Unix, or 80 characters under VMS).M This file is has the same name as the file that you are editing, but with the N character "~" (tilde) on Unix or "_" (underscore) on VMS prefixed to the name.L To recover a file after a crash, simply rename the file to remove the tilde K or underscore character, replacing the older version of the file.  Because  M several of the Unix shells consider the tilde to be a special character, you  J may have to prefix the character with a "\\" (backslash) when you move or  delete an NEdit backup file.  > Example, to recover the file called "help.c" type the command:       mv \\~help.c help.c      
 On VMS, type:           RENAME _HELP.C HELP.C  .SH PREFERENCES K The Preferences menu allows you to set options for both the current editing E window, and default values for newly created windows and future NEdit I sessions.  The first group of options in the Preferences menu take effect I immediately and refer to the current window only.  Options in the Default K Settings sub-menu have no effect on the current window, but instead provide K initial settings for future windows created using the New or Open commands. N These settings can also be saved in a file that is automatically read by NEdit at startup time.   .B Auto Indent9 -- Maintain a running indent.  When you press return, the E insert point will line up with the indent level of the previous line.    .B Auto WrapI -- Wrap text at word boundaries when the text is entered beyond the right  margin.    .B Maintain Backup4 -- Periodically make a backup copy of the file beingF edited under the name ~filename on Unix or _filename on VMS (see Crash
 Recovery).   .B Show Matching (..) . -- Momentarily highlight matching parenthesis,G brackets, and braces when one of these characters is typed, or when the ( insertion cursor is positioned after it.   .B Text Font... : -- Set the font for the text in this NEdit window.  To setH the font for all windows use the equivalent item in the Default SettingsF sub-menu.  Note that since the font selection dialog narrows its listsB of font characteristics depending on those already selected, it isH important to know that you can unselect them by clicking on the selected items a second time.   .B Tab Distance 1 -- Set the number of characters between tab stops ' (individual tab stops are not setable).   
 .B Overstrike 9 -- In overstrike mode, new characters entered replace the H characters in front of the inserition cursor, rather than being inserted before them.   .B Statistics Line6 -- Show the full file name, line number, and length of the file being edited.   .B Default Settings 3 -- Sub-menu of initial settings for future windows. F These are mostly the same as the options in the main part of the menu,B but apply as defaults for future windows created during this NEditE session.  These settings can be saved using the Save Defaults command = below, to be loaded automatically each time NEdit is started.    .B Save Defaults9 -- Save the default options as set under Default Settings  for future NEdit sessions. .SH SHELL COMMANDSM The Shell menu (Unix versions only) allows you to execute Unix shell commands K from within NEdit.  You can add items to the menu to extend NEdit's command L set or to incorporate custom automatic editing features using shell commandsI or editing languages like awk and sed.  To add items to the menu, use the I Shell Commands... dialog in the preferences menu under Default Settings.  I NEdit comes pre-configured with a few useful Unix commands like spell and G sort, but the menu is mostly for you to add your own custom extensions.   H Filter Selection... prompts you for a Unix command to use to process theO currently selected text.  The output from this command replaces the contents of  the selection.  J Execute Command... prompts you for a Unix command and replaces the currentG selection with the output of the command.  If there is no selection, it 3 deposits the output at the current insertion point.   N Execute Command Line uses the position of the cursor in the window to indicateH a line to execute as a shell command line.  The cursor may be positionedK anywhere on the line.  This command allows you to use an NEdit window as an O editable command window for saving output and saving commands for re-execution.   O The X resource called nedit.shell (See Customizing NEdit) determines which Unix J shell is used to execute commands.  The default value for this resource is	 /bin/csh.  .SH THE NEDIT COMMAND LINE@ Under VMS, both VMS and Unix style command lines are acceptable:  '     nedit/rows=20/wrap file1.*, file2.c    is equivalent to:   (     nedit -rows 20 -wrap file1.* file2.c   .SH NEdit command line options  
 .B -tags file ? -- Load a file of directions for finding definitions of program G subroutines and data objects.  The file must be of the format generated  by the Unix ctags command.  
 .B -tabs n$ -- Set tab stops every n characters.   .B -wrap, -nowrap 9 -- Wrap lines at the right edge of the window rather than   continuing them past it.    .B -autoindent, noautoindent -- Maintain a running indent.    .B -autosave, -noautosave K -- Maintain a backup copy of the file being edited under the name ~filename   
 .B -rows n4 -- Default width in characters for an editing window  
 .B -columns n 5 -- Default height in characters for an editing window    .B -font font (or -fn font) 1 -- Font for text being edited (Font for menus and . dialogs can be set with -xrm "*fontList:font")  " .B -display [host]:server[.screen]) -- The name of the X server to use.  host F specifies the machine; server specifies the display server number; andF screen specifies the screen number.  host or screen can be omitted and+ default to the local machine, and screen 0.   & .B -geometry geometry (or -g geometry)# -- The initial size and location of < the application window.  The argument geometry has the form:  6       [<width>x<height>][+|-][<xoffset>[+|-]<yoffset>]  B Where <width> and <height> are the desired width and height of theI window, and <xoffset> and <yoffset> are the distance from the edge of the ? screen to the window, + for top or left, - for bottom or right.   # .B -background color (or -bg color) & -- Background color. (background colorG for text can be set separately with -xrm "nedit*text:background color")   # .B -foreground color (or -fg color) & -- Foreground color. (foreground colorG for text can be set separately with -xrm "nedit*text:foreground color")    .B -xrm resourcestring/ -- Set the value of an X resource to override a % default value (see Customizing NEdit)  .SH CUSTOMIZATION M NEdit has some options which are not settable using the Preferences menu, but L are instead set using X resources.  Like many other X programs, NEdit can beK customized to vastly unnecessary proportions, from initial window positions H down to the font and shadow colors of each individual button (A completeL discussion of how to do this is left to books on the X Windows System).  KeyH binding (see below) is one of the most useful of these resource settable options.  J X resources are usually specified in a file called .Xdefaults in your homeM directory (on VMS this is SYS$LOGIN).  On some systems, this file is read and L its information attached to the X server (your screen) when you start X.  OnJ other systems, the .Xdefaults file is read each time you run an X program.M When X defaults are attached to the server, you can use a program called xrdb $ to update them without restarting X. .SH The .nedit File J The .nedit (saved preferences) file is in the same format as an X resourceN file, and its contents can be moved into your X resource file.  One reason forJ doing so would be to attach server specific preferences, such as a defaultN font to a particular X server.  Another reason for moving preferences into theF X resource file would be to keep preferences menu options and resourceM settable options together in one place. Though the files are the same format, M additional resources should not be added to the .nedit file, they will not be K read, and NEdit modifies this file by overwriting it completely.  Note also I that the contents of the .nedit file take precedence over the values of X M resources.  Using Save Defaults after moving the contents of your .nedit file L to your .Xdefaults file will re-create the .nedit file, interfering with the options that you have moved. .SH Selected X Resource Names N The following are selected NEdit resource names and their default values.  ForG NEdit options settable via the Preferences menu, see the section titled N Preferences.  The resource names for preference resources can be found in your .nedit file.   .B nedit.tagFile: (not defined) - -- The name of a file of the type produced by A the Unix ctags command which NEdit will load at startup time (see G Features for Programmers).  The tag file provides a database from which A NEdit can automatically open files containing the definition of a # particular subroutine or data type.    .B nedit.shell: /bin/csh. -- (Unix systems only) The Unix shell (command> interpreter) to use for executing commands from the Shell menu  < .B nedit.wordDelimiters: .,/\\\\\\\\`'!@#%^&*()-=+{}[]":;<>? -- The characters, in H addition to blanks and tabs, which mark the boundaries between words forF the move-by-word (Ctrl+Arrow) and select-word (double click) commands.   .B nedit.remapDeleteKey: True . -- Setting this resource to False restores theI original Motif binding of the delete key to forward-delete.  This binding F causes problems when X servers with one delete/backspace configurationI are connected with X clients of the other.  Users with a backspace key in F the backspace/delete position who use only machines with such style ofF keyboard can set this resource to False to get back the forward-delete function of the delete key.   ( .B nedit.printCommand: (system specific)H -- Command used by the print dialog to print a file, i.e. lp, lpr, etc..  - .B nedit.printCopiesOption: (system specific)  -- Option name used to specifyH multiple copies to the print command.  If the option should be separatedB from its argument by a space, leave a trailing space. If blank, no8 "Number of Copies" item will appear in the print dialog.  , .B nedit.printQueueOption: (system specific)  -- Option name used to specify aI print queue to the print command.  If the option should be separated from E its argument by a space, leave a trailing space. If blank, no "Queue" % item will appear in the print dialog.   + .B nedit.printNameOption: (system specific)   -- Option name used to specify aF job name to the print command.  If the option should be separated fromI its argument by a space, leave a trailing space. If blank, no job or file 6 name will be attached to the print job or banner page.  + .B nedit.printHostOption: (system specific)   -- Option name used to specify aG host name to the print command.  If the option should be separated from I its argument by a space, leave a trailing space. If blank, no "Host" item   will appear in the print dialog.  - .B nedit.printDefaultQueue: (system specific)  -- The name of the defaultI print queue.  Used only to display in the print dialog, and has no effect  on printing.  , .B nedit.printDefaultHost: (system specific) -- The node name of the default H print host.  Used only to display in the print dialog, and has no effect on printing.   .B nedit*text.foreground: black A -- Foreground color of the text editing area of the NEdit window.     .B nedit*text.background: gray90A -- Background color of the text editing area of the NEdit window.    .B nedit*text.blinkRate: 600- -- Blink rate of the text insertion cursor in , milliseconds.  Set to zero to stop blinking.   .B nedit*text.Translations: % -- Modifies key bindings (see below). # .SH Mapping Editor Commands to Keys K One of the most useful customizations to NEdit is to change the bindings of J editor actions to keys to fit a particular style of editing.  The appendixH lists the actions available in NEdit. To bind actions to keys, add lines1 similar to the following to your X resource file:   )     NEdit*text.Translations: #override \\  .br 4 	Ctrl<Key>v: insert-string("VEE!") process-up()\\n\\ .br / 	<Key>osfDelete: delete-previous-character()\\n   L You will need to refer to a book on the X window system for the exact syntaxL of translation tables.  Translation tables map key and mouse presses, windowG operations, and other kinds of events to actions.  The syntax (somewhat K oversimplified) is a keyword; #override, #augment, or #replace; followed by L lines (separated by newline characters) pairing events with actions.  EventsM begin with modifiers, like Ctrl, Shift, or Alt, followed by the event type in K <>.  BtnDown, Btn1Down, Btn2Down, Btn1Up, Key, KeyUp are valid event types. L For key presses, the event type is followed by the name of the key.  You canF specify a combination of events, such as a sequence of key presses, byN separating them with commas.  The other half of the event/action pair is a setL of actions.  These are separated from the event specification by a colon andF from each other by spaces.  Actions are names followed by parentheses,) optionally containing a single parameter. " .SH Changing Menu Accelerator KeysI The menu shortcut keys shown at the right of NEdit menu items can also be J changed via X resources.  Each menu item has two accelerator key resourcesK associated with it, accelerator, and acceleratorText.  accelerator sets the O actual event that triggers the menu item, and is in the same form as the events A for translation table entries discussed in the previous section.  N acceleratorText contains the entry that will be displayed with the menu item. I To construct the complete resource name, use one of *fileMenu, *editMenu, N *preferencesMenu, *windowsMenu, or *shellMenu, followed by `.' and the name ofM the menu item (lower case, run together with words separated by caps and with M all punctuation removed), followed by .accelerator, or .acceleratorText.  For E example, to change Cut to Ctrl+X, you would add the following to your  .Xdefaults file:  .     nedit*editMenu.cut.accelerator: Ctrl<Key>x.     nedit*editMenu.cut.acceleratorText: Ctrl+X  I Accelerator keys with optional shift key modifiers, like Find..., have an L additional .accelerator resource with Shift appended to the name.  To changeG the accelerator key for the Find... command to Alt+F, you would use the  following:    6    nedit*searchMenu.find.acceleratorText: [Shift]Alt+F/    nedit*searchMenu.find.accelerator: Alt<Key>f :    nedit*searchMenu.findShift.accelerator: Shift Alt<Key>f .SH AppendixJ This appendix is an excerpt from the Motif Programmer's Reference, listingJ editor functions that may be bound to keys.  These functions are valid forK other Motif text editing windows and text fields as well as for NEdit.  The L section titled "Customization" has instructions for binding these actions to key and mouse combinations.    .B backward-character() 5 Moves the insertion cursor one character to the left.    .B backward-paragraph(extend) J Moves the insertion cursor to the first non-whitespace character followingI the first previous blank line or beginning of the text.  If the insertion M cursor is already at the beginning of a paragraph, moves the insertion cursor + to the beginning of the previous paragraph.    .B backward-word(extend)J Moves the insertion cursor to the first non-whitespace character after theL first whitespace character to the left or the beginning of the line.  If theK insertion cursor is already at the beginning of a word, moves the insertion - cursor to the beginning of the previous word.   	 .B beep()  Causes the terminal to beep.   .B beginning-of-file(extend)8 Moves the insertion cursor to the beginning of the text.   .B beginning-of-line(extend)8 Moves the insertion cursor to the beginning of the line.   .B clear-selection()? Clears the current selection by replacing each character except " <Return> with a <space> character.   .B copy-clipboard() . Copies the current selection to the clipboard.   .B copy-primary() 5 Copies the primary selection to the insertion cursor.    .B copy-to()F If a secondary selection exists, copies the secondary selection to theG insertion cursor.  If no secondary selection exists, copies the primary  selection to the pointer location.    .B cut-clipboard(), Cuts the current selection to the clipboard.   .B cut-primary()3 Cuts the primary selection to the insertion cursor.    .B delete-next-character()D If the cursor is inside the selection, deletes the entire selection;@ otherwise, deletes the character following the insertion cursor.   .B delete-next-word() D If the cursor is inside the selection, deletes the entire selection;L otherwise, deletes the characters following the insertion cursor to the next$ space, tab or end of line character.   .B delete-previous-character()D If the cursor is inside the selection, deletes the entire selection;L otherwise, deletes the character of text immediately preceding the insertion cursor.    .B delete-previous-word() D If the cursor is inside the selection, deletes the entire selection;L otherwise, deletes the characters preceding the insertion cursor to the next* space, tab or beginning of line character.   .B delete-selection()  Deletes the current selection.   .B delete-to-end-of-line()M Deletes the characters following the insertion cursor to the next end of line 
 character.   .B delete-to-start-of-line()E Deletes the characters preceding the insertion cursor to the previous  beginning of line character.   .B deselect-all()   Deselects the current selection.   .B do-quick-action()L Marks the end of a secondary selection.  Performs the quick action initiated. by the quick-copy-set or quick-cut-set action.   .B end-of-file(extend)2 Moves the insertion cursor to the end of the text.   .B end-of-line(extend)2 Moves the insertion cursor to the end of the line.   .B extend-adjust()G Selects text from the anchor to the pointer position and deselects text L outside that range.  Moving the pointer over several lines selects text fromG the anchor to the end of each line the pointer moves over and up to the % pointer position on the current line.    .B extend-end() : Moves the insertion cursor to the position of the pointer.   .B extend-start() H Adjusts the anchor using the balance-beam method.  Selects text from theE anchor to the pointer position and deselects text outside that range.    .B forward-character()6 Moves the insertion cursor one character to the right.   .B forward-paragraph(extend)N Moves the insertion cursor to the first non-whitespace character following theJ next blank line.  If the insertion cursor is already at the beginning of aM paragraph, moves the insertion cursor to the beginning of the next paragraph.    .B forward-word(extend) K Moves the insertion cursor to the first whitespace character or end of line H following the next non-whitespace character.  If the insertion cursor isJ already at the end of a word, moves the insertion cursor to the end of the
 next word.   .B grab-focus() G This key binding performs the action defined in the  XmNselectionArray, N depending on the number of multiple mouse clicks.  The default selection arrayK ordering is one click to move the insertion cursor to the pointer position, L two clicks to select a word, three clicks to select a line of text, and fourK clicks to select all text.  A single click also deselects any selected text , and sets the anchor at the pointer position.   .B insert-string(string)M If the cursor is inside the selection, deletes the entire selection.  Inserts  string at the insertion cursor.    .B key-select(direction)M If called with an argument of right, moves the insertion cursor one character L to the right and extends the selection.  If called with an argument of left,D moves the insertion cursor one character to the left and extends the= selection. If called with no argument, extends the selection.    .B kill-next-character()E If  the cursor is inside the selection, deletes the entire selection. L Otherwise, kills the character following the insertion cursor and stores the character in the cut buffer.   .B kill-next-word() E If  the cursor is inside the selection, deletes the entire selection. I Otherwise, kills the characters following the insertion cursor to the cut  buffer.    .B kill-previous-character()D If the cursor is inside the selection, deletes the entire selection.J Otherwise, kills the character of text immediately preceding the insertion2 cursor and stores the character in the cut buffer.   .B kill-previous-word() D If the cursor is inside the selection, deletes the entire selection.J Otherwise, kills the characters preceding the insertion cursor to the nextK space, tab or beginning of line character, and stores the characters in the  cut buffer.    .B kill-selection() H Kills the currently selected text and stores the text in the cut buffer.   .B kill-to-end-of-line()K Kills the characters following the insertion cursor to the next end of line 6 character and stores the characters in the cut buffer.   .B kill-to-start-of-line()L Kills the characters preceding the insertion cursor to the next beginning of; line character and stores the characters in the cut buffer.    .B move-destination() G Moves the insertion cursor to the pointer position without changing any N existing selection.  If no selection exists, also moves the destination cursor to the pointer position.   .B move-to()N If a secondary selection exists, cuts the secondary selection to the insertionL cursor.  If no secondary selection exists, cuts the primary selection to the pointer location.    .B newline()M If the cursor is inside the selection, deletes the entire selection.  Inserts " a newline at the insertion cursor.   .B newline-and-backup() M If the cursor is inside the selection, deletes the entire selection.  Inserts L a newline and repositions the insertion cursor to the end of the line before the newline.   .B newline-and-indent() M If the cursor is inside the selection, deletes the entire selection.  Inserts E a newline and then the same number of whitespace characters as at the  beginning of the previous line.    .B next-line(), Moves the insertion cursor to the next line.   .B next-page(extend), Moves the insertion cursor forward one page.   .B page-left()1 Scrolls the viewing window left one page of text.    .B page-right() 2 Scrolls the viewing window right one page of text.   .B paste-clipboard()A Pastes the contents of the clipboard before the insertion cursor.    .B previous-line()0 Moves the insertion cursor to the previous line.   .B previous-page(extend)) Moves the insertion cursor back one page.    .B process-cancel() N Cancels the current extend-adjust() or secondary-adjust() operation and leaves3 the selection state as it was before the operation.    .B process-down() ) Moves the insertion cursor down one line.    .B process-home() 8 Moves the insertion cursor to the beginning of the line.   .B process-return()  Inserts a newline.   .B process-shift-down() ) Moves the insertion cursor down one line.    .B process-shift-up() ' Moves the insertion cursor up one line.    .B process-tab() Inserts a tab.   .B process-up() ' Moves the insertion cursor up one line.    .B quick-copy-set() C Marks the beginning of a secondary selection for use in quick copy.    .B quick-cut-set()B Marks the beginning of a secondary selection for use in quick cut.   .B redraw-display() ( Redraws the contents of the text window.   .B scroll-one-line-down() $ Scrolls the text area down one line.   .B scroll-one-line-up() " Scrolls the text area up one line.   .B secondary-adjust() 8 Extends the secondary selection to the pointer position.   .B secondary-notify() 9 Copies the secondary selection to the destination cursor.    .B secondary-start()- Marks the beginning of a secondary selection.    .B select-adjust()L Extends the selection.  The amount of text selected depends on the number of; mouse clicks as specified by the XmNselectionArray resource    .B select-all()  Selects all text.    .B select-end() L Extends the selection.  The amount of text selected depends on the number of= mouse clicks, as specified by the XmNselectionArray resource.    .B select-start() . Marks the beginning of a new selection region.   .B self-insert()M If the cursor is inside the selection, deletes the entire selection.  Inserts F the character associated with the key pressed at the insertion cursor.   .B set-anchor() K Resets the anchor point for extended selections.  Resets the destination of  secondary selection actions.   .B set-insertion-point() Sets the insertion position.   .B set-selection-hint() 3 Sets the text source and location of the selection.    .B toggle-add-mode() Toggles the state of Add Mode.   .B unkill() B Restores last killed text to the position of the insertion cursor.  M *****************************************************************************    ! Warning! Warning! Warning! ! G ! The resources in the $HOME/.nedit file override their corresponding X L ! resources in this file.  Either the $HOME/.nedit file should be deleted orN ! individual resource lines in the $HOME/.nedit file should be deleted for the( ! lines in this file to have any effect. ! : ! This file specifies the default resources used by NEdit. ! H ! You can use the examples below as a basis for your own customizations.H ! Copy and modify any of the resources below into your own NEdit file inL ! your app-defaults directory.  Any changes you make to your NEdit will take  ! effect when you restart nedit. !  ! Preferences file for NEdit !  !  NEdit.Geometry:				850x800+0+0 !  NEdit*background:			#b3b3b3  NEdit*foreground:			black   NEdit*text.background:			#e5e5e5 NEdit*text.foreground:			black( NEdit*statisticsLine.background:	#b3b3b3 !  NEdit*menuBar.marginHeight:	1  NEdit*pane.sashHeight:		11 NEdit*pane.sashWidth:		11 ! NEdit*text.selectionArrayCount:	3  ! B NEdit*fontList:		-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*B NEdit.textFont:		-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*H NEdit*XmList.fontList:	-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*H NEdit*XmText.fontList:	-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*M NEdit*XmTextField.fontList: -adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*  !  NEdit*XmText*foreground:		black ! NEdit*XmText*background:		#cccccc  NEdit*XmList*foreground:		black ! NEdit*XmList*background:		#cccccc & NEdit*XmTextField*background:		#cccccc$ NEdit*XmTextField*foreground:		black ! 0 NEdit*fileMenu.tearOffModel:		XmTEAR_OFF_ENABLED0 NEdit*editMenu.tearOffModel:		XmTEAR_OFF_ENABLED2 NEdit*searchMenu.tearOffModel:		XmTEAR_OFF_ENABLED6 NEdit*preferencesMenu.tearOffModel:	XmTEAR_OFF_ENABLED3 NEdit*windowsMenu.tearOffModel:		XmTEAR_OFF_ENABLED 1 NEdit*shellMenu.tearOffModel:		XmTEAR_OFF_ENABLED 0 NEdit*helpMenu.tearOffModel:		XmTEAR_OFF_ENABLED !  NEdit*fileMenu.mnemonic:			F, NEdit*fileMenu.new.accelerator:			Ctrl<Key>n+ NEdit*fileMenu.new.acceleratorText:		Ctrl+N , NEdit*fileMenu.open.accelerator:		Ctrl<Key>o, NEdit*fileMenu.open.acceleratorText:		Ctrl+O3 NEdit*fileMenu.openSelected.accelerator		Ctrl<Key>y 3 NEdit*fileMenu.openSelected.acceleratorText:	Ctrl+Y - NEdit*fileMenu.close.accelerator:		Ctrl<Key>w - NEdit*fileMenu.close.acceleratorText:		Ctrl+W , NEdit*fileMenu.save.accelerator:		Ctrl<Key>s, NEdit*fileMenu.save.acceleratorText:		Ctrl+S3 NEdit*fileMenu.includeFile.accelerator:		Ctrl<Key>i 2 NEdit*fileMenu.includeFile.acceleratorText:	Ctrl+I- NEdit*fileMenu.print.accelerator:		Ctrl<Key>p - NEdit*fileMenu.print.acceleratorText:		Ctrl+P , NEdit*fileMenu.exit.accelerator:		Ctrl<Key>q, NEdit*fileMenu.exit.acceleratorText:		Ctrl+Q NEdit*editMenu.mnemonic:			E, NEdit*editMenu.undo.accelerator:		Ctrl<Key>z, NEdit*editMenu.undo.acceleratorText:		Ctrl+Z2 NEdit*editMenu.redo.accelerator:		Shift Ctrl<Key>z2 NEdit*editMenu.redo.acceleratorText:		Shift+Ctrl+Z2 NEdit*editMenu.cut.accelerator:			Shift<Key>Delete. NEdit*editMenu.cut.acceleratorText:		Shift+Del1 NEdit*editMenu.copy.accelerator:		Ctrl<Key>Insert . NEdit*editMenu.copy.acceleratorText:		Ctrl+Ins3 NEdit*editMenu.paste.accelerator:		Shift<Key>Insert 0 NEdit*editMenu.paste.acceleratorText:		Shift+Ins* NEdit*editMenu.clear.acceleratorText:		Del1 NEdit*editMenu.selectAll.accelerator:		Ctrl<Key>a 0 NEdit*editMenu.selectAll.acceleratorText:	Ctrl+A1 NEdit*editMenu.shiftLeft.accelerator:		Ctrl<Key>9 7 NEdit*editMenu.shiftLeft.acceleratorText:	[Shift]Ctrl+9 ; NEdit*editMenu.shiftLeftShift.accelerator:	Shift Ctrl<Key>9 3 NEdit*editMenu.shiftRight.accelerator:		Ctrl<Key>0: 8 NEdit*editMenu.shiftRight.acceleratorText:	[Shift]Ctrl+0< NEdit*editMenu.shiftRightShift.accelerator:	Shift Ctrl<Key>02 NEdit*editMenu.capitalize.accelerator:		Ctrl<Key>61 NEdit*editMenu.capitalize.acceleratorText:	Ctrl+6 7 NEdit*editMenu.lowerCase.accelerator:		Shift Ctrl<Key>6 6 NEdit*editMenu.lowerCase.acceleratorText:	Shift+Ctrl+64 NEdit*editMenu.fillParagraph.accelerator:	Ctrl<Key>j4 NEdit*editMenu.fillParagraph.acceleratorText:	Ctrl+J9 NEdit*editMenu.insertFormFeed.accelerator:	Alt Ctrl<Key>l 9 NEdit*editMenu.insertFormFeed.acceleratorText:	Alt+Ctrl+L 4 NEdit*editMenu.insControlCode.accelerator:	Alt<Key>c4 NEdit*editMenu.insControlCode.acceleratorText:	Alt+C !  NEdit*searchMenu.mnemonic:			S. NEdit*searchMenu.find.accelerator:		Ctrl<Key>f5 NEdit*searchMenu.find.acceleratorText:		[Shift]Ctrl+F 9 NEdit*searchMenu.findShift.accelerator:		Shift Ctrl<Key>f 2 NEdit*searchMenu.findSame.accelerator:		Ctrl<Key>g8 NEdit*searchMenu.findSame.acceleratorText:	[Shift]Ctrl+G< NEdit*searchMenu.findSameShift.accelerator:	Shift Ctrl<Key>g6 NEdit*searchMenu.findSelection.accelerator:	Ctrl<Key>h= NEdit*searchMenu.findSelection.acceleratorText:	[Shift]Ctrl+H @ NEdit*searchMenu.findSelectionShift.accelerator:Shift Ctrl<Key>h1 NEdit*searchMenu.replace.accelerator:		Ctrl<Key>r 7 NEdit*searchMenu.replace.acceleratorText:	[Shift]Ctrl+R ; NEdit*searchMenu.replaceShift.accelerator:	Shift Ctrl<Key>r 4 NEdit*searchMenu.replaceSame.accelerator:	Ctrl<Key>t; NEdit*searchMenu.replaceSame.acceleratorText:	[Shift]Ctrl+T ? NEdit*searchMenu.replaceSameShift.accelerator:	Shift Ctrl<Key>t 2 NEdit*searchMenu.gotoLine.accelerator:		Ctrl<Key>l1 NEdit*searchMenu.gotoLine.acceleratorText:	Ctrl+L 5 NEdit*searchMenu.gotoSelected.accelerator:	Ctrl<Key>e 5 NEdit*searchMenu.gotoSelected.acceleratorText:	Ctrl+E / NEdit*searchMenu.match.accelerator:		Ctrl<Key>m / NEdit*searchMenu.match.acceleratorText:		Ctrl+M 7 NEdit*searchMenu.findDefinition.accelerator:	Ctrl<Key>d 6 NEdit*searchMenu.findDefinition.acceleratorText:Ctrl+D ! $ NEdit*preferencesMenu.mnemonic:				P9 NEdit*preferencesMenu.overstrike.accelerator:		Ctrl<Key>b 8 NEdit*preferencesMenu.overstrike.acceleratorText:	Ctrl+B; NEdit*preferencesMenu.statisticsLine.accelerator:	Alt<Key>a ; NEdit*preferencesMenu.statisticsLine.acceleratorText:	Alt+A  !  NEdit*shellMenu.mnemonic:				l8 NEdit*shellMenu.filterSelection.accelerator:		Ctrl<Key>k7 NEdit*shellMenu.filterSelection.acceleratorText:	Ctrl+K 6 NEdit*shellMenu.executeCommand.accelerator:		Alt<Key>k6 NEdit*shellMenu.executeCommand.acceleratorText:		Alt+K> NEdit*shellMenu.executeCommandLine.accelerator:		<Key>KP_Enter< NEdit*shellMenu.executeCommandLine.acceleratorText:	KP Enter !  NEdit*windowsMenu.mnemonic:			W 5 NEdit*windowsMenu.splitWindow.accelerator:	Ctrl<Key>2 5 NEdit*windowsMenu.splitWindow.acceleratorText:	Ctrl+2 3 NEdit*windowsMenu.closePane.accelerator:	Ctrl<Key>1 3 NEdit*windowsMenu.closePane.acceleratorText:	Ctrl+1  !  NEdit*helpMenu.mnemonic:			H  