#include <stdio.h>
#include <string.h>

#include <rms.h>
#include <starlet.h>

struct FAB dbfab;
struct RAB dbrab;

void db_open(char *fnm)
{
   long stat;
   struct XABKEY dbxab;
   dbfab = cc$rms_fab;
   dbfab.fab$l_fna = fnm;
   dbfab.fab$b_fns = strlen(fnm);
   dbfab.fab$b_org = FAB$C_IDX;
   dbfab.fab$b_rfm = FAB$C_FIX;
   dbfab.fab$b_rat = FAB$M_CR;
   dbfab.fab$l_fop = FAB$M_CIF;
   dbfab.fab$w_mrs = 96;
   dbfab.fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_UPD;
   dbfab.fab$l_xab = (char *)&dbxab;
   dbxab = cc$rms_xabkey;
   dbxab.xab$b_dtp = XAB$C_STG;
   dbxab.xab$w_pos0 = 0;
   dbxab.xab$b_ref = 0;
   dbxab.xab$b_siz0 = 16;
   stat = sys$create(&dbfab,0,0);
   dbfab.fab$l_xab = 0;
   dbrab = cc$rms_rab;
   dbrab.rab$l_fab = &dbfab;
   dbrab.rab$b_rac = RAB$C_KEY;
   stat = sys$connect(&dbrab,0,0);
   return;
}

void db_put(char *key,char *data)
{
   long stat;
   char buf[96];
   memcpy(buf,key,16);
   memcpy(buf+16,data,80);
   dbrab.rab$l_rbf = buf;
   dbrab.rab$w_rsz = 96;
   stat = sys$put(&dbrab,0,0);
   return;
}

int db_get(char *key,char *data)
{
   long stat;
   char buf[96];
   dbrab.rab$l_kbf = key;
   dbrab.rab$b_ksz = strlen(key);
   dbrab.rab$b_krf = 0;
   dbrab.rab$l_ubf = buf;
   dbrab.rab$w_usz = 96;
   stat = sys$get(&dbrab,0,0);
   if(stat&1) {
      memcpy(data,buf+16,80);
      data[81] = '\0';
      return 1;
   } else {
      return 0;
   }
}

void db_close()
{
   long stat;
   stat = sys$disconnect(&dbrab,0,0);
   stat = sys$close(&dbfab,0,0);
   return;
}

int main()
{
   char data[256];
   db_open("tstc.db");
   db_put("A","This is the first record");
   db_put("BB","This is the second record");
   db_put("CCC","This is the third record");
   if(db_get("BB",data)) {
      printf("%s\n",data);
   } else {
      printf("BB not found\n");
   }
   if(db_get("DDDD",data)) {
      printf("%s\n",data);
   } else {
      printf("DDDD not found\n");
   }
   db_close();
}

