#include <stdio.h>
#include <string.h>

#include <rms.h>
#include <starlet.h>

#include <jni.h>

#include "tstjava.h"

struct FAB dbfab;
struct RAB dbrab;

JNIEXPORT void JNICALL Java_tstjava_db_1open
  (JNIEnv *cntx, jobject me, jstring fnm)
{
   long stat;
   struct XABKEY dbxab;
   const char *fnm2 = (*cntx)->GetStringUTFChars(cntx,fnm,0);
   dbfab = cc$rms_fab;
   dbfab.fab$l_fna = (char *)fnm2;
   dbfab.fab$b_fns = strlen(fnm2);
   dbfab.fab$b_org = FAB$C_IDX;
   dbfab.fab$b_rfm = FAB$C_FIX;
   dbfab.fab$b_rat = FAB$M_CR;
   dbfab.fab$l_fop = FAB$M_CIF;
   dbfab.fab$w_mrs = 96;
   dbfab.fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_UPD;
   dbfab.fab$l_xab = (char *)&dbxab;
   dbxab = cc$rms_xabkey;
   dbxab.xab$b_dtp = XAB$C_STG;
   dbxab.xab$w_pos0 = 0;
   dbxab.xab$b_ref = 0;
   dbxab.xab$b_siz0 = 16;
   stat = sys$create(&dbfab,0,0);
   dbfab.fab$l_xab = 0;
   dbrab = cc$rms_rab;
   dbrab.rab$l_fab = &dbfab;
   dbrab.rab$b_rac = RAB$C_KEY;
   stat = sys$connect(&dbrab,0,0);
   (*cntx)->ReleaseStringUTFChars(cntx,fnm,fnm2);
   return;
}

JNIEXPORT void JNICALL Java_tstjava_db_1put
  (JNIEnv *cntx, jobject me, jstring key, jstring data)
{
   long stat;
   char buf[96];
   const char *key2 = (*cntx)->GetStringUTFChars(cntx,key,0);
   const char *data2 = (*cntx)->GetStringUTFChars(cntx,data,0);
   memcpy(buf,key2,16);
   memcpy(buf+16,data2,80);
   dbrab.rab$l_rbf = buf;
   dbrab.rab$w_rsz = 96;
   stat = sys$put(&dbrab,0,0);
   (*cntx)->ReleaseStringUTFChars(cntx,key,key2);
   (*cntx)->ReleaseStringUTFChars(cntx,data,data2);
   return;
}

char data[81];

JNIEXPORT jboolean JNICALL Java_tstjava_db_1get1
  (JNIEnv *cntx, jobject me, jstring key)
{
   long stat;
   char buf[96];
   const char *key2 = (*cntx)->GetStringUTFChars(cntx,key,0);
   dbrab.rab$l_kbf = (char *)key2;
   dbrab.rab$b_ksz = strlen(key2);
   dbrab.rab$b_krf = 0;
   dbrab.rab$l_ubf = buf;
   dbrab.rab$w_usz = 96;
   stat = sys$get(&dbrab,0,0);
   (*cntx)->ReleaseStringUTFChars(cntx,key,key2);
   if(stat&1) {
      memcpy(data,buf+16,80);
      data[81] = '\0';
      return 1;
   } else {
      return 0;
   }
}

JNIEXPORT jstring JNICALL Java_tstjava_db_1get2
  (JNIEnv *cntx, jobject me)
{
   return (*cntx)->NewStringUTF(cntx,data);
}

JNIEXPORT void JNICALL Java_tstjava_db_1close
  (JNIEnv *cntx, jobject me)
{
   long stat;
   stat = sys$disconnect(&dbrab,0,0);
   stat = sys$close(&dbfab,0,0);
   return;
}

