program tstpas(input,output);

type
   string  = varying[256] of char;
   db_rec = record
               key  : [KEY(0)] packed array [1..16] of char;
               data : packed array [1..80] of char;
            end;

var
   db_file : file of db_rec;

procedure db_open(fnm:string);

begin
   open(db_file,fnm,new,organization:=indexed,access_method:=keyed);
   resetk(db_file,0);
end;

procedure db_put(key:string;data:string);

var
   tmp : db_rec;
   i   : integer;

begin
   for i := 1 to key.length do tmp.key[i] := key.body[i];
   for i := (key.length + 1) to 16 do tmp.key[i] := chr(0);
   for i := 1 to data.length do tmp.data[i] := data.body[i];
   for i := (data.length + 1) to 80 do tmp.data[i] := chr(0);
   db_file^ := tmp;
   put(db_file);
end;

function db_get(key:string;var data:string):boolean;

var
   tmp : db_rec;
   i   : integer;

begin
   findk(db_file,0,key);
   if ufb(db_file) then begin
      db_get := false;
   end else begin
      tmp := db_file^;
      for i := 1 to 80 do data.body[i] := tmp.data[i];
      data.length := index(tmp.data,chr(0));
      db_get := true;
   end;
end;

procedure db_close;

begin
   close(db_file);
end;

var
   data : string;

begin
   db_open('tstpas.db');
   db_put('A','This is the first record');
   db_put('BB','This is the second record');
   db_put('CCC','This is the third record');
   if db_get('BB',data) then
      writeln(data)
   else
      writeln('BB not found');
   if db_get('DDDD',data) then
      writeln(data)
   else
      writeln('DDDD not found');
   db_close;
end.

