#/p/perl/perl -w
#
# ======================================================================
# This file is copyright 1998 by the Purdue Research Foundation and may
# only be used under license.  For terms of the license, see the file
# named COPYRIGHT included with this software release.
# ======================================================================
#
# Agent for checking for repeated login failures.
#
# AAFID project, COAST Laboratory, 1998.
# 
# Diego Zamboni, Mar 16, 1998.
#
# $Id: LoginFailures.pm,v 1.2 1999/06/08 05:02:00 zamboni Exp $
# $Log: LoginFailures.pm,v $
# Revision 1.2  1999/06/08 05:02:00  zamboni
# Merged branch a06-raw-data-collection into main trunk
#
# Revision 1.1.1.1.6.1  1999/06/07 19:51:20  zamboni
# Regenerated from aas file
#
# Revision 1.1.1.1  1998/08/12 22:11:35  zamboni
# AAFID2 prototype as released to COAST sponsors.
#
# Revision 1.2  1998/06/29 20:57:44  zamboni
# Added Copyright notice.
#
# Revision 1.1  1998/06/05 20:50:40  zamboni
# Initial revision
#
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package LoginFailures;

# The following makes the agent version number keep up with the RCS
# version number. The self-assignment at the end keeps the -w switch
# from complaining (because $VERSION may not be used here, but it is
# used in our base class).
$VERSION = do { my @r = (q$Revision: 1.2 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; $VERSION = $VERSION;

########################################################################
# AGENT PARAMETERS
# Important, set them here

%PARAMETERS=(
	     Description	=> "Check for repeated login failures",
	     # CheckPeriod may be omitted, it defaults to 10 seconds.
	     CheckPeriod	=> 10,  # Seconds
	     MyFileToCheck	=> '/var/adm/messages',
	     SumPeriod          => 300, # period to monitor, seconds
	    );

########################################################################

# This is optional; you may remove it, but don't, it will save your
# life some day.
use strict;
use AAFID::Agent;
use AAFID::Common;
use Util::NumQueue;

use vars qw(
	    @ISA
	    $VERSION
	    %PARAMETERS
	   );

# Define the superclasses of our agent.
@ISA=qw(AAFID::Agent);

=head1 Description

Report number of failed login messages in the last SumPeriod seconds.

=head1 Implementation

Here we go.

=cut

sub Init {
  my $self=checkref(shift);
  my $queue=Util::NumQueue->new;

  $self->openfile($self->getParameter('MyFileToCheck'));

  $queue->timelength($self->getParameter('SumPeriod'));
  $self->setParameter(MyQueue => $queue);

  return $self;
}

sub openfile {
  my $self=checkref(shift);
  my $fname=shift;
  if ($fname) {
    my $file=IO::File->new($fname);
    if (!$file) {
      $self->Log("errors", "Error opening $fname: $!\n");
      return undef;
    }
    $self->Log("debug", "File $fname opened successfully.\n");
    $self->setParameter(MyFileHandle => $file);
    $file->seek(0,2);
    return $self;
  }
  else {
    $self->Log("debug", "No file name provided, waiting.\n");
    return $self;
  }
}

sub Check {
  my $self=checkref(shift);
  my $queue=$self->getParameter('MyQueue');

  my $file=$self->getParameter('MyFileHandle');
  my ($month,$day,$hour,$min,$sec,$host,$prog,$term,$wherefrom);

  if ($file) {
    my $count=$self->getParameter('MyCount') || 0;
    $file->seek(0,1);
    while (<$file>) {
      $self->Log("debug", "Line read: $_");
      next unless /REPEATED LOGIN FAILURES/;
      chop;
      ($month,$day,$hour,$min,$sec,$host,$prog,$term,$wherefrom)=
	(split(/[\s:]+/))[0,1,2,3,4,5,6,11,13];
      $count++;
      $queue->add(1);
      $self->setParameter('MyCount' => $count);
    }
    $count=10 if $count>10;
    $self->Log("debug", 
	       "Returning ($count, Failed login messages: $count)\n");
    my $status=$queue->sum;
    return ($status>10?10:$status, "$status");
  }
  return (0, "No file to monitor has been specified");
}

# Syntax: SETFILE File => 'file'
sub command_SETFILE {
  my ($self, $message, %params)=@_;
  if ($params{File}) {
    $self->Log("debug", "Setting file to monitor: $params{File}\n");
    $self->setParameter(MyFileToCheck => $params{File});
    if ($self->openfile($self->getParameter('MyFileToCheck'))) {
      return undef;
    }
    else {
      return {Error => "Error opening $params{File}: $!"};
    }
  }
  else {
    $self->Log("debug", "No File parameter provided.\n");
    return undef;
  }
}

_EndOfEntity;
