eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID project, COAST Laboratory, CERIAS, 1998-1999.
#
# Susana Soriano, August 11, 1998.
#
# $Id: Ftcpw.pm,v 1.9 1999/09/03 17:09:00 zamboni Exp $
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package Filter::Ftcpw; 

use AAFID::Filter;
use AAFID::Entity;
use AAFID::Common;

use vars qw(
	%PARAMETERS
	@ISA
	    );

%PARAMETERS=(
	     LogFile_Name => '+/var/log/inetdlog'
	    );

@ISA=qw(AAFID::Filter);

=pod

This is a filter which uses the logfile "inetdlog" to obtain
information about TCP-Wrapper. This filter uses the basic subroutines
that are defined in Filter.pm, and this filter just defines the
specific subroutines that have to be used for itself.

=head1 Getting the patterns and Selecting the information.

The agent sends patterns to the filter in order to select specific
information.  The filter split the lines into fields to be more
careful about what information is choosen. In this way, the filter
looks for the line on the logfile which matches with the pattern and
reconstructs it to the original format. Once this process is done, the
filter send the information in the original format to the agent.  

=cut

sub makefield {
  my $self=checkref(shift);
  my $line=shift;
  my @subline;
  my @substring;
  my @subpid;
  my @pid;
  # Split into blank-separated fields
  @subline=split(" ",$line);
  if (@subline != 8) {
    $self->Log("errors", "Invalid line, ignoring: $line\n");
    return undef;
  }
  # If "from" is of the form "user@host", get that too.
  if ($subline[7] =~ /.*\@.*/){
    @substring=split(/\@/, $subline[7]);
  }
  else {
    $substring[0]="";
    $substring[1]=$subline[7];
  }
  # Split "daemon[pid]" into its parts.
  @subpid=split(/\[/, $subline[4]);
  @pid=split(/\]/, $subpid[1]);
  # Assign the fields.
  return { Month   => $subline[0],
	   Day     => $subline[1],
	   Time    => $subline[2],
	   To      => $subline[3],
	   Daemon  => $subpid[0],
	   Pid	   => $pid[0],
	   Type    => $subline[5],
	   Garbage => $subline[6],
	   Who     => $substring[0],
	   From    => $substring[1],
	 }
}

sub makeline {
  my $self=checkref(shift);
  my $line=shift;
  my $from;
  # Rebuild the "from" field appropriately.
  if ($line->{Who}) {
    $from="$line->{Who}\@$line->{From}";
  }
  else {
    $from=$line->{From};
  }
  return "$line->{Month} $line->{Day} $line->{Time} $line->{To} $line->{Daemon}".
         "\["."$line->{Pid}"."\]:"." $line->{Type} $line->{Garbage} $from";
}

_EndOfEntity;
  
#
# $Log: Ftcpw.pm,v $
# Revision 1.9  1999/09/03 17:09:00  zamboni
# Changed the start line to something that is path-independent, and
# updated the copyright notice.
#
# Revision 1.8  1999/09/03 17:03:05  zamboni
# Added standard comment block.
#
# Revision 1.7  1999/06/28 21:22:10  zamboni
# Merged with a07-port-to-linux
#
# Revision 1.6.4.1  1999/06/28 19:44:56  zamboni
# - Modified the LogFile_Name parameter.
#
# Revision 1.6  1999/03/29 22:33:34  zamboni
# Merged branch a05-new-comm-module, which updates it to make use of the new event-based communication mechanism.
#
# Revision 1.5.4.1  1999/03/29 17:26:52  zamboni
# - Changed LogFile_Name from "/var/log/inetdlog" to "+/var/log/inetdlog".
#
# Revision 1.5  1998/09/09 18:42:31  zamboni
# *** empty log message ***
#
# Revision 1.4  1998/09/09 09:07:48  zamboni
# * Ftcpw.pm: Clean up and general fixes.
#
# Revision 1.3  1998/09/03 21:16:05  zamboni
# Made some fixed (change Ftcpw to Filter::Ftcpw, etc.)
#
# Revision 1.2  1998/09/03 04:15:48  zamboni
# Removed the mail header lines.
#
#
