// $Id: $
//
// $Log: $
// Revision 1.0  1998/03/24  raif
// + start of history.
//
// $Endlog$
/*
 * Copyright (c) 1997, 1998 Systemics Ltd on behalf of
 * the Cryptix Development Team. All rights reserved.
 */
package NIST;

import java.io.PrintWriter;
import java.security.InvalidKeyException;

//...........................................................................
/**
 * A concrete implementation of level-0 API for a null cipher.<p>
 *
 * Portions of this code are <b>Copyright</b> &copy; 1997, 1998
 * <a href="http://www.systemics.com/">Systemics Ltd</a> on behalf of the
 * <a href="http://www.systemics.com/docs/cryptix/">Cryptix Development Team</a>.
 * <br>All rights reserved.<p>
 *
 * <b>$Revision: $</b>
 * @author  Raif S. Naffah
 */
public final class NIST_Algorithm // implicit no-argument constructor
{
// Debugging methods and variables
//...........................................................................

    static final String NAME = "NIST_Algorithm";
    static final boolean IN = true, OUT = false;

    static final boolean DEBUG = NIST_Properties.GLOBAL_DEBUG;
    static final int debuglevel = DEBUG ? NIST_Properties.getLevel(NAME) : 0;
    static final PrintWriter err = DEBUG ? NIST_Properties.getOutput() : null;

    static final boolean TRACE = NIST_Properties.isTraceable(NAME);

    static void debug (String s) { err.println(">>> "+NAME+": "+s); }
    static void trace (boolean in, String s) {
        if (TRACE) err.println((in?"==> ":"<== ")+NAME+"."+s);
    }
    static void trace (String s) { if (TRACE) err.println("<=> "+NAME+"."+s); }



// Constants and variables
//...........................................................................

    static final int BLOCK_SIZE = 16; // bytes in a data-block


// Static code - to intialise S-box and permutation tables if any
//...........................................................................

    static {
        //
        // precompute eventual S-box tables
        //
    }


// *_Algorithm static methods
//...........................................................................
    
    /** @return The default length in bytes of an AES input block. */
    public static int blockSize() { return BLOCK_SIZE; }

    /**
     * Expand a user-supplied key material into an AES session key.
     *
     * @param key  The 128/192/256-bit user-key to use.
     * @return  This cipher's round keys.
     * @exception  InvalidKeyException  If the key is invalid.
     */
    public static synchronized Object makeKey (byte[] k)
    throws InvalidKeyException {
if (DEBUG) trace(IN, "makeKey("+k+")");
        //
        //...
        //
        Object sessionKey = null;
        //
        // ...
        //
if (DEBUG) trace(OUT, "makeKey()");
        return sessionKey;
    }

    /**
     * Encrypt exactly one block of plaintext.
     *
     * @param in          The plaintext.
     * @param inOffset    Index of in from which to start considering data.
     * @param sessionKey  The session key to use for encryption.
     * @return The ciphertext generated from a plaintext using the session key.
     */
    public static byte[]
    blockEncrypt (byte[] in, int inOffset, Object sessionKey) {
if (DEBUG) trace(IN, "blockEncrypt("+in+", "+inOffset+", "+sessionKey+")");
        //
        // ....
        //
        byte[] result = new byte[BLOCK_SIZE];
	    //
	    // ...
	    //
        System.arraycopy(in, inOffset, result, 0, BLOCK_SIZE);
if (DEBUG) trace(OUT, "blockEncrypt()");
        return result;
    }

    /**
     * Decrypt exactly one block of ciphertext.
     *
     * @param in          The ciphertext.
     * @param inOffset    Index of in from which to start considering data.
     * @param sessionKey  The session key to use for decryption.
     * @return The plaintext generated from a ciphertext using the session key.
     */
    public static byte[]
    blockDecrypt (byte[] in, int inOffset, Object sessionKey) {
if (DEBUG) trace(IN, "blockDecrypt("+in+", "+inOffset+", "+sessionKey+")");
        //
        // ....
        //
        byte[] result = new byte[BLOCK_SIZE];
	    //
	    // ...
	    //
        System.arraycopy(in, inOffset, result, 0, BLOCK_SIZE);
if (DEBUG) trace(OUT, "blockDecrypt()");
        return result;
    }


// Self-test method
//...........................................................................

    /** @return True iff passes self-test. */ 
    public static boolean self_test() {
if (DEBUG) trace(IN, "self_test()");
        boolean ok = false;
        try {
            byte[] kb = new byte[BLOCK_SIZE];
            byte[] pt = new byte[BLOCK_SIZE];
            int i;

            for (i = 0; i < BLOCK_SIZE; i++)
                kb[i] = (byte) i;
            for (i = 0; i < BLOCK_SIZE; i++)
                pt[i] = (byte) i;

            Object key = makeKey(kb);

            byte[] ct =  blockEncrypt(pt, 0, key);
            byte[] cpt = blockDecrypt(ct, 0, key);

            ok = areEqual(pt, cpt);
            if (!ok)
                throw new RuntimeException("Symmetric operation failed");
        }
        catch (Exception x) {
if (DEBUG) debug("Exception encountered during self-test: " + x.getMessage());
            x.printStackTrace();
        }
if (DEBUG) debug("Self-test OK? " + ok);
        trace(OUT, "self_test()");
        return ok;
    }


// utility static method (from cryptix.util.core ArrayUtil class)
//...........................................................................
    
    /** @return True iff the arrays have identical contents. */
    private static boolean areEqual (byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) return false;
        for (int i = 0; i < aLength; i++)
            if (a[i] != b[i])
                return false;
        return true;
    }
}
