$!
$! This procedure builds the FT_ACCPORNAM.EXE shareable image.  The VAX MACRO
$! source for this image is embedded within this command procedure.
$!
$! Author:	David Jones
$! Date:	23-MAY-1999
$! Revised:	26-MAY-1999		! cleanup for VAX
$!
$ gosub assemble		! generate ft_accpornam.obj
$!
$ if f$getsyi("CPU") .ge. 128
$ then
$!   Alpha build.
$!
$ link/share=sys$disk:ft_accpornam.exe sys$input/option/sysexe/selective_search
IDENTIFICATION="OSU hack 1.0"
ft_accpornam.obj
SYMBOL_VECTOR=(fta_initialize=PROCEDURE,fta_set_accpornam=PROCEDURE)
GSMATCH=LEQUAL,1,0
$!
$ else
$!
$!   Vax build.  We don't need transfer vector since loading will be done
$!   via FIND_IMAGE_SYMBOL.
$!
$ link/share=sys$disk:ft_accpornam.exe sys$input/option,sys$system:sys.stb/select
IDENTIFICATION="OSU hack 1.0"
ft_accpornam.obj
sys$system:sysdef.stb/selective
UNIVERSAL=fta_initialize
UNIVERSAL=fta_set_accpornam
GSMATCH=LEQUAL,1,0
$ endif
$ exit $status
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$assemble:
$ if f$getsyi("CPU") .GE. 128 then macro = "macro/migrate"
$ macro/object=sys$disk:[]ft_accpornam.obj sys$input
$ DECK
;++
; ACCPORNAM hack for FTDRIVER.
;
; This module provides routines that let a privileged caller set the
; TT_ACCPORNAM value for pseudo-terminal devices (PTD).  This hackery is
; done is 2 parts:
;
;    The initialization step that increases the UCB$W_SIZE field int
;    FTA0's UCB by 64 bytes.  The assumption is that this will cause
;    subsequent FTAxxx creations to allocate the larger size.  An
;    unused portion of FTDRIVER's DDB is used to save the original size
;    of the UCB.
;
;    A set routine for loading the FTAxxx field.  Caller specifies the
;    terminal to modify via a channel assigned to that terminal.
;
; External Functions (C interface):
;
;    fta_initialize();
;
;    fta_set_accpornam (
;	int chan,		/* channel assigned to FTAxxx device */
;	int length,		/* Length of new string, range 0-63 */
;	char *accpornam );	/* New string */
;
; Return values are VMS status codes.
;
; Note that these functions are not thread-safe, caller must take steps to
; serialize the calls (pthread_lock_global_np) in a multi-threaded environment.
;
; Author:  David Jones, derived from work by Brian Schenkenberger.
; Date:	   23-MAY-1999
;--
;++
; Copyright  1999 by Brian Schenkenberger
; ALL RIGHTS RESERVED.
;                            Notice of Disclaimer
;                         -------------------------
; 
; This Software is provided "AS IS" and is supplied for informational purpose
; only.  No warranty is expressed or implied and no liability can be accepted
; for any direct, indirect or consequential damages or for any damage whatso-
; ever resulting in the loss of systems, data or profit from the use of this
; software or from any of the information contained herein.  The author makes
; no claims as to the suitablility or fitness of this Software or information
; contain herein for any particular purpose.  
;--
	.TITLE	FT_ACCPORNAM
	.IDENT	/V01.0/

;++
.SBTTL	Determine the target architecture
;--
	.NTYPE	...ON_ALPHA...,R31
	.IIF EQ,<...ON_ALPHA...@-4&^XF>-5, ALPHA=0
	.IIF DF,ALPHA, .DISABLE	FLAGGING

;++
.SBTTL	Primitive program datum definitions
;--
	ZERO = 0		; |_ 
	BYTE = 1@0		; |_|_ 
	WORD = 1@1		; |___|___ 
	LONG = 1@2		; |_______|_______
	QUAD = 1@3		; |_______________|_______________
	OCTA = 1@4		; |_______________|_______________|
	PAGE = 1@9		; VAX page ; Alpha Pagelet
	BLOCK= 1@9		; Standard disk block size

;++
.SBTTL	Macro declarations for architectural conditional compilation
;--
	.MACRO	.ON_AXP	OPERATIONS	; conditional compilation macro
	.IF DF	ALPHA			;    for code specific to Alpha
	.IRP	OPERATION,<OPERATIONS>	;
	OPERATION
	.ENDR
	.ENDC
	.ENDM	.ON_AXP;OPERATIONS

	.MACRO	.ON_VAX	OPERATIONS	; conditional compilation macro
	.IF NDF	ALPHA			;    for code specific to VAX
	.IRP	OPERATION,<OPERATIONS>	;
	OPERATION
	.ENDR
	.ENDC
	.ENDM	.ON_VAX;OPERATIONS

;++
; The following macro is used to check the return status of system calls.
; It can take up to three arguments:
;   STS ...... register or memory containing the status value
;   ERROR .... instruction to execute if an error is detected
;   NORMAL ... change status to a success before taking ERROR
;--
	.MACRO	CHKSTS,STS=<R0>,NORMAL=<NO>,ERROR=<RET>,?LBL
	.IIF DIF,<R0>,<STS>,	MOVZWL	STS,R0
	.IIF IDN,<NORMAL>,<NO>,	BLBS	R0,LBL
	.IIF DIF,<NORMAL>,<NO>,	BBSS	#0,R0,LBL
	.IRP	ERR,<ERROR>
	.SHOW	MEB
	ERR
	.NOSHOW	MEB
	.ENDR
LBL:	.ENDM	CHKSTS


	.LIBRARY	"SYS$LIBRARY:STARLET.MLB"		; look here for:

	$DCDEF
	$DSCDEF
	$LIB$ROUTINESDEF


	.LIBRARY	"SYS$LIBRARY:LIB.MLB"		; look here for:

	$CCBDEF
	$DDBDEF
	$UCBDEF
	$TTYUCBDEF

;++
.sbttl	DATA PSECT
;--
	.PSECT	DATA,WRT,NOEXE,LONG

CHANNEL: .LONG			; I/O channel assigned to terminal

NEWTXT:	.BLKB 64		; Storage for counted ASCII string.

	.ALIGN	LONG
DEVICE:	.ASCID	/FTA0/		; Template device name.
EXTEND:	.ASCII	/xtnd/		; Signature for DDB

	.ALIGN	LONG
FTA:	.ASCIC	/FTA/		; Device name in UCB.

LOCK_PAGE:	.ADDRESS	DEVICE,LOCK_PAGE	


;
;	The following offsets are relative to end of UCB$T_NAME field.  This 
;	field is 16 bytes in size and the first 4 bytes must be preserved
;	since they carry the counted ASCII string 'FTA'.  Therefore only
;	12 bytes total are usable for our purposes.
;
	$OFFSET	0,NEGATIVE,<-
		<EXT_ACCPORNAM,<64>>,>		; 40(16)/64(10) bytes

	$OFFSET	0,NEGATIVE,<-
		<EXT_MARKER_ID,LONG>,-		; space for extend id
		<EXT_ORG_SIZE,LONG>,>		; space original size

;++
.sbttl	CODE PSECT
;--
	.PSECT	CODE,NOWRT,EXE,LONG
;;;;;;;;;;;;
; Initialize function
;
	.ENTRY FTA_INITIALIZE,0

	$LKWSET_S	INADR=LOCK_PAGE
	CHKSTS

	$CMKRNL_S	ROUTIN=FTA_TEMPLATE_ZAP
	RET

;;;;;;;;;;;;
	.ENTRY	FTA_SET_ACCPORNAM,^M<R2,R3,R4>
	;
	; Move arguments into local storage, converting args 2,3 into
	; a single counted ASCII string (will get a user-mode ACCVIO if
	; caller supplies invalid argument.
	;
	MOVZWL	4(AP), CHANNEL		; I/O channel.
	MOVL	8(AP), R1		; Size of string.
	MOVL	#SS$_BADPARAM, R0
	CMPL	R1, #63			; Is greater?
	BGTR	80$			;  Yes, abort;
	MOVB	R1, NEWTXT		; Save string.
	MOVC3	R1, @12(AP), <NEWTXT+1>
	;
	; Lock down the code pages and perform fixup of UCB in kernel mode.
        ;
	$LKWSET_S	INADR=LOCK_PAGE
	CHKSTS

	$CMKRNL_S	ROUTIN=FTA_ACCPORNAM_ZAP
80$:
	RET
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Following code is executed in kernel mode, use extreme care.
;
; The FTA_TEMPLATE_ZAP function overwrites UCB$W_SIZE in  FTA0's UCB, saving
; the original size in an unusd portion of FTA's DDB
;
	.ENTRY	FTA_TEMPLATE_ZAP,^M<R2,R3,R4,R5>
.ON_AXP	<<$LOCK_PAGE ERROR=100$>>	; use $LOCK_PAGE macro on AXP

.ON_VAX <-
        <PUSHAB	100$>,-			; push adr of routine end
	<PUSHAB	10$>,-			; push adr of routine start
	<MOVAB	(SP),R0>,-		; save adr of INADR arg
	<$LKWSET_S INADR=(R0)>,-	; lock WS/no paging @IPL$_SCHED
	<CHKSTS> -			; locked down tight?
	>

	;++
	; jsb	sch$iolockr
	;	input:	r4 : pcb address
	;	output:	     I/O mutex locked
	;--
10$:	MOVL	@#CTL$GL_PCB,R4		; get our PCB address
	JSB	@#SCH$IOLOCKR		; lock I/O database for read

	;++
	; jsb	ioc$searchdev
	;	input:	r1 : device name
	;	output:	r0 : status
	;		r1 : device UCB
	;		r2 : device DDB
	;--
	MOVAL	DEVICE,R1		; get device descriptor
	JSB	@#IOC$SEARCHDEV		; search I/O database for its UCB
	BLBC	R0,30$			; no can do? get out...

	MOVAB	(R1),R5			; put the UCB in traditional R5

	MOVL	#SS$_IVDEVNAM,R0	; assume its not a terminal
	CMPB	#DC$_TERM,UCB$B_DEVCLASS(R5)	; check this assumption
	BNEQ	30$			; assumption correct?  get out...
	
;++
; Here is the special processing for "extended" FTAn devices...
;--
	MOVL	UCB$L_DDB(R5),R2	; get terminal's DDB address

	ASSUME	DDB$T_NAME&<LONG-1> EQ 0; assume longword alignment

	CMPL	FTA,DDB$T_NAME(R2)	; check if it's an FT device
	BNEQ	30$			; no? no chance of extension

.ON_AXP	<<ASSUME DDB$PS_DPT-DDB$T_NAME EQ 16>>
.ON_VAX	<<ASSUME DDB$T_DRVNAME-DDB$T_NAME EQ 16>>

.ON_AXP	<<MOVAB	DDB$PS_DPT(R2),R3>>	; get extend id area address
.ON_VAX	<<MOVAB	DDB$T_DRVNAME(R2),R3>>	; get extend id area address
	
	CMPL	EXTEND,EXT_MARKER_ID(R3); was this UCB extended?
	BEQL	20$			; FT template already done...

	MOVL	EXTEND,EXT_MARKER_ID(R3); mark this UCB extended
	MOVZWL	UCB$W_SIZE(R5),-	; store original UCB size
		EXT_ORG_SIZE(R3)
	ADDW2	#64,UCB$W_SIZE(R5)	; increase UCB template size

20$:	MOVL	#SS$_NORMAL,R0		; report success...

;++
; Success or failure, all processing falls through to here.
;--

30$:	PUSHL	R0			; error or success gets here

	;++
	; jsb	sch$iounlock
	;	input:	r4 : pcb address
	;	output:	     I/O mutex unlocked
	;--
	MOVL	@#CTL$GL_PCB,R4
	JSB	@#SCH$IOUNLOCK
	POPL	R0				; restore routine status code

.ON_AXP	$UNLOCK_PAGE

100$:	RET

;;;;;;;;;;;
;
; Kernel-mode routine to actually blast a new string into the ACCPORNAM
; field.
;
	.ENTRY FTA_ACCPORNAM_ZAP,^M<R2,R3,R4,R5,R6,R7,R8>
.ON_AXP	<<$LOCK_PAGE ERROR=100$>>	; use $LOCK_PAGE macro on AXP

.ON_VAX <-
        <PUSHAB	100$>,-			; push adr of routine end
	<PUSHAB	10$>,-			; push adr of routine start
	<MOVAB	(SP),R0>,-		; save adr of INADR arg
	<$LKWSET_S INADR=(R0)>,-	; lock WS/no paging @IPL$_SCHED
	<CHKSTS> -			; locked down tight?
	>

	;++
	; jsb	sch$iolockr
	;	input:	r4 : pcb address
	;	output:	     I/O mutex locked
	;--
10$:	MOVL	@#CTL$GL_PCB,R4		; get our PCB address
        ;
	; Locate CCB for device assigned to channel, then put UCB address
	; in R5;
	;
	MOVL	CHANNEL, R0		; Channel assigned to device.
	JSB	G^IOC$VERIFYCHAN
	BLBS	R0, 20$			; continue iff success.
	BRW	90$			; branch to cleanup point
20$:
	MOVL	CCB$L_UCB(R1), R5

	JSB	@#SCH$IOLOCKR		; lock I/O database for read

	MOVL	#SS$_IVDEVNAM,R0	; assume its not a terminal
	CMPB	#DC$_TERM,UCB$B_DEVCLASS(R5)	; check this assumption
	BNEQ	50$			; assumption correct?  get out...
	
;++
; 	Here is the special processing for "extended" FTAn devices...
;       Do sanity checks to ensure we only update proper FTA devices.
;--
	MOVL	UCB$L_DDB(R5),R2	; get terminal's DDB address

	ASSUME	DDB$T_NAME&<LONG-1> EQ 0; assume longword alignment

	MOVL	#SS$_BADPARAM, R0;	; assume not an FT device.
	CMPL	FTA,DDB$T_NAME(R2)	; check if it's an FT device
	BNEQ	50$			; no? no chance of extension

.ON_AXP	<<ASSUME DDB$PS_DPT-DDB$T_NAME EQ 16>>
.ON_VAX	<<ASSUME DDB$T_DRVNAME-DDB$T_NAME EQ 16>>

.ON_AXP	<<MOVAB	DDB$PS_DPT(R2),R3>>	; get extend id area address
.ON_VAX	<<MOVAB	DDB$T_DRVNAME(R2),R3>>	; get extend id area address
	
	MOVL	#SS$_OPINCOMPL,R0	; assume no ACCPORNAM field
	CMPL	EXTEND,EXT_MARKER_ID(R3); was template UCB extended?
	BNEQ	50$			; no? can't write the ACCPORNAM
	CMPW	UCB$W_SIZE(R5),-	; was *this* UCB extended?
		EXT_ORG_SIZE(R3)
	BEQL	50$			; no? can't write the ACCPORNAM


;++
;       UCB verified, now set ACCPORNAM field.
;--
30$:	MOVZWL	UCB$W_SIZE(R5),R4	; get this UCB's size
	MOVAB	EXT_ACCPORNAM(R5)[R4],-	; store the ACCPORNAM address
		UCB$L_TT_ACCPORNAM(R5)
	MOVB	#63,@UCB$L_TT_ACCPORNAM(R5)	; max length is 63 bytes
	BISW2	#TTY$M_PC_ACCPORNAM,-	; mark UCB as having ACCPORNAM
		UCB$W_TT_PRTCTL(R5)

	MOVAB	NEWTXT, R1		; New source string.
	MOVZBL	(R1), R2		; Length of string.
	BGTR	40$			; Skip if length positive
	BICW2	#TTY$M_PC_ACCPORNAM,-	; mark UCB as having no ACCPORNAM
		UCB$W_TT_PRTCTL(R5)
	CLRL	R2
	CLRL	NEWTXT			; Ensure zero length

40$:	INCL	R2			; Include the count byte
	MOVL	UCB$L_TT_ACCPORNAM(R5),R3	; Destination
	MOVC3	R2, (R1), (R3)		; Copy to system space.
	MOVL	#SS$_NORMAL,R0		; report success...

;++
; Success or failure, all processing falls through to here.
;--

50$:	PUSHL	R0			; error or success gets here

	;++
	; jsb	sch$iounlock
	;	input:	r4 : pcb address
	;	output:	     I/O mutex unlocked
	;--
	MOVL	@#CTL$GL_PCB,R4
	JSB	@#SCH$IOUNLOCK
	POPL	R0				; restore routine status code
90$:
.ON_AXP	$UNLOCK_PAGE
100$:
	RET
	.END
$ EOD
$ RETURN
