$! procedure to scan the source files in a directory tree given by P1
$! and produce a file list with checksums.  The default output is 
$! check_files.out, but it may be overridden by specifying the output file in 
$! P2.
$!
$ gosub make_crc_engine
$ type_set = ".C.H.COM."
$ cur_dir = f$environment("DEFAULT")
$ if P1 .nes. "" then set default 'p1'
$ dir = f$environment("DEFAULT")
$ if P1 .nes. "" then set default 'cur_dir'
$ dir = f$extract(0,f$length(dir)-1,dir)
$ search_spec = dir + "...]*.*;"
$ open/write out 'f$parse(P2,"check_files.out")'
$ on error then goto cleanup
$ on control_y then goto cleanup
$!
$ prev_dir = ""
$ next_file:
$    file = f$search(search_spec)
$    if file .eqs. "" then goto cleanup
$    t = f$parse(file,,,"TYPE","SYNTAX_ONLY") + "."
$    if f$locate(t,type_set) .ge. f$length(type_set) then goto next_file
$!
$    file = file - f$parse(file,,,"VERSION","SYNTAX_ONLY")
$    cur_dir = f$parse(file,,,"DIRECTORY","SYNTAX_ONLY")
$    if f$length(cur_dir) .lt. f$length(prev_dir) then -
		write sys$output "Resuming ", cur_dir
$    if f$length(cur_dir) .gt. f$length(prev_dir) then -
		write sys$Output "Scanning ", cur_dir
$!
$    text_crc 'file' crc_value
$    write out f$extract(f$length(dir),255,file), " ", crc_value
$    prev_dir = cur_dir
$    goto next_file
$ cleanup:
$ close out
$ exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ make_crc_engine:
$ text_crc = "$sys$disk:[]text_crc"
$ if f$search("text_crc.exe") .nes. "" then return
$ write sys$output "Building text_crc.exe image..."
$ cc sys$input/object=sys$disk:[]text_crc.obj
$ deck
/*
 * Compute the CRC for the lines of a text file.  Record terminators and
 * blank lines are ignored.  The CRC value is stored in a DCL symbol.
 */
#include <stdio.h>
#include <descrip.h>
#include <ssdef.h>
#include <string.h>
int LIB$CRC(), LIB$CRC_TABLE(), LIB$SET_SYMBOL();

int main ( int argc, char **argv )
{
    int indicator, i, status;
    long crc, coeff, table[16];
    FILE *src;
    static char buffer[8192], number[32];
    static $DESCRIPTOR(buffer_dx,buffer);
    static $DESCRIPTOR(symname_dx,"");
    static $DESCRIPTOR(number_dx,number);

    if ( argc < 3 ) {
	fprintf(stderr, "Usage: text_crc file result-symbol\n" );
	return SS$_BADPARAM;
    }

    src = fopen ( argv[1], "r", "mbc=64" );
    if ( !src ) { perror ( "Error opening input file" ); return SS$_ABORT; }
    /*
     * Initialize for CRC calcuation.
     */
    crc = 0;
    coeff = 0xedb88320;
    LIB$CRC_TABLE ( &coeff, table );
    /*
     * Read the file.
     */
    while ( fgets ( buffer, sizeof(buffer), src ) ) {
	/*
	 * Determine record length and add to crc.
	 */
	for ( i = 0; buffer[i] && buffer[i] != '\n'; i++ );
	if ( i == 0 ) continue;

	buffer_dx.dsc$w_length = i;
	crc = LIB$CRC ( table, &crc, &buffer_dx );
    }
    /*
     * Save to symbol.
     */
    sprintf(number,"%d", crc);
    symname_dx.dsc$w_length = strlen(argv[2]);
    symname_dx.dsc$a_pointer = argv[2];
    number_dx.dsc$w_length = strlen(number);
    indicator = 1;
    status = LIB$SET_SYMBOL ( &symname_dx, &number_dx, &indicator );
    return status;
}
$ eod
$ link text_crc.obj/exe=text_crc.exe
$ return
