/*
 */
#ifndef CPORT_DEFINED
#define CPORT_DEFINED 1

typedef struct { int fill[8]; } *cport_port;	/* opaque */

typedef struct cport_io_sync_block *cport_isb;

typedef int (*cport_start_function) ( cport_isb isb,
	int func,			/* function code */
	void *buffer,
	int length );
/*
 * A stream handler is a dispatch table of callouts to the 'driver' functions
 * for a stream.
 */
typedef struct cport_stream_dispatch_table {
    int fmask;
    cport_start_function *ftable;		/* (fmask+1) entries */

    int (*attach) ( cport_isb isb,
		void *arg1, int arg2, 
		char errmsg[256] );
    int (*detach) ( cport_isb isb );

    int (*cancel) ( cport_isb isb );
} cport_stream_handler;
/*
 * Define the I/O synchronization block (ISB).
 */
struct cport_isb_qhead {
    cport_isb flink;			/* forward link */
    cport_isb blink;			/* backward link */
};
struct cport_io_sync_block {
    struct cport_isb_qhead q;		/* Do not modify */
    void *user_ptr;
    int user_val;
    int length;				/* Saved from start_io call. */
    void *buffer;			/* Saved from start_io call */
    void *iosb;				/* initally points to default_iosb */
    /*
     * The following fields should only be accessed by cport routines and
     * stream handlers.
     */
    cport_port port;
    cport_stream_handler driver;
    int timer;				/* 0-none, 1-set, 2-expired */
    void *timeout;			/* opaque timer info */
    short int channel, flags;
    short int default_iosb[4];		/* default IOSB upon allocation */
    /*
     * The completion callback routine lets a driver perform multiple I/Os
     * for a single wait.  When the cport_next_completion function detects
     * a completion callback, the isb is moved to the processed queue
     * and then the callback routine is called.  The final disposition
     * of the isb is determined by the callback's return value:
     *   0 - place isb on 'busy' queue for re-process when isb->iosb[0];
     *       becomes non-null;
     *   1 - Place isb on 'completed' queue.
     *   2 - Place isb on 'processed' queue and deliver.
     */
    int (*completion_callback) ( cport_isb isb );
    /*
     * If wrapper is non-null, I/O completion of this ISB will
     * signal a completion event on the wrapper ISB and the current
     * completion will not end the wait.  This allows for nesting of
     * driver calls.
     */
    cport_isb wrapper;
    /*
     * The following fields are for use by stream handlers/drivers.
     */
#ifndef CPORT_DRIVER_SPECIFIC
#define CPORT_DRIVER_SPECIFIC void
#endif
    CPORT_DRIVER_SPECIFIC *drv;		/* pointer to driver-specific data */
};
/*
 * Define prototypes for functions called by users of cport objects.
 */
cport_port cport_create_port ( int flags );

int cport_destroy_port ( cport_port port );

cport_isb cport_assign_channel ( cport_port cport, 
	void *device, 			/* device for SYS$ASSIGN */
	int flags );			/* flags arg for SYS$ASSIGN */

cport_isb cport_assign_stream ( 
	cport_port cport, 
	cport_stream_handler *handler,  
	void *arg1, int arg2 );

int cport_last_assign_status ( cport_port port_handle, char errmsg[256] );

int cport_deassign ( cport_isb isb );

int cport_cancel ( cport_isb isb );

int cport_set_timeout ( cport_isb isb, int seconds, int nanoseconds );
/*
 * The QIO functions take VMS IO$_* function codes for the func argument.
 */
int cport_qio ( cport_isb, int func, void *p1, void *p2, void *p3,
	void *p4, void *p5, void *p6 );

int cport_qio2 ( cport_isb isb, int func, void *p1, int p2 );

int cport_start_io ( cport_isb, int func, void *buffer, int length );
/*
 * wait routines.  next_completion stalls until next I/O completed and
 * returns the isb of the completed I/O.  Cport_do_io starts an I/O,
 * waits for it to finish, and extracts the length and status from the
 * iosb.  Events that complete in the interim are placed back on the
 * completed queue.
 */
cport_isb cport_next_completion ( cport_port );
int cport_do_io ( 
	cport_isb isb, int func, void *buffer, int length, int	*transferred );
/*
 * Define standard functions codes for generic streams.  ISBs created
 * with assign_channel may be passed to cport_start_io using the
 * generic functions.
 */
#define CPORT_WRITE 0			/* write buffer, IO$_WRITEVBLK */
#define CPORT_READ 1			/* read buffer, IO$_READVLKB */
#define CPORT_FCODES 2			/* Number of fcodes defined incl. 0 */
/*
 * routines used by stream handlers.
 */
int cport_mark_busy ( cport_isb isb );	/* move isb to busy queue */
int cport_mark_completed ( cport_isb isb, int is_busy );
void cport_completion_ast ( cport_isb isb );
int cport_lock_port ( cport_isb isb );
int cport_unlock_port ( cport_isb isb, int signal_completion );
int cport_copy_timeout ( cport_isb src, cport_isb dst );
/*
 * Define return codes for completion callback functions.
 */
#define CPORT_COMPLETE_BUSY 0			/* Remain on busy queue */
#define CPORT_COMPLETE_COMPLETED 1		/* Deliver to user */
#define CPORT_COMPLETE_PROCESSED 2		/* normal case */
#endif
